package cn.com.duiba.jdactivity.developer.jd.utils;

import cn.com.duiba.jdactivity.BaseTest;
import cn.com.duiba.jdactivity.common.vo.Result;
import cn.com.duiba.jdactivity.developer.jd.constant.JdAppEnum;
import com.alibaba.fastjson.JSON;
import com.jd.open.api.sdk.domain.crm.VenderCustomerClientJsfService.response.getCustomer.EssentialCustomerInfo;
import com.jd.open.api.sdk.domain.market.PurchaseServiceProvider.response.getPurchaseInfo.PurchaseForJos;
import com.jd.open.api.sdk.domain.user.CrmCustomerService.response.getMemberInVender.CustomerInfoEs;
import com.jd.open.api.sdk.domain.user.UserRelatedRpcService.response.getUserInfoByOpenId.OAuthUserInfo;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.Test;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2021/5/19 18:09
 */
class JdApiUtilTest extends BaseTest {

    private static final String accessToken;
    private static final String token;
    private static final Long shopId;
    private static final Long venderId;
    private static final String pin;

    static {
        accessToken = "51a1123d18064b969a2c773546998c12ntfh";
        token = "AAFg0zTjADBq_27niwCDbCdJWLXmFpXDjjUb_KtoUVKV59Lq8W5ObIs3RjfJbxhICmxLlZ6kc9Q";
        shopId = 10139787L;
        venderId = 10276497L;
        pin = "yi皮仔";
        // pin = "jd_7c13099e13f1b";
    }

    @Resource
    private JdApiUtil jdApiUtil;

    @Test
    @Order(0)
    void venderShopQuery() {
        // for (int i = 0; i < 1000; i++) {
        //     long now = System.currentTimeMillis();
        //     Result<ShopJosResult> shopJosResultResult = jdApiUtil.venderShopQuery(JdAppEnum.DUIBA, "7ab5b3444e3e4c06ba06a8181133c8c7inwi");
        //     System.out.println("耗时" + (System.currentTimeMillis() - now));
        // }

        System.out.println(JSON.toJSONString(jdApiUtil.venderShopQuery(JdAppEnum.DUIBA, accessToken)));
    }

    @Test
    void getPinByToken() {
        Result<String> result = jdApiUtil.getPinByToken(JdAppEnum.DUIBA, accessToken, "01", token);
        System.out.println(JSON.toJSONString(result));
        Assertions.assertTrue(result.getSuccess());
    }

    @Test
    void getEncryptPinNewByToken() {
        Result<String> result = jdApiUtil.getEncryptPinNewByToken(JdAppEnum.DUIBA, accessToken, "01", token);
        System.out.println(JSON.toJSONString(result));
        Assertions.assertTrue(result.getSuccess());
    }

    @Test
    void OAuthUserInfo() {
        Result<String> result = jdApiUtil.getOpenIdByToken(JdAppEnum.DUIBA, "01", token);
        System.out.println(JSON.toJSONString(
                result));
        Assertions.assertTrue(result.getSuccess());

        Result<OAuthUserInfo> result2 = jdApiUtil.getUserInfoByOpenId(JdAppEnum.DUIBA, accessToken, result.getData());
        System.out.println(JSON.toJSONString(
                result2));
        Assertions.assertTrue(result2.getSuccess());
    }

    @Test
    void getCustomer() {
        Result<EssentialCustomerInfo> result = jdApiUtil.getCustomer(JdAppEnum.DUIBA, accessToken, pin);
        System.out.println(JSON.toJSONString(
                result));
        Assertions.assertTrue(result.getSuccess());
    }

    @Test
    void isFollowByPinAndVid() {
        Result<Boolean> result = jdApiUtil.isFollowByPinAndVid(JdAppEnum.DUIBA, pin, shopId);
        System.out.println(JSON.toJSONString(
                result));
        Assertions.assertTrue(result.getSuccess());
    }

    @Test
    void followByPinAndVid() {
        Result<Boolean> result = jdApiUtil.followByPinAndVid(JdAppEnum.DUIBA, pin, shopId, accessToken);
        System.out.println(JSON.toJSONString(
                result));
        Assertions.assertTrue(result.getSuccess());
    }

    @Test
    void getMemberInVender() {
        Result<CustomerInfoEs> result = jdApiUtil.getMemberInVender(JdAppEnum.DUIBA, "01", token);
        System.out.println(JSON.toJSONString(
                result));
        Assertions.assertTrue(result.getSuccess());
    }

    // @Test
    void createCoupon() {
        System.out.println(JSON.toJSONString(
                jdApiUtil.createCoupon(JdAppEnum.DUIBA, accessToken,
                        "测试优惠券-排行榜-01", 50)));
    }


    // @Test
    void lockCoupon() {
        System.out.println(JSON.toJSONString(
                jdApiUtil.lockCoupon(JdAppEnum.DUIBA, accessToken, 365488621L)));
    }

    // @Test
    void pushCoupon() {
        System.out.println(JSON.toJSONString(jdApiUtil.pushCoupon(JdAppEnum.DUIBA, accessToken, 365488621L, pin, "1")));
    }

    @Test
    void sendPoints() {
        Result<Boolean> result = jdApiUtil.sendPoints(JdAppEnum.DUIBA, pin, "businessId", 100, "给你100积分", accessToken);
        System.out.println(JSON.toJSONString(result));
        Assertions.assertTrue(result.getSuccess());
    }

    @Test
    void addCartItemByPin() {
        Result<Boolean> result = jdApiUtil.addCartItemByPin(JdAppEnum.DUIBA, pin, "10021084856048", 101, accessToken);
        System.out.println(JSON.toJSONString(
                result));
        Assertions.assertTrue(result.getSuccess());
    }

    @Test
    @Order(0)
    void getPurchaseInfo() {
        Result<List<PurchaseForJos>> result = jdApiUtil.getPurchaseInfo(JdAppEnum.DUIBA, accessToken);
        System.out.println(JSON.toJSONString(
                result));
        Assertions.assertTrue(result.getSuccess());
    }

    @Test
    void sendBean() {
        Result<Boolean> result = jdApiUtil.sendBean(JdAppEnum.DUIBA, accessToken, "3", 1L,
                10276497L, 1334575L,
                pin, "签到获得");
        System.out.println(JSON.toJSONString(result));
        Assertions.assertTrue(result.getSuccess());
    }
}