package cn.com.duiba.jdactivity.service;

import cn.com.duiba.jdactivity.BaseTest;
import cn.com.duiba.jdactivity.developer.jd.constant.JdAppEnum;
import cn.com.duiba.jdactivity.dto.TbShopAccessTokenDto;
import com.alibaba.fastjson.JSON;
import org.junit.jupiter.api.Test;

import javax.annotation.Resource;
import java.util.Date;

/**
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2021/5/17 20:29
 */
class TbShopAccessTokenServiceTest extends BaseTest {
    @Resource
    private TbShopAccessTokenService tbShopAccessTokenService;

    @Test
    public void queryById() {
        TbShopAccessTokenDto tbShopAccessTokenDto = tbShopAccessTokenService.queryById(1L);
        System.out.println(JSON.toJSONString(tbShopAccessTokenDto));
    }

    @Test
    void queryByVenderIdShopId() {
    }

    @Test
    public void insert() {
        TbShopAccessTokenDto tbShopAccessTokenDto = new TbShopAccessTokenDto();
        tbShopAccessTokenDto.setVenderId(1L);
        tbShopAccessTokenDto.setShopId(2L);
        tbShopAccessTokenDto.setShopName("测试w店铺");
        tbShopAccessTokenDto.setAccessToken("c99865d29305423b87693b8c511c6799zdi5");
        tbShopAccessTokenDto.setRefreshToken("42ad2fd369e7461abf644e8cb0459a3fdjhz");
        tbShopAccessTokenDto.setExpiresTime(new Date(1621230623954L));
        tbShopAccessTokenDto.setAccessTokenOriginal("{\n" +
                "    \"access_token\": \"c99865d29305423b87693b8c511c6799zdi5\",\n" +
                "    \"expires_in\": 86399,\n" +
                "    \"refresh_token\": \"42ad2fd369e7461abf644e8cb0459a3fdjhz\",\n" +
                "    \"scope\": \"snsapi_base\",\n" +
                "    \"open_id\": \"hin2kGWWyBuhQP0mv-IQoBxyxEhk5qUMWNnTrAmzEII\",\n" +
                "    \"uid\": \"2731075896\",\n" +
                "    \"time\": 1621230623954,\n" +
                "    \"token_type\": \"bearer\",\n" +
                "    \"code\": 0\n" +
                "}");
        tbShopAccessTokenDto.setAppKey(JdAppEnum.DUIBA.getAppKey());
        Long insert = tbShopAccessTokenService.insert(tbShopAccessTokenDto);
        System.out.println(insert);
    }

    @Test
    void update() {
    }

    @Test
    void deleteById() {
    }
}