package cn.com.duiba.jdactivity.controller;

import cn.com.duiba.credits.sdk.CreditTool;
import cn.com.duiba.credits.sdk.SignTool;
import cn.com.duiba.jdactivity.common.utils.AESCS7Util;
import cn.com.duiba.jdactivity.common.utils.RequestTool;
import cn.com.duiba.jdactivity.common.utils.UrlUtils;
import cn.com.duiba.jdactivity.common.vo.Result;
import cn.com.duiba.jdactivity.common.vo.ResultBuilder;
import cn.com.duiba.jdactivity.developer.duiba.DuibaAppEnum;
import cn.com.duiba.jdactivity.developer.jd.constant.JdAppEnum;
import cn.com.duiba.jdactivity.developer.jd.constant.JdShopEnum;
import cn.com.duiba.jdactivity.developer.jd.constant.JdTokenSourceEnum;
import cn.com.duiba.jdactivity.developer.jd.utils.AccessTokenUtils;
import cn.com.duiba.jdactivity.developer.jd.utils.JdApiUtil;
import cn.com.duiba.jdactivity.dto.*;
import cn.com.duiba.jdactivity.exception.BizException;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.jd.open.api.sdk.domain.crm.VenderCustomerClientJsfService.response.getCustomer.EssentialCustomerInfo;
import com.jd.open.api.sdk.domain.user.UserRelatedRpcService.response.getUserInfoByOpenId.OAuthUserInfo;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * 开放给星速台的接口
 *
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2021/5/17 13:26
 */
@RestController
@RequestMapping("/open2Duiba")
public class Open2DuibaController {
    public static final Logger LOGGER = LoggerFactory.getLogger(Open2DuibaController.class);
    public static final String ENCRYPT_KEY = "JuGi3FCECD1dA2BPL1lCWC==";
    //默认超时或提前5分钟
    private static final long DEFAULT_EXPIRE_TIME = 5 * 60 * 1000L;
    @Resource
    private JdApiUtil jdApiUtil;
    @Resource
    private AccessTokenUtils accessTokenUtils;

    /**
     * 根据环境获取不同的免登录地址
     */
    private static String getAutologinHome(String env) {
        if (StringUtils.isBlank(env)) {
            env = "";
        }
        env = env.toLowerCase();
        String path = "/autoLogin/autologin";
        String host;
        switch (env) {
            case "dev":
                host = "http://activity.m.duibadev.com.cn";
                break;
            case "test":
                host = "http://activity.m.duibatest.com.cn";
                break;
            case "pre":
                host = "http://activity.m.duibapre.com.cn";
                break;
            default:
                // 默认为线上
                host = "http://activity.m.duiba.com.cn";
                break;
        }
        return host + path;
    }

    /**
     * 签名校验
     */
    private static void signVerify(String method) throws BizException {
        //后期若多个项目调用可改为注解方式
        HttpServletRequest request = RequestTool.getHttpServletRequest();
        final Map<String, String> parameterMap = RequestTool.getRequestParamMap(request);
        LOGGER.info(method + "参数：" + JSON.toJSONString(parameterMap));

        //前后5分钟内有效
        String timestamp = request.getParameter("timestamp");
        String appKey = request.getParameter("appKey");
        String sign = request.getParameter("sign");
        DuibaAppEnum duibaAppEnum = DuibaAppEnum.getDuibaApp(appKey);
        if (duibaAppEnum == null) {
            throw new BizException("appKey不存在");
        }
        long clientTimestamp = timestamp == null ? 0L : Long.parseLong(timestamp);
        long now = System.currentTimeMillis();
        if (Math.abs(now - clientTimestamp) > DEFAULT_EXPIRE_TIME) {
            throw new BizException(String.format("请同步服务器与客户端时间为%s分钟之内", DEFAULT_EXPIRE_TIME));
        }

        //验签sign
        Map<String, String> signMap = new HashMap<>(parameterMap);
        signMap.remove("sign");
        signMap.put("appSecret", duibaAppEnum.getAppSecret());
        String correctSign = SignTool.sign(signMap);

        boolean signVerify = Objects.equals(correctSign, sign);
        boolean verify = SignTool.signVerify(duibaAppEnum.getAppSecret(), request);

        LOGGER.info("signVerify={},verify={},correctSign={}", signVerify, verify, correctSign);
        // 二选一，只要有一个正确就通过
        if (!signVerify && !verify) {
            throw new BizException("签名校验不正确");
        }

    }

    /**
     * 签名校验
     */
    private static <T extends DuibaUserParam> void signVerify4Post(T param, String method) throws BizException {
        String jsonString = JSON.toJSONString(param);
        LOGGER.info(method + "参数：" + jsonString);


        JSONObject object = JSON.parseObject(jsonString);

        //前后5分钟内有效
        String timestamp = param.getTimestamp();
        String appKey = param.getAppKey();
        String sign = param.getSign();
        DuibaAppEnum duibaAppEnum = DuibaAppEnum.getDuibaApp(appKey);
        if (duibaAppEnum == null) {
            throw new BizException("appKey不存在");
        }
        long clientTimestamp = timestamp == null ? 0L : Long.parseLong(timestamp);
        long now = System.currentTimeMillis();
        if (Math.abs(now - clientTimestamp) > DEFAULT_EXPIRE_TIME) {
            throw new BizException(String.format("请同步服务器与客户端时间为%s分钟之内", DEFAULT_EXPIRE_TIME));
        }


        Map<String, String> parameterMap = Maps.newHashMapWithExpectedSize(object.size());
        for (Map.Entry<String, Object> entry : object.entrySet()) {
            parameterMap.put(entry.getKey(), entry.getValue().toString());
        }

        //验签sign
        Map<String, String> signMap = new HashMap<>(parameterMap);
        signMap.remove("sign");
        signMap.put("appSecret", duibaAppEnum.getAppSecret());
        String correctSign = SignTool.sign(signMap);

        boolean signVerify = Objects.equals(correctSign, sign);

        LOGGER.info("signVerify={},correctSign={}", signVerify, correctSign);
        // 二选一，只要有一个正确就通过
        if (!signVerify) {
            throw new BizException("签名校验不正确");
        }
    }

    /**
     * 微信、京东端 用户登陆后跳转到星速台
     *
     * @return
     */
    @PostMapping("/autologin")
    public Result<String> autologin(@RequestBody AutologinParam autologinParam) {
        try {
            LOGGER.info("autologin,autologinParam={}", JSON.toJSONString(autologinParam));
            String token = autologinParam.getToken();
            String source = JdTokenSourceEnum.JD.getSource();
            String redirectUrl = autologinParam.getRedirectUrl();
            String env = autologinParam.getEnv();

            Long venderId = autologinParam.getVenderId();
            Long shopId = autologinParam.getShopId();
            if (venderId == null && shopId == null) {
                //最开始波司登无这两个参数
                venderId = JdShopEnum.BOSIDENG.getVenderId();
                shopId = JdShopEnum.BOSIDENG.getShopId();
            }

            // 兑吧应用
            DuibaAppEnum duibaApp = Optional
                    .ofNullable(DuibaAppEnum.getDuibaApp(autologinParam.getAppKey()))
                    .orElse(DuibaAppEnum.BOSIDENG_PROD);

            TbShopAccessTokenDto accessToken = accessTokenUtils.getAccessTokenWithCache(venderId, shopId);
            LOGGER.info("获取accessToken,结果={}", JSON.toJSONString(accessToken));

            JdAppEnum appByAppKey = JdAppEnum.getAppByAppKey(accessToken.getAppKey());
            Result<String> pinByToken = jdApiUtil.getPinByToken(appByAppKey, accessToken.getAccessToken(), source, token);
            LOGGER.info("获取pin,结果={}", JSON.toJSONString(pinByToken));

            Result<String> openIdByToken = jdApiUtil.getOpenIdByToken(appByAppKey, source, token);
            LOGGER.info("获取openId,结果={}", JSON.toJSONString(openIdByToken));

            Result<OAuthUserInfo> userInfoByOpenId = jdApiUtil.getUserInfoByOpenId(appByAppKey, accessToken.getAccessToken(), openIdByToken.getData());
            LOGGER.info("获取userInfo,结果={}", JSON.toJSONString(userInfoByOpenId));
            String uid = convert2Uid(appByAppKey, accessToken.getAccessToken(), pinByToken.getData());
            LOGGER.info("加密pin,pin={},uid={}", pinByToken.getData(), uid);
            String nickName = userInfoByOpenId.getData().getNickName();
            String avatar = userInfoByOpenId.getData().getImageUrl();
            String credits = null;
            if (StringUtils.equals(autologinParam.getNeedCredits(), "1")) {
                Result<Long> customerPoints = jdApiUtil.getCustomerPoints(appByAppKey, pinByToken.getData(), accessToken.getAccessToken());
                credits = String.valueOf(customerPoints.getData());
            }

            String autoLogin = autologin(duibaApp, uid, nickName, avatar, redirectUrl, env, credits);
            LOGGER.info("autoLogin={}", autoLogin);
            return ResultBuilder.success(autoLogin);
        } catch (BizException e) {
            return ResultBuilder.fail(e.getMessage());
        } catch (Exception e) {
            LOGGER.error("跳转异常", e);
            return ResultBuilder.fail("跳转异常");
        }
    }

    /**
     * 生成免登url
     */
    private String autologin(DuibaAppEnum duibaApp, String uid, String nickName, String avatar, String redirectUrl, String env, String credits) {
        CreditTool tool = new CreditTool(duibaApp.getAppKey(), duibaApp.getAppSecret());
        Map<String, String> params = new HashMap<>();

        //生成dcustom数据
        Map<String, String> dcustomParam = new HashMap<>();
        dcustomParam.put("avatar", avatar);
        dcustomParam.put("nickname", nickName);
        getDcustom(dcustomParam, params);

        if (StringUtils.equalsIgnoreCase("null", redirectUrl)) {
            redirectUrl = "";
        }

        if (StringUtils.isNotBlank(redirectUrl)) {
            redirectUrl = UrlUtils.urlDecode(redirectUrl);
            params.put("redirect", redirectUrl);
        }
        params.put("uid", uid);
        if (StringUtils.isNotBlank(credits)) {
            params.put("credits", credits);
        }
        String autoUrl = getAutologinHome(env);

        return tool.buildUrlWithSign(autoUrl, params);
    }

    private void getDcustom(Map<String, String> dcustomParam, Map<String, String> autoLoginParam) {
        //生成dcustom字符串
        String dcustom = dcustomParam.entrySet().stream()
                .map(entry -> String.format("%s=%s", entry.getKey(), entry.getValue()))
                .collect(Collectors.joining("&"));

        //encode
        String dcustomStr = dcustom;
        try {
            dcustomStr = URLEncoder.encode(dcustom, "UTF-8");
        } catch (UnsupportedEncodingException e) {
            LOGGER.error("生成dcustom失败,encode数据：{},错误原因：{}", dcustom, e);
        }
        autoLoginParam.put("dcustom", dcustomStr);
    }

    /**
     * 是否关注店铺
     */
    @PostMapping("/isFollowShop")
    public Result<Boolean> isFollowShop(@RequestParam String uid, @RequestParam Long shopId, @RequestParam Long venderId) {
        try {
            uid = uid.replaceAll(" ", "+");
            signVerify("是否关注店铺");

            TbShopAccessTokenDto accessToken = accessTokenUtils.getAccessTokenWithCache(venderId, shopId);
            JdAppEnum appEnum = JdAppEnum.getAppByAppKey(accessToken.getAppKey());
            String pin = convert2Pin(appEnum, accessToken.getAccessToken(), uid);
            Result<Boolean> follow = jdApiUtil.isFollowByPinAndVid(appEnum, pin, shopId);
            LOGGER.info("是否关注店铺,follow={},uid={},pin={}", JSON.toJSONString(follow), uid, pin);
            return follow;
        } catch (BizException e) {
            return ResultBuilder.fail(e.getMessage());
        } catch (Exception e) {
            LOGGER.error("isFollowShop 异常", e);
            return ResultBuilder.fail("发生异常");
        }
    }


    public static String convert2Pin(JdAppEnum appByAppKey, String accessToken, String uid) throws BizException {
        try {
            String pin = AESCS7Util.AES256Decrypt(uid, ENCRYPT_KEY);
            LOGGER.info("uid解密,pin={},uid={}", pin, uid);
            return pin;
        } catch (Exception e) {
            LOGGER.error("uid解密失败,uid={}", uid, e);
            throw new BizException("uid解密失败");
        }

    }

    /**
     * 关注店铺
     */
    @PostMapping("/followShop")
    public Result<Boolean> followShop(@RequestParam String uid, @RequestParam Long shopId, @RequestParam Long venderId) {
        try {
            uid = uid.replaceAll(" ", "+");
            signVerify("关注店铺");

            TbShopAccessTokenDto accessToken = accessTokenUtils.getAccessTokenWithCache(venderId, shopId);
            JdAppEnum appEnum = JdAppEnum.getAppByAppKey(accessToken.getAppKey());
            String pin = convert2Pin(appEnum, accessToken.getAccessToken(), uid);
            Result<Boolean> follow = jdApiUtil.followByPinAndVid(appEnum, pin, shopId, accessToken.getAccessToken());
            LOGGER.info("关注店铺,follow={},uid={},pin={}", JSON.toJSONString(follow), uid, pin);
            return follow;
        } catch (BizException e) {
            return ResultBuilder.fail(e.getMessage());
        } catch (Exception e) {
            LOGGER.error("isMember 异常", e);
            return ResultBuilder.fail("发生异常");
        }
    }

    public static String convert2Uid(JdAppEnum appByAppKey, String accessToken, String pin) throws BizException {
        try {
            String uid = AESCS7Util.AESEncrypt(pin, ENCRYPT_KEY);
            LOGGER.info("pin加密,pin={},uid={}", pin, uid);
            return uid;
        } catch (Exception e) {
            LOGGER.error("pin加密失败,uid={}", pin, e);
            throw new BizException("pin加密失败");
        }
    }

    /**
     * 是否是会员
     */
    @PostMapping("/isMember")
    public Result<Boolean> isMember(@RequestParam String uid, @RequestParam Long shopId, @RequestParam Long venderId) {
        try {
            uid = uid.replaceAll(" ", "+");
            signVerify("是否是会员");

            TbShopAccessTokenDto accessToken = accessTokenUtils.getAccessTokenWithCache(venderId, shopId);
            JdAppEnum appEnum = JdAppEnum.getAppByAppKey(accessToken.getAppKey());
            String pin = convert2Pin(appEnum, accessToken.getAccessToken(), uid);
            Result<EssentialCustomerInfo> result = jdApiUtil.getCustomer(appEnum, accessToken.getAccessToken(), pin);
            boolean isMember = result.getSuccess() && result.getData() != null &&
                    (result.getData().getLevelAtShop() != null || result.getData().getCustomerPin() != null);
            LOGGER.info("是否是会员,isMember={},uid={},pin={}", isMember, uid, pin);
            return ResultBuilder.success(isMember);
        } catch (BizException e) {
            return ResultBuilder.fail(e.getMessage());
        } catch (Exception e) {
            LOGGER.error("isMember 异常", e);
            return ResultBuilder.fail("发生异常");
        }
    }

    private static String getUid(String uid2) {
        String uid = uid2;
        uid = uid.replaceAll(" ", "+");
        return uid;
    }


    /**
     * 发放优惠券
     */
    @PostMapping("/sendCouponId")
    public Result<Boolean> sendCouponId(@RequestParam String uid,
                                        @RequestParam Long couponId,
                                        @RequestParam String uuid,
                                        @RequestParam Long shopId,
                                        @RequestParam Long venderId) {
        try {
            uid = uid.replaceAll(" ", "+");
            signVerify("发放优惠券");

            TbShopAccessTokenDto accessToken = accessTokenUtils.getAccessTokenWithCache(venderId, shopId);
            JdAppEnum appEnum = JdAppEnum.getAppByAppKey(accessToken.getAppKey());
            String pin = convert2Pin(appEnum, accessToken.getAccessToken(), uid);

            Result<Boolean> sendCouponResult = jdApiUtil.pushCoupon(appEnum, accessToken.getAccessToken(), couponId, pin, uuid);
            LOGGER.info("发放优惠券,sendCouponResult={},uid={},pin={},uuid={}", JSON.toJSONString(sendCouponResult), uid, pin, uuid);
            return sendCouponResult;
        } catch (BizException e) {
            return ResultBuilder.fail(e.getMessage());
        } catch (Exception e) {
            LOGGER.error("发券异常", e);
            return ResultBuilder.fail("发券失败");
        }
    }

    /**
     * 是否关注店铺
     */
    @PostMapping("/isFollowShop/v2")
    public Result<Boolean> isFollowShopV2(@RequestBody DuibaUserParam duibaUserParam) {
        try {
            String uid = getUid(duibaUserParam.getUid());
            signVerify4Post(duibaUserParam, "是否关注店铺");

            TbShopAccessTokenDto accessToken = accessTokenUtils.getAccessTokenWithCache(duibaUserParam);
            JdAppEnum appEnum = JdAppEnum.getAppByAppKey(accessToken.getAppKey());
            String pin = convert2Pin(appEnum, accessToken.getAccessToken(), uid);
            Result<Boolean> follow = jdApiUtil.isFollowByPinAndVid(appEnum, pin, duibaUserParam.getShopId());
            LOGGER.info("是否关注店铺,follow={},uid={},pin={}", JSON.toJSONString(follow), uid, pin);
            return follow;
        } catch (BizException e) {
            return ResultBuilder.fail(e.getMessage());
        } catch (Exception e) {
            LOGGER.error("isFollowShop 异常", e);
            return ResultBuilder.fail("发生异常");
        }
    }

    /**
     * 关注店铺
     */
    @PostMapping("/followShop/v2")
    public Result<Boolean> followShopV2(@RequestBody DuibaUserParam duibaUserParam) {
        try {
            String uid = getUid(duibaUserParam.getUid());
            signVerify4Post(duibaUserParam, "关注店铺");

            TbShopAccessTokenDto accessToken = accessTokenUtils.getAccessTokenWithCache(duibaUserParam);
            JdAppEnum appEnum = JdAppEnum.getAppByAppKey(accessToken.getAppKey());
            String pin = convert2Pin(appEnum, accessToken.getAccessToken(), uid);
            Result<Boolean> follow = jdApiUtil.followByPinAndVid(appEnum, pin, duibaUserParam.getShopId(), accessToken.getAccessToken());
            LOGGER.info("关注店铺,follow={},uid={},pin={}", JSON.toJSONString(follow), uid, pin);
            return follow;
        } catch (BizException e) {
            return ResultBuilder.fail(e.getMessage());
        } catch (Exception e) {
            LOGGER.error("followShop 异常", e);
            return ResultBuilder.fail("发生异常");
        }
    }

    /**
     * 发放优惠券
     */
    @PostMapping("/sendCouponId/v2")
    public Result<Boolean> sendCouponId(@RequestBody DuibaSendCouponParam param) {
        try {
            String uid = param.getUid();
            Long couponId = param.getCouponId();
            String uuid = param.getUuid();

            uid = uid.replaceAll(" ", "+");
            signVerify4Post(param, "发放优惠券");

            TbShopAccessTokenDto accessToken = accessTokenUtils.getAccessTokenWithCache(param);
            JdAppEnum appEnum = JdAppEnum.getAppByAppKey(accessToken.getAppKey());
            String pin = convert2Pin(appEnum, accessToken.getAccessToken(), uid);

            Result<Boolean> sendCouponResult = jdApiUtil.pushCoupon(appEnum, accessToken.getAccessToken(), couponId, pin, uuid);
            LOGGER.info("发放优惠券,sendCouponResult={},uid={},pin={},uuid={}", JSON.toJSONString(sendCouponResult), uid, pin, uuid);
            if (!sendCouponResult.getSuccess()) {
                // 如果失败是因为未锁券
                if (Objects.equals("67", sendCouponResult.getCode())) {
                    // 锁券
                    sendCouponResult = jdApiUtil.lockCoupon(appEnum, accessToken.getAccessToken(), couponId);
                    if (sendCouponResult.getSuccess()) {
                        // 再发券
                        sendCouponResult = jdApiUtil.pushCoupon(appEnum, accessToken.getAccessToken(), couponId, pin, uuid);
                    }
                }
            }
            return sendCouponResult;
        } catch (BizException e) {
            return ResultBuilder.fail(e.getMessage());
        } catch (Exception e) {
            LOGGER.error("发券异常", e);
            return ResultBuilder.fail("发券失败");
        }
    }

    /**
     * 是否是会员
     */
    @PostMapping("/isMember/v2")
    public Result<Boolean> isMemberV2(@RequestBody DuibaUserParam duibaUserParam) {
        try {
            String uid = getUid(duibaUserParam.getUid());
            signVerify4Post(duibaUserParam, "是否是会员");

            TbShopAccessTokenDto accessToken = accessTokenUtils.getAccessTokenWithCache(duibaUserParam);
            JdAppEnum appEnum = JdAppEnum.getAppByAppKey(accessToken.getAppKey());
            String pin = convert2Pin(appEnum, accessToken.getAccessToken(), uid);
            Result<EssentialCustomerInfo> result = jdApiUtil.getCustomer(appEnum, accessToken.getAccessToken(), pin);
            boolean isMember = result.getSuccess() && result.getData() != null &&
                    (result.getData().getLevelAtShop() != null || result.getData().getCustomerPin() != null);
            LOGGER.info("是否是会员,isMember={},uid={},pin={}", isMember, uid, pin);
            return ResultBuilder.success(isMember);
        } catch (BizException e) {
            return ResultBuilder.fail(e.getMessage());
        } catch (Exception e) {
            LOGGER.error("是否是会员异常", e);
            return ResultBuilder.fail("是否是会员异常");
        }
    }

    /**
     * 会员信息，包含首次成为会员的时间、会员等级、总订单金额、总下单次数、客单价、最新订单时间
     */
    @PostMapping("/memberInfo")
    public Result<EssentialCustomerInfo> memberInfo(@RequestBody DuibaUserParam duibaUserParam) {
        try {
            String uid = getUid(duibaUserParam.getUid());
            signVerify4Post(duibaUserParam, "会员信息");

            TbShopAccessTokenDto accessToken = accessTokenUtils.getAccessTokenWithCache(duibaUserParam);
            JdAppEnum appEnum = JdAppEnum.getAppByAppKey(accessToken.getAppKey());
            String pin = convert2Pin(appEnum, accessToken.getAccessToken(), uid);
            Result<EssentialCustomerInfo> result = jdApiUtil.getCustomer(appEnum, accessToken.getAccessToken(), pin);
            if (!result.getSuccess()) {
                return result;
            }
            EssentialCustomerInfo customerInfo = result.getData();
            boolean isMember = customerInfo != null && (customerInfo.getLevelAtShop() != null || customerInfo.getCustomerPin() != null);
            if (!isMember) {
                return ResultBuilder.success();
            }
            LOGGER.info("会员信息,customerInfo={},uid={},pin={}", JSON.toJSONString(customerInfo), uid, pin);
            return ResultBuilder.success(customerInfo);
        } catch (BizException e) {
            return ResultBuilder.fail(e.getMessage());
        } catch (Exception e) {
            LOGGER.error("会员信息异常", e);
            return ResultBuilder.fail("会员信息异常");
        }
    }

    /**
     * 发放店铺积分
     */
    @PostMapping("/sendPoints")
    public Result<Boolean> sendPoints(@RequestBody DuibaSendPointsParam param) {
        try {
            String uid = getUid(param.getUid());
            signVerify4Post(param, "互动积分发放积分");

            TbShopAccessTokenDto accessToken = accessTokenUtils.getAccessTokenWithCache(param);
            JdAppEnum appEnum = JdAppEnum.getAppByAppKey(accessToken.getAppKey());
            String pin = convert2Pin(appEnum, accessToken.getAccessToken(), uid);

            Result<Boolean> result = jdApiUtil.sendPoints(
                    appEnum, pin, param.getBusinessId(), param.getPoints(), param.getDesc(), accessToken.getAccessToken());
            LOGGER.info("互动积分发放积分,result={},uid={},pin={}", JSON.toJSONString(result), uid, pin);
            return result;
        } catch (BizException e) {
            return ResultBuilder.fail(e.getMessage());
        } catch (Exception e) {
            LOGGER.error("互动积分发放积分,异常", e);
            return ResultBuilder.fail("互动积分发放积分异常");
        }
    }

    /**
     * 消费店铺积分
     */
    @PostMapping("/consumePoints")
    public Result<Boolean> consumePoints(@RequestBody DuibaSendPointsParam param) {
        try {
            String uid = getUid(param.getUid());
            signVerify4Post(param, "互动积分消费积分");

            TbShopAccessTokenDto accessToken = accessTokenUtils.getAccessTokenWithCache(param);
            JdAppEnum appEnum = JdAppEnum.getAppByAppKey(accessToken.getAppKey());
            String pin = convert2Pin(appEnum, accessToken.getAccessToken(), uid);

            Result<Boolean> result = jdApiUtil.consumePoints(
                    appEnum, pin, param.getBusinessId(), param.getPoints(), param.getDesc(), accessToken.getAccessToken());
            LOGGER.info("互动积分消费积分,result={},uid={},pin={}", JSON.toJSONString(result), uid, pin);
            return result;
        } catch (BizException e) {
            return ResultBuilder.fail(e.getMessage());
        } catch (Exception e) {
            LOGGER.error("互动积分消费积分,异常", e);
            return ResultBuilder.fail("互动积分消费积分异常");
        }
    }

    /**
     * 获取用户积分值
     */
    @PostMapping("/getCustomerPoints")
    public Result<Long> getCustomerPoints(@RequestBody DuibaUserParam param) {
        try {
            String uid = getUid(param.getUid());
            signVerify4Post(param, "获取用户积分");

            TbShopAccessTokenDto accessToken = accessTokenUtils.getAccessTokenWithCache(param);
            JdAppEnum appEnum = JdAppEnum.getAppByAppKey(accessToken.getAppKey());
            String pin = convert2Pin(appEnum, accessToken.getAccessToken(), uid);

            Result<Long> result = jdApiUtil.getCustomerPoints(appEnum, pin, accessToken.getAccessToken());
            LOGGER.info("获取用户积分,result={},uid={},pin={}", JSON.toJSONString(result), uid, pin);
            return result;
        } catch (BizException e) {
            return ResultBuilder.fail(e.getMessage());
        } catch (Exception e) {
            LOGGER.error("获取用户积分,异常", e);
            return ResultBuilder.fail("获取用户积分异常");
        }
    }


    /**
     * 通过用户pin加入购物车
     */
    @PostMapping("/addCartItemByPin")
    public Result<Boolean> addCartItemByPin(@RequestBody DuibaAddCartParam param) {
        try {
            String uid = param.getUid();
            Integer num = param.getNum();
            String itemId = param.getItemId();

            uid = uid.replaceAll(" ", "+");
            signVerify4Post(param, "通过用户pin加入购物车");

            TbShopAccessTokenDto accessToken = accessTokenUtils.getAccessTokenWithCache(param);
            JdAppEnum appEnum = JdAppEnum.getAppByAppKey(accessToken.getAppKey());
            String pin = convert2Pin(appEnum, accessToken.getAccessToken(), uid);

            Result<Boolean> result = jdApiUtil.addCartItemByPin(appEnum, pin, itemId, num, accessToken.getAccessToken());
            LOGGER.info("通过用户pin加入购物车,result={}", JSON.toJSONString(result));
            return result;
        } catch (BizException e) {
            return ResultBuilder.fail(e.getMessage());
        } catch (Exception e) {
            LOGGER.error("通过用户pin加入购物车,异常", e);
            return ResultBuilder.fail("通过用户pin加入购物车失败");
        }
    }


    /**
     * 通过用户pin加入购物车
     */
    @PostMapping("/sendBean")
    public Result<Boolean> sendBean(@RequestBody DuibaSendBeanParam param) {
        try {
            String uid = param.getUid();

            uid = uid.replaceAll(" ", "+");
            signVerify4Post(param, "发送京豆");

            TbShopAccessTokenDto accessToken = accessTokenUtils.getAccessTokenWithCache(param);
            JdAppEnum appEnum = JdAppEnum.getAppByAppKey(accessToken.getAppKey());
            String pin = convert2Pin(appEnum, accessToken.getAccessToken(), uid);

            Result<Boolean> result = jdApiUtil.sendBean(appEnum, accessToken.getAccessToken(),
                    param.getRequestId(), param.getBeanNum(), accessToken.getVenderId(),
                    param.getPlanId(), pin, param.getDesc());
            LOGGER.info("发送京豆,result={}", JSON.toJSONString(result));
            return result;
        } catch (BizException e) {
            return ResultBuilder.fail(e.getMessage());
        } catch (Exception e) {
            LOGGER.error("发送京豆,异常", e);
            return ResultBuilder.fail("通过用户pin加入购物车失败");
        }
    }

    /**
     * 关注商品
     */
    @PostMapping("/followGood")
    public Result<Boolean> followGood(@RequestBody FollowGoodParam param) {
        try {
            String uid = param.getUid();
            Long productId = param.getProductId();

            uid = uid.replaceAll(" ", "+");
            signVerify4Post(param, "关注商品");

            TbShopAccessTokenDto accessToken = accessTokenUtils.getAccessTokenWithCache(param);
            JdAppEnum appEnum = JdAppEnum.getAppByAppKey(accessToken.getAppKey());
            String pin = convert2Pin(appEnum, accessToken.getAccessToken(), uid);

            Result<Boolean> result = jdApiUtil.followGood(appEnum, pin, productId, accessToken.getAccessToken());
            LOGGER.info("关注商品,result={}", JSON.toJSONString(result));
            return result;
        } catch (BizException e) {
            return ResultBuilder.fail(e.getMessage());
        } catch (Exception e) {
            LOGGER.error("关注商品,异常", e);
            return ResultBuilder.fail("关注商品失败");
        }
    }

}
