package cn.com.duiba.jdactivity.controller;

import cn.com.duiba.jdactivity.common.vo.Result;
import cn.com.duiba.jdactivity.common.vo.ResultBuilder;
import cn.com.duiba.jdactivity.developer.jd.constant.JdAppEnum;
import cn.com.duiba.jdactivity.developer.jd.domain.AccessTokenResponse;
import cn.com.duiba.jdactivity.developer.jd.domain.JosParameters;
import cn.com.duiba.jdactivity.developer.jd.utils.AccessTokenUtils;
import cn.com.duiba.jdactivity.developer.jd.utils.JdApiUtil;
import cn.com.duiba.jdactivity.developer.jd.utils.LoginUtils;
import cn.com.duiba.jdactivity.exception.BizException;
import com.jd.open.api.sdk.domain.seller.ShopSafService.response.query.ShopJosResult;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * 订购商家用
 *
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2021/5/13 13:58
 */
@RestController
@RequestMapping("/app")
public class AppController {
    public static final Logger LOGGER = LoggerFactory.getLogger(AppController.class);

    @Resource
    private AccessTokenUtils accessTokenUtils;
    @Resource
    private JdApiUtil jdApiUtil;


    /**
     * 应用插件启动唤起页
     */
    @RequestMapping("/login")
    public Result<String> login(String code, @RequestParam(required = false) String state) {
        try {
            LOGGER.info("login,code={},state={}", code, state);
            if (StringUtils.isAnyBlank(code)) {
                return ResultBuilder.fail("参数缺失");
            }

            // 获取appKey
            String appKey = JdAppEnum.DUIBA.getAppKey();
            if (StringUtils.isNotBlank(state)) {
                JosParameters josParameters = LoginUtils.getStateParam(state);
                if (josParameters != null) {
                    appKey = josParameters.getApp_key();
                }
            }

            JdAppEnum jdAppEnum = JdAppEnum.getAppByAppKey(appKey);
            if (jdAppEnum == null) {
                return ResultBuilder.fail("appKey参数不合法");
            }

            AccessTokenResponse accessTokenByCode = accessTokenUtils.getAccessTokenByCode(jdAppEnum, code);
            if (accessTokenByCode != null && accessTokenByCode.isOk()) {
                LOGGER.info("login,获取AccessToken成功");
                Result<ShopJosResult> shopJosResultResult = jdApiUtil.venderShopQuery(jdAppEnum, accessTokenByCode.getAccess_token());
                if (shopJosResultResult.getSuccess()) {
                    LOGGER.info("login,获取ShopJosResult成功");
                    ShopJosResult shopJosResult = shopJosResultResult.getData();

                    // 保存入库
                    Long id = accessTokenUtils.saveAccessToken(jdAppEnum, accessTokenByCode, shopJosResult);
                    LOGGER.info("login,保存AccessToken成功");
                    if (id != null && id > 0) {
                        Long shopId = accessTokenUtils.getAccessTokenWithCache(shopJosResult.getVenderId(), shopJosResult.getShopId()).getShopId();
                        LOGGER.info("login,保存AccessToken成功,shopId={}", shopId);
                    }


                    // ShopUserCookieDto shopUserCookieDto = new ShopUserCookieDto();
                    // shopUserCookieDto.setLoginTime(System.currentTimeMillis());
                    // shopUserCookieDto.setVenderId(shopJosResult.getVenderId());
                    // shopUserCookieDto.setShopId(shopJosResult.getShopId());
                    // shopUserCookieDto.setShopName(shopJosResult.getShopName());
                    // shopUserCookieDto.setOpenId(accessTokenByCode.getOpen_id());
                    // shopUserCookieDto.setUid(accessTokenByCode.getUid());
                    //
                    // UserUtils.injectConsumerInfoIntoCookie(shopUserCookieDto);
                } else {
                    LOGGER.error("login,获取ShopJosResult失败");
                }
            }

            return ResultBuilder.success(accessTokenByCode.getMsg());
        } catch (BizException e) {
            return ResultBuilder.fail(e.getMessage());
        } catch (Exception e) {
            LOGGER.error("店铺授权异常", e);
            return ResultBuilder.fail("店铺授权失败");
        }
    }

    // /**
    //  * 获取店铺信息
    //  */
    // @RequestMapping("/getShopInfoVO")
    // public Result<JSONObject> getShopInfoVO() {
    //     try {
    //         ShopUserCookieDto user = RequestLocal.getUser();
    //         if (user == null) {
    //             return ResultBuilder.fail("未登录");
    //         }
    //         TbShopAccessTokenDto accessToken = accessTokenUtils.getAccessTokenWithCache(user.getVenderId(), user.getShopId());
    //         JdAppEnum jdAppEnum = JdAppEnum.getAppByAppKey(accessToken.getAppKey());
    //         Result<ShopJosResult> shopJosResultResult = jdApiUtil.venderShopQuery(jdAppEnum, accessToken.getAccessToken());
    //         JSONObject jsonObject = new JSONObject();
    //         jsonObject.put("shop", shopJosResultResult.getData());
    //         return ResultBuilder.success(jsonObject);
    //     } catch (BizException e) {
    //         return ResultBuilder.fail(e.getMessage());
    //     }
    // }
}
