'use strict';

import React, { Component } from 'react';
import resList from '../../resconfig/resList';
import util from '../../util/util';

import './ComGameClear.less';

class ComGameClear extends Component {
    constructor(props) {
        super(props);
        this.state = this.state || { resList: resList, level: 1 };
    }

    componentDidMount() {
        this.setState({
            level:this.props.data.level
        })
    }

    nextLevel() {
        this.props.closeWin();
        util.dispatchEvent("nextLevel");
    }

    render() {
        return (
            <div className="chuang_guan_cheng_gong zoom">
                <img className="dan_chuang_bei_jing9" src={this.state.resList['62bbfc66-9033-43f3-81c6-9cf6750e07ca'].url} />
                <img className="guan_bi_an_niu8" src={this.state.resList['28caebe0-9290-49fe-9661-ccc2c9885520'].url} onClick={this.nextLevel.bind(this)} />
                <img className="xia_yi_guan_an_niu" src={this.state.resList['5962e4f3-3625-4b62-9b01-c7b85cb025af'].url} onClick={this.nextLevel.bind(this)} />
                <label className="gong_xi_guo_guanlabel">恭喜你<br/>闯过第{this.state.level}关</label>
                <label className="tong_guan_yinglabel">通关成功可赢取大奖</label>
            </div>
        );
    }
}
export default ComGameClear;
