import { BaseEnemyBullet } from "./BaseEnemyBullet";

export class SwordBullet extends BaseEnemyBullet{
    constructor(x:number,y:number,speed:number,vector:FYGE.Point){
        super();
        this.x = x;
        this.y = y;
        this.speedVector = vector;
        this.speedX = this.speedY = speed;
        this.rotation = Math.atan2(vector.y,vector.x)*180/Math.PI-90;
        // Math.cos(any) = vector.x;
        // Math.sin(any)
    }

    addToViewPort(){
        super.addToViewPort();
        this.setBodyImg("567e7ed8-9dc0-4018-896b-900c09570a85");
        this.bodyImg.x = -this.bodyImg.width>>1;
    }

    updateSelf(){
        super.updateSelf();
    }
}