import { Ins } from "../../Ins";
import { BaseEnemy, enemyState, enemyType } from "./BaseEnemy";

export class RedBoss extends BaseEnemy{
    constructor(){
        super();
    }

    addToViewPort(){
        var that = this;
        super.addToViewPort();
        that.setBody("4b407c3a-b570-4940-8f6e-48e339e3535d");
        that.hitW = 316;
        that.hitH = 140;
        that.health = 750;
        that.curSkillMax = 2;
        that.x = Ins.stageW*0.5 - that.bodyImg.width*0.5;
        that.y = -that.bodyImg.height
        that.enemyType = enemyType.boss;
        that.changeState(enemyState.goStage)
    }

    updateSelf(){
        super.updateSelf();
        var that = this;
        switch(that.enemyState){
            case enemyState.goStage:
                if(that.y>=(that.bodyImg.height*0.5)){
                    that.changeState(enemyState.wait);
                }
                break;
            case enemyState.inSatge:
                that.worldTime++;
                that.horizonBounds();
                if(that.worldTime%100 == 0){
                    that.changeState(enemyState.attack);
                }
                break;
            case enemyState.attack:
                that.horizonBounds();
                switch(that.curSkillIndex){
                    case 0:
                        that.createSplitBullet();
                        break;
                    case 1:
                        that.createLaser(50);
                        break;
                    case 2:
                        that.createGrapeshot();
                        break;
                }
                break;
            case enemyState.wait:
                that.worldTime ++;
                if(that.worldTime%60 == 0){
                    that.changeState(enemyState.inSatge);
                }
                break;
        }
    }

    changeState(state:enemyState){
        var that = this;
        switch(state){
            case enemyState.goStage:
                that.speedVector.y = 1;
                that.speedY = 1;
                break;
            case enemyState.wait:
                that.speedVector.y = 0;
                break;
            case enemyState.inSatge:
                that.bossSetInStage();
                break;
            case enemyState.attack:
                that.attackState();
                break;
        }
        that.enemyState = state;
    }
}