import { Ins } from "../../Ins";
import { BaseEnemy, enemyState, enemyType } from "./BaseEnemy";

export class PurpleBoss extends BaseEnemy{
    constructor(){
        super();
    }

    addToViewPort(){
        var that = this;
        super.addToViewPort();
        that.setBody("e09b5656-cfc1-4b9f-b704-c3b82a1f8d2a");
        that.hitW = 318;
        that.hitH = 104;
        that.health = 800;
        that.x = Ins.stageW*0.5 - that.bodyImg.width*0.5;
        that.y = -that.bodyImg.height;
        that.curSkillMax = 2;
        that.enemyType = enemyType.boss;
        that.changeState(enemyState.goStage);
    }

    updateSelf(){
        super.updateSelf();
        var that = this;
        switch(that.enemyState){
            case enemyState.goStage:
                if(that.y>=(that.bodyImg.height*0.5)){
                    that.changeState(enemyState.inSatge);
                }
                break;
            case enemyState.inSatge:
                that.worldTime++;
                that.horizonBounds();
                if(that.worldTime%90==0){
                    that.changeState(enemyState.attack);
                }
                break;
            case enemyState.attack:
                that.horizonBounds();
                switch(that.curSkillIndex){
                    case 0:
                        that.createSpiralShot();
                        break;
                    case 1:
                        that.createLaser(48);
                        break;
                    case 2:
                        that.createGrapeshot();
                        break;
                }
                break;
        }
    }

    changeState(state:enemyState){
        var that = this;
        switch(state){
            case enemyState.goStage:
                that.bossSetGoStage();
                break;
            case enemyState.inSatge:
                that.bossSetInStage();
                break;
            case enemyState.attack:
                that.attackState();
                break;
        }
        that.enemyState = state;
    }
}