import { Ins } from "../../Ins";
import { BaseEnemy, enemyState, enemyType } from "./BaseEnemy";

export class GreenElite extends BaseEnemy{
    constructor(){
        super();
    }
    canShot = true;
    
    addToViewPort(){
        var that = this;
        super.addToViewPort();
        that.setBody("9dab267e-ce31-4f24-b624-9c85258a5360");
        that.hitW = 136;
        that.hitH = 60;
        that.health = 30;
        that.speedVector.y = 1;  
        that.speedY = 3;
        that.y = -105;
        that.worldTime = 40;
        that.x = Ins.stageW*0.5 - that.bodyImg.width*0.5;
        that.enemyType = enemyType.elite;
        that.enemyState = enemyState.goStage;
    }

    updateSelf(){
        var that = this;
        super.updateSelf();
        switch(that.enemyState){
            case enemyState.goStage:
                if(that.y>=180){
                    that.bossSetInStage();
                    that.changeState(enemyState.inSatge);
                }
                break;
            case enemyState.inSatge:
                that.horizonBounds();
                that.worldTime++;
                if(that.worldTime%100==0){
                    that.worldTime = 0;
                    that.changeState(enemyState.attack)
                }   
                break;
            case enemyState.attack:
                that.horizonBounds();
                that.createThreeGroupSword();
                break;
        }
        
    }

    changeState(state:enemyState){
        this.enemyState = state;
    }
}