import { getRandomValue, getTexture } from './utils'
// import {props} from "../props";
import { PlayerPlane } from "./PlayerPlane"
import { EnemyManager } from './Manager/EnemyManager';
import { LayerManager } from './Manager/LayerManager';
import { GameManager } from './Manager/GameManager';
import { EnemyBulletManager } from './Manager/EnemyBulletManager';
import { Ins } from '../Ins';
import { layers } from '../../module/views/layers';

export enum GameState {
    default,
    BossTime,
    EndLesstime
}

export default class TestView extends FYGE.Container {
    playerPlane: PlayerPlane;
    offsetX: number;
    offsetY: number;
    canMove: boolean = false;
    stageW: number;
    stageH: number;
    bgArr: FYGE.Sprite[] = [];
    bgMove: boolean = true;
    bgMoveSpeed = 8;
    injuredImg: FYGE.Sprite = null;
    imgFlashCount: number = 0;
    bossDead: boolean = false;
    worldTime: number = 0;
    bossCnt: number = 1;
    bossMaxCnt: number = 5;
    isEndLess: boolean = false;

    bossWarning: FYGE.Sprite;
    endLessWarning: FYGE.Sprite;

    gameState: GameState = GameState.default;


    constructor() {
        super()
        this.addEventListener(FYGE.Event.ADDED_TO_STAGE, this.setup, this);
    }

    setup() {
        var that = this;
        that.removeEventListener(FYGE.Event.ADDED_TO_STAGE, this.setup, this);
        that.stageW = Ins.stageW;
        that.stageH = Ins.stageH;
        that.gameState = GameState.BossTime;
        that.setLayer();
        that.setBg();
        that.playerPlane = new PlayerPlane();
        that.playerPlane.x = that.stageW - that.playerPlane.width >> 1;
        that.playerPlane.y = that.stageH - 200;
        LayerManager.Ins.playerLayer.addChild(that.playerPlane);
        that.playerPlane.setView(that);
        that.playerPlane.canShootF(true);
        GameManager.INS.playerPlane = that.playerPlane;
        that.addEvent();
        EnemyBulletManager.Ins;
        EnemyManager.Ins.enemyCreate(LayerManager.Ins.enemyLayer, 10);
        GameManager.INS.createPointUi(LayerManager.Ins.uiLayer)
        GameManager.INS.createUserHealth(LayerManager.Ins.uiLayer, 60, 60);
        GameManager.INS.createBoomBtn(LayerManager.Ins.uiLayer, Ins.stageW - 120, Ins.stageH - 200)
        that.injuredImg = new FYGE.Sprite(getTexture("717c2025-e4e7-4553-833f-1c1492257208"));
        LayerManager.Ins.uiLayer.addChild(that.injuredImg);
        that.injuredImg.visible = false;
        that.injuredImg.alpha = 0.2;

        that.bossWarning = new FYGE.Sprite(getTexture("75fb3858-19bf-488d-adce-830c6780c116"));
        LayerManager.Ins.uiLayer.addChild(that.bossWarning);
        that.bossWarning.x = Ins.stageW * 0.5 - that.bossWarning.width * 0.5;
        that.bossWarning.y = Ins.stageH * 0.3;
        that.bossWarning.alpha = 0.2;
        that.bossWarning.visible = false;

        setTimeout(() => {
            that.bossWarning.visible = true;
            FYGE.Tween.get(that.bossWarning).to({ alpha: 1 }, 300).to({ alpha: 0.2 }, 300)
                .to({ alpha: 1 }, 300).to({ alpha: 0.2 }, 300)
                .to({ alpha: 1 }, 300).to({ alpha: 0.2 }, 300).call(() => { that.bossDead = true; that.bossWarning.visible = false; })
        }, 500)

        that.endLessWarning = new FYGE.Sprite(getTexture("eb771a67-924b-40ce-a525-3319880ec3f5"));
        LayerManager.Ins.uiLayer.addChild(that.endLessWarning);
        that.endLessWarning.x = Ins.stageW * 0.5 - that.endLessWarning.width * 0.5;
        that.endLessWarning.y = Ins.stageH * 0.3;
        that.endLessWarning.alpha = 0.2;
        that.endLessWarning.visible = false;
    }

    /**设置层级 */
    setLayer() {
        LayerManager.Ins.initLayer(this);
    }

    setBg() {
        for (var i = 0; i < 2; i++) {
            var bg = new FYGE.Sprite(getTexture("448a279f-e7f6-4af3-85b3-ddafb7915a22"));
            LayerManager.Ins.bgLayer.addChild(bg);
            bg.x = 0;
            bg.y = -1624 + i * 1624;
            this.bgArr.push(bg);
        }
    }

    addEvent() {
        var that = this;
        that.stage.addEventListener(FYGE.MouseEvent.MOUSE_DOWN, that.touchDown, that);
        that.stage.addEventListener(FYGE.MouseEvent.MOUSE_MOVE, that.touchMove, that);
        that.stage.addEventListener(FYGE.MouseEvent.MOUSE_UP, that.touchUp, that);

        // LayerManager.Ins.touchLayer.addEventListener(FYGE.MouseEvent.MOUSE_DOWN,that.touchDown,that);
        // LayerManager.Ins.touchLayer.addEventListener(FYGE.MouseEvent.MOUSE_MOVE,that.touchMove,that);
        // LayerManager.Ins.touchLayer.addEventListener(FYGE.MouseEvent.MOUSE_UP,that.touchUp,that);
        // that.addEventListener(FYGE.Event.ENTER_FRAME,that.updateGame,that);
        // setInterval(() => {
        //     that.updateGame();
        // }, 1000 / 60);
        that.addEventListener(FYGE.Event.ENTER_FRAME,that.updateGame,that);
        FYGE.GDispatcher.addEventListener("playerInjured", that.injureFlush, that)
        FYGE.GDispatcher.addEventListener("bossDead", that.bossDeadFun, that);
    }

    /**玩家受伤图片闪烁 */
    injureFlush() {
        var that = this;
        that.injuredImg.visible = true;
        FYGE.Tween.get(that.injuredImg, { loop: true }).to({ alpha: 1 }, 100).to({ alpha: 0.2 }, 100).call(() => {
            that.imgFlashCount++;
            if (that.imgFlashCount >= 3) {
                that.imgFlashCount = 0;
                that.injuredImg.visible = false
                FYGE.Tween.removeTweens(that.injuredImg);
            }
        }, that)
    }

    bossDeadFun() {
        var that = this;
        that.bossDead = true;
    }

    changeToEndLess() {
        var that = this;
        that.endLessWarning.visible = true;
        FYGE.Tween.get(that.endLessWarning).to({ alpha: 1 }, 400).wait(1800).call(() => {
            that.isEndLess = true;
            that.endLessWarning.visible = false;
        })
        that.gameState = GameState.EndLesstime;
    }

    lastTime:number = 0;
    updateGame() {
        if (GameManager.INS._pause) return;
        var that = this;
        let nowTime = new Date().getTime();
        if((nowTime-that.lastTime)<60/1000) return;
        else{
            that.lastTime = nowTime;
        }
        if (that.playerPlane) {
            that.playerPlane.updateSelf();
        }
        EnemyManager.Ins.updateEnemy();
        EnemyBulletManager.Ins.updateEnemyBullet();
        GameManager.INS.updateGame();

        if (that.bgMove) {
            for (var i = 0; i < that.bgArr.length; i++) {
                that.bgArr[i].y += that.bgMoveSpeed;
                if (that.bgArr[i].y >= 1624) {
                    that.bgArr[i].y = -1624;
                }
            }
        }

        switch (that.gameState) {
            case GameState.BossTime:
                if (that.bossDead) {
                    if (that.bossCnt > that.bossMaxCnt) {
                        that.changeToEndLess();
                        return;
                    }
                    that.worldTime++;
                    if (that.worldTime % 150 == 0) {
                        EnemyManager.Ins.enemyCreate(LayerManager.Ins.enemyLayer, that.bossCnt);
                        that.bossCnt++;
                        that.bossDead = false;
                        that.worldTime = 0;
                    }
                }
                break;
            case GameState.EndLesstime:
                if (!that.isEndLess) return;
                that.worldTime++;
                if (that.worldTime % (60 / 1000 * Ins.enemyInitFrame) == 0) {
                    if (EnemyManager.Ins.enemyArr.length < Ins.maxEnemyCnt)
                        EnemyManager.Ins.enemyCreate(LayerManager.Ins.enemyLayer, getRandomValue(6, 12));
                    EnemyManager.Ins.enemyCreate(LayerManager.Ins.enemyLayer, getRandomValue(13, 16));
                    that.worldTime = 0;
                }
                break;
        }


        // if (that.bossCnt <= that.bossMaxCnt) {
        //     if (that.bossDead) {
        //         that.worldTime++;
        //         if (that.worldTime % 150 == 0) {
        //             EnemyManager.Ins.enemyCreate(LayerManager.Ins.enemyLayer, that.bossCnt);
        //             that.bossCnt++;
        //             that.bossDead = false;
        //             that.worldTime = 0;
        //             if (that.bossCnt > that.bossMaxCnt) {

        //             }
        //         }
        //     }
        // } else {
        //     that.worldTime++;
        //     if (that.worldTime % 80 == 0) {
        //         if (EnemyManager.Ins.enemyArr.length < 12)
        //             EnemyManager.Ins.enemyCreate(LayerManager.Ins.enemyLayer, getRandomValue(6, 12));
        //         EnemyManager.Ins.enemyCreate(LayerManager.Ins.enemyLayer, getRandomValue(13, 16));
        //         that.worldTime = 0;
        //     }
        // }

    }

    /**用户触摸按下 */
    touchDown(e: FYGE.MouseEvent) {
        if (GameManager.INS._pause) return;
        this.offsetX = e.stageX - this.playerPlane.x;
        this.offsetY = e.stageY - this.playerPlane.y;
        this.canMove = true;
    }

    /**用户触摸移动 */
    touchMove(e: FYGE.MouseEvent) {
        if (GameManager.INS._pause) return;
        if (!this.canMove) return;
        var x = e.stageX - this.offsetX;
        var y = e.stageY - this.offsetY;
        this.playerPlane.move(x, y);
    }

    /**用户触摸抬起 */
    touchUp() {
        if (GameManager.INS._pause) return;
        this.canMove = false;
    }
}