import { BaseSprite } from "./BaseSprite";
import { getTexture } from "./utils";
import { EffectManager } from "./Manager/EffectManager";
import { LayerManager } from "./Manager/LayerManager";
import { BaseEnemy} from "./enemy/BaseEnemy";
import { BaseEnemyBullet } from "./enemy/BaseEnemyBullet";
import { Ins } from "../Ins";
import { EnemyBulletManager } from "./Manager/EnemyBulletManager";
import { EnemyManager } from "./Manager/EnemyManager";

export class ClearUpBtn extends BaseSprite{
    bodyImg:FYGE.Sprite;
    countImg:FYGE.Sprite;
    count:number;
    maxCount:number;
    cntImgArr:FYGE.Texture[] = [];
    constructor(){
        super();
    }

    addToViewPort(){
        var that = this;
        super.addToViewPort();
        that.count = 3;
        that.maxCount = 3;
        that.bodyImg = new FYGE.Sprite();
        that.addChild(that.bodyImg);
        that.countImg = new FYGE.Sprite();
        that.addChild(that.countImg);
        that.mouseEnable = that.mouseChildren = true;
        for(let i=0;i<that.maxCount;i++){
            var texture = getTexture("boomCount"+(i+1));
            that.cntImgArr.push(texture);
        }
        that.cntJudge();
        that.countImg.x = that.bodyImg.width-20;
        that.addEvent();
    }

    addEvent(){
        this.addListener(this.bodyImg,FYGE.MouseEvent.CLICK,this.effect,this);
    }   
    
    /**效果 */
    effect(){
        var that = this;
        that.mouseEnable = that.mouseChildren = false;
        EffectManager.Ins.createEffect(LayerManager.Ins.effectLayer,"原子弹爆炸",30,14,Ins.stageW*0.5,Ins.stageH*0.5,()=>{
            that.reduceCnt(1);
        },that)
        var enemyArr:BaseEnemy[] = EnemyManager.Ins.enemyArr;
        var enemyBulletArr:BaseEnemyBullet[] = EnemyBulletManager.Ins.bulletArr;
        for(let i=0;i<enemyArr.length;i++){
            var enemy = enemyArr[i];
            if(enemy.enemyType === 1){
                enemy.health -= 500;
            }else{
                enemy.removeEnemy();
                i--;
            }
        }
        for(let i=0;i<enemyBulletArr.length;i++){
            let bullet = enemyBulletArr[i];
            bullet.removeSelf();
            i--;
        }
    //    var a = new p2.Body()
    //     a.addShape()

    }

    /**增加炸弹值 */
    increaseCnt(value:number){
        var that = this;
        if((that.count+value)>=that.maxCount){
            that.count = that.maxCount;
        }else{
            that.count += value;
        }
        that.cntJudge();
        
    }

    /**减少炸弹值 */
    reduceCnt(value:number){
        var that = this;
        if(0>=(that.count-value)){
            that.count = 0;
        }else{
            that.count -= value;
        }
        that.cntJudge();
    }

    /**判断当前炸弹值 */
    cntJudge(){
        var that = this;
        if(that.count>0){
            that.mouseEnable = that.mouseChildren = true;
            that.countImg.visible = true;
            that.countImg.texture = that.cntImgArr[that.count-1]
            that.bodyImg.texture = getTexture("7136234a-759b-4014-bb5c-53710bda5855");
        }
        else{
            that.mouseEnable = that.mouseChildren = false;
            that.countImg.visible = false;
            that.bodyImg.texture = getTexture("11d792ae-62a2-47f2-85bd-a22260d04a25");
        }
        
    }
}