'use strict';

import React, { Component } from 'react';
import resList from '../../resconfig/resList';

import './ComspendPoints.less';
import dataCenter from '../../util/dataCenter';
import ViewCtrl from '../../util/viewCtrl';
import Enum from '../../util/enum';
import util from '../../util/util';

class ComspendPoints extends Component {
  constructor(props) {
    super(props);
    this.state = this.state || { resList: resList,needPointsLabel:'是否继续花费xx积分' };
  }

  componentDidMount(){
    const {needCreditsLong} = dataCenter.getData("ajaxElement").element;
    this.setState({
        needPointsLabel:"是否愿意花费"+needCreditsLong+window.CFG.unitName
    })
  }

  spendPoints(){
    this.props.closeWin();
    ViewCtrl.showWin(Enum.Com.ComspendPointsSure,{},this.props.call)
  }

  render() {
    return (
      <div className="ji_xu_can_yu_tiao_zhan zoom">
        <img className="dan_chuang_bei_jing25" src={this.state.resList['0e12599a-86ce-4593-a74a-ded3348551fa'].url} />
        <img className="guan_bi_an_niu24" src={this.state.resList['28caebe0-9290-49fe-9661-ccc2c9885520'].url} onClick={this.props.closeWin}/>
        <img className="que_ren_an_niu23" src={this.state.resList['fe70684d-21d6-4da0-b55d-65531968c63c'].url} onClick={this.spendPoints.bind(this)}/>
        <label className="hua_fei_ji_fenlabel">{this.state.needPointsLabel}<br/>继续参与挑战</label>
        <label className="mian_fei_yong_wanlabel">今日免费挑战次数已用完</label>
      </div>
    );
  }
}
export default ComspendPoints;
