import { Scene } from "../../module/views/Scene";
import TestView from "../game/TestView";
class line {
    k;
    b;
    x1;
    x2
    constructor(k, b, x1, x2) {
        this.k = k;
        this.b = b;
        this.x1 = x1;
        this.x2 = x2;
    }
}

class vector {
    x;
    y;
    constructor(x, y) {
        this.x = x||0;
        this.y = y||0;
    }

    sub(v) {
        return new vector(this.x-v.x,this.y-v.y);
    }

    dot(v) {
        return this.x * v.x + this.y * v.y;
    }
}

class OBB {
    centerPoint:vector;
    extents;
    axes;
    w;
    h;
    rotation;

    constructor(cenerPoint,w,h,r){
        let radius = r*Math.PI/180;
        this.centerPoint = cenerPoint;
        this.extents = [w/2,h/2];
        this.axes = [new vector(Math.cos(radius),Math.sin(radius)),new vector(-1*Math.sin(radius),Math.cos(radius))];

        this.w=w;
        this.h=h;
        this.rotation = r;
    }

    getProjectionRadius(axis: vector) {
        return this.extents[0] * Math.abs(axis.dot(this.axes[0]))+this.extents[1]*Math.abs(axis.dot(this.axes[1]));
    }
}

export class MainScene extends Scene {
    testRect1: FYGE.Shape;
    testRect2: FYGE.Shape;

    initUi() {
        this.addChild(new TestView());
        return;
        this.testRect1 = new FYGE.Shape();
        this.testRect1.beginFill(80);
        this.testRect1.drawRect(-100, -50, 200, 100);
        this.testRect1.endFill();
        this.addChild(this.testRect1);
        this.testRect1.position.set(200, 300);
        // this.testRect1.anchorX = 100;
        // this.testRect1.anchorY = 50;

        this.testRect2 = new FYGE.Shape();
        this.testRect2.beginFill(80);
        this.testRect2.drawRect(-50, -100, 100, 200);
        this.testRect2.endFill();
        this.addChild(this.testRect2);
        this.testRect2.position.set(80, 430);
        this.testRect2.rotation = 60;

        this.testRect1.addEventListener(FYGE.MouseEvent.CLICK, () => {
            this.testRect1.rotation += 15;
            this.testRect1.x -= 5
        }, this)


        // this.stage.addEventListener(FYGE.MouseEvent.CLICK, (e: FYGE.MouseEvent) => {
        //     console.log(e.stageX, e.stageY)
        // }, this)

        this.addEventListener(FYGE.Event.ENTER_FRAME, () => {
            // console.log(this.rectCollsion(this.testRect1.x+50,this.testRect1.y+100,this.testRect2.x+50,this.testRect2.y+100,100,200,100,200));

            // let origin1 = new FYGE.Point((this.testRect1.x + 50), (this.testRect1.y + 100));
            // let p1 = this.getRectPoint(origin1, new FYGE.Point(this.testRect1.x, this.testRect1.y), this.testRect1.rotation, 100, 50);
            // let p2 = this.getRectPoint(origin1, new FYGE.Point(this.testRect1.x + 200, this.testRect1.y), this.testRect1.rotation, 100, 50);
            // let p3 = this.getRectPoint(origin1, new FYGE.Point(this.testRect1.x, this.testRect1.y + 100), this.testRect1.rotation, 100, 50);
            // let p4 = this.getRectPoint(origin1, new FYGE.Point(this.testRect1.x + 200, this.testRect1.y + 100), this.testRect1.rotation, 100, 50);
            // let line1 = this.getLine(p3.x, p3.y, p4.x, p4.y);
            // let line2 = this.getLine(p1.x, p1.y, p3.x, p3.y);
            // console.log("1", this.isCollsion(line1, this.testRect2.x, this.testRect2.y, 200, 100) || this.isCollsion(line2, this.testRect2.x, this.testRect2.y, 200, 100));
            

            let obb1 = new OBB(new vector(this.testRect1.x,this.testRect1.y),200,100,this.testRect1.rotation);
            let obb2 = new OBB(new vector(this.testRect2.x,this.testRect2.y),100,200,this.testRect2.rotation);
            console.log(this.detectorOBBvsOBB(obb1,obb2));

            // let line3 = this.getLine(p1.x,p1.y,p3.x,p3.y)
            // if (this.isCollsion(line1, this.testRect2.x, this.testRect2.y, 100, 200)) {
            // this.isCollsion(line1, this.testRect2.x, this.testRect2.y, 100, 200)
            // if (this.testRect1.rotation % 90 != 0) {
            
            // } else {
            //     console.log("2", this.rectCollsion(this.testRect1.x - 100, this.testRect1.y, this.testRect2.x, this.testRect2.y, 200, 100, 100, 200));
            // }

            // } else {
            //     console.log("false");
            // }
            this.localToGlobal
        }, this)
    }

    detectorOBBvsOBB(OBB1:OBB, OBB2:OBB) {
        var nv = OBB1.centerPoint.sub(OBB2.centerPoint);
        var axisA1 = OBB1.axes[0];
        if (OBB1.getProjectionRadius(axisA1) + OBB2.getProjectionRadius(axisA1) <= Math.abs(nv.dot(axisA1))) return false;
        var axisA2 = OBB1.axes[1];
        if (OBB1.getProjectionRadius(axisA2) + OBB2.getProjectionRadius(axisA2) <= Math.abs(nv.dot(axisA2))) return false;
        var axisB1 = OBB2.axes[0];
        if (OBB1.getProjectionRadius(axisB1) + OBB2.getProjectionRadius(axisB1) <= Math.abs(nv.dot(axisB1))) return false;
        var axisB2 = OBB2.axes[1];
        if (OBB1.getProjectionRadius(axisB2) + OBB2.getProjectionRadius(axisB2) <= Math.abs(nv.dot(axisB2))) return false;
        return true;

    }


    getDistance(obj1, obj2) {
        let distance = Math.sqrt(Math.pow(obj1.x - obj2.x, 2) + Math.pow(obj1.y - obj2.y, 2));
        return distance;
    }

    getRectPoint(origin, p, angle, l1?, l2?) {
        var radian = angle * Math.PI / 180;
        var originx = origin.x;
        var originy = origin.y;
        var px = p.x;
        var py = p.y;

        var x0 = (px - originx) * Math.cos(radian) - (py - originy) * Math.sin(radian) + originx;
        var y0 = (py - originy) * Math.cos(radian) + (px - originx) * Math.sin(radian) + originy;

        return new FYGE.Point(x0, y0);
    }

    getLine(x1, y1, x2, y2) {
        let k = (y2 - y1) / (x2 - x1);
        let b = 0;
        if (k == Infinity) {
            b = y1;
        } else {
            b = y1 - k * x1;
        }
        return new line(k, b, x1, x2)
    }

    /**直线与矩形相交 */
    isCollsion(l: line, x, y, w, h) {
        let k = (y - (y + h)) / ((x) - (x + w));
        let k1 = -k;
        let b = y - k * x;
        let b1 = y - k1 * (x + w);
        let xl = x;
        let xr = x + w;
        let yl = y;
        let yr = y + h;

        let b3 = l.b;
        let k3 = l.k;
        let x1 = l.x1;
        let x2 = l.x2;

        //计算直线和矩形对角线的交点的x,y值;
        let x4 = 0;
        let y4 = 0;
        if (k3 == Infinity) {
            x4 = x1;
            y4 = k * x4 + b;
        } else {
            x4 = (b3 - b) / (k - k3);
            y4 = (b3 - b) / (k - k3) * k3 + b3;
        }

        // console.log(x4,y4);
        //判断交点是否在矩形内
        if ((x4 >= x1 && x4 <= x2) || (x4 >= x2 && x4 <= x1)) {
            if ((xl < x4 && x4 < xr) || (xr < x4 && x4 < xl)) {
                if ((y4 > yl && y4 < yr) || (y4 > yr && y4 < yl)) {

                    return true;
                }
            }
        }

        if (k3 == Infinity) {
            x4 = x1;
            y4 = k1 * x4 + b1;
        } else {
            x4 = (b3 - b1) / (k1 - k3);
            y4 = (b3 - b1) / (k1 - k3) * k3 + b3;
        }

        if ((x4 >= x1 && x4 <= x2) || (x4 >= x2 && x4 <= x1)) {
            if ((xl < x4 && x4 < xr) || (xr < x4 && x4 < xl)) {
                if ((y4 > yl && y4 < yr) || (y4 > yr && y4 < yl)) {

                    return true;
                }
            }
        }
        return false;
    }

    rectCollsion(x1: number, y1: number, x2: number, y2: number, w1: number, h1: number, w2: number, h2: number) {
        var p1 = x1 + w1 * 0.5;
        var p2 = y1 + h1 * 0.5;
        var p3 = x2 + w2 * 0.5;
        var p4 = y2 + h2 * 0.5;
        if ((Math.abs(p1 - p3) <= (w1 + w2) * 0.5) && (Math.abs(p2 - p4) <= (h1 + h2) * 0.5)) {
            return true;
        }
        return false;
    }
}