import { BaseEnemy, enemyState, enemyType } from "./BaseEnemy";
import { EnemyBulletManager } from "../Manager/EnemyBulletManager";
import { LayerManager } from "../Manager/LayerManager";
import { Ins } from "../../Ins";

export class ThreeBallsBoss extends BaseEnemy{
    constructor(){
        super();
    }

    addToViewPort(){
        var that = this;
        super.addToViewPort();
        that.setBody("6c626a83-fa44-44ce-a08f-171cd8f64fd3");
        that.bodyImg.anchorX = that.bodyImg.width>>1;
        that.bodyImg.anchorY = that.bodyImg.height>>1;
        that.x = Ins.stageW*0.5 - that.bodyImg.width*0.5;
        that.y = -that.bodyImg.height;
        that.hitW = 200;
        that.hitH = 150;
        that.health = 400;
        that.enemyType = enemyType.boss;
        that.changeState(enemyState.goStage);
    }

    updateSelf(){
        super.updateSelf();
        var that = this;
        that.bodyImg.rotation += 2;
        switch(that.enemyState){
            case enemyState.goStage:
                if(that.y>=(that.bodyImg.height*0.5)){
                    that.changeState(enemyState.inSatge);
                }
                break;
            case enemyState.inSatge:
                that.worldTime++;
                if(that.worldTime%100==0){
                    that.changeState(enemyState.attack);
                }
                break;
            case enemyState.attack:
                that.createVolatilization();
                break;

        }
    }

    changeState(state:enemyState){
        this.enemyState = state;
        switch(state){
            case enemyState.goStage:
                this.speedY = 2;
                this.speedX = 0;
                this.speedVector.x = 0;
                this.speedVector.y = 1;
                break;
            case enemyState.inSatge:
                this.speedY = 0;
                this.speedX = 0;
                this.speedVector.x = 0;
                this.speedVector.y = 0;
                this.worldTime = 0;
                break;
        }
    }
}