import { PlayerPlane } from "../PlayerPlane";
import { UserHealth } from "../UserHealth";
import { Buff, buffType } from "../Buff/Buff";
import { ClearUpBtn } from "../ClearUpBtn";
import { PointUi } from "../PointUi";
import { GDispatcher } from "../../Main";

export class GameManager{
    private static _ins:GameManager = null;
    static get INS(){
        if(!this._ins){
            this._ins = new GameManager();
        }
        return this._ins;
    }

    playerPlane:PlayerPlane = null;
    userHealth:UserHealth = null;
    boomBtn:ClearUpBtn = null;
    pointUi:PointUi = null;
    buffArr:Buff[] = [];
    playerScore:number = 0;
    playerMaxScore:number = 0;
    isBreak:boolean = false;
    _pause:boolean = false;

    constructor(){
        // window["GameManager"] = this;
    }

    addScore(value:number){
        var that = this;
        that.playerScore += value;
        if(that.playerMaxScore <= 0){
            that.playerMaxScore = that.playerScore;
            that.pointUi.breakRecord();
        }
        else if(that.playerScore>that.playerMaxScore){
            that.playerMaxScore = that.playerScore;
            that.pointUi.breakRecord();
        }
        that.pointUi.updateLabel();
    }

    /**提交分数 */
    submitScore(){
        if(this.isBreak)
            GDispatcher.dispatchEvent("submitScore",{maxScore:this.playerMaxScore})
    }

    /**添加玩家生命值ui */
    createUserHealth(view:FYGE.Container,x:number,y:number){
        if(this.userHealth){
            this.userHealth.parent.removeChild(this.userHealth);
            this.userHealth = null;
        }
        this.userHealth = new UserHealth(x,y);
        view.addChild(this.userHealth);
    }

    createPointUi(view:FYGE.Container,data?:any){
        if(this.pointUi){
            this.pointUi.parent.removeChild(this.pointUi);
            this.pointUi = null;
        }
        this.pointUi = new PointUi(data);
        view.addChild(this.pointUi);
    }

    /**添加原子弹按钮ui */
    createBoomBtn(view:FYGE.Container,x:number,y:number){
        if(this.boomBtn){
            this.boomBtn.parent.removeChild(this.boomBtn);
            this.boomBtn = null;
        }
        this.boomBtn = new ClearUpBtn();
        this.boomBtn.x = x;
        this.boomBtn.y = y;
        view.addChild(this.boomBtn);
    }

    /**添加buff */
    createBuff(view:FYGE.Container,x:number,y:number,buffType:buffType){
        var buff = new Buff(x,y,buffType,this.playerPlane);
        view.addChild(buff);
        this.buffArr.push(buff);
    }

    updateGame(){
        for(var i=0;i<this.buffArr.length;i++){
            if(this.buffArr[i])
                this.buffArr[i].updateSelf();
        }
    }

    buffArrRemove(obj){
        if(obj&&obj.parent){
            obj.parent.removeChild(obj);
        }
        var index = this.buffArr.indexOf(obj);
        if(index>=0){
            this.buffArr.splice(index,1);
        }
    }
}