/**全局类，用来放一些设定属性或是特殊属性 */
export class Ins{
    /**舞台宽高 */
    public static stageW:number;
    public static stageH:number;

    /**每个类的敌人飞机使用的主飞机图片资源，对应的默认资源都在默认自带的resCanvasList中可以找到 */
    public static enemyImg={
        Blue:"",         //对应Blue类，资源对应默认的enemy_blue资源;
        BlueBoss:"",     //对应BlueBoss类，资源对应默认的blueBoss资源；
        Green:"",        //对应Green类，资源对应默认的enemy_green资源；
        GreenBoss:"",    //对应GreenBoss类，资源对应默认的greenBoss资源；
        Mazarine:"",     //对应Mazarine类，资源对应默认的enemy_mazarine资源；
        PurpleBoss:"",   //对应PurpleBoss类，资源对应默认的purpleBoss资源；
        RedBoss:"",      //对应RedBoss类，资源对应默认的redBoss资源；
        Rotary:"",       //对应Rotary类，资源对应默认的enemy_rotary资源
        Small:""         //对应Small类，资源对应默认的enemy_small资源
    }

    /**每种敌人对应的分数
     * @param
     * normalEnemy:一般敌人
     * eliteEnemy:精英敌人
     * bossEnemy:boss敌人
     */
    public static enemyScore = {
        normalEnemy:20,
        eliteEnemy:50,
        bossEnemy:180
    }

    /**无尽模式中同屏出现的最大敌人数量 */
    public static maxEnemyCnt:number = 15;
    /**无尽模式中敌人出现的间隔，单位：毫秒 */
    public static enemyInitFrame:number = 500;
}