/**
 * Created by rockyl on 2020/8/26.
 *
 * @id ui
 * @name 一些UI组件
 * @desc 一些UI组件
 */

/**
 * @type 3
 * @name 下拉选择器
 * @desc 下拉选择器，传入键值对options，例：{aaa:'哈哈',bbb:'嘿嘿'}即生成两个下拉选项}
 */
export class Select {
	render() {
		const {options, value, onValueChange} = this.props;

		return (
			<select value={value} onChange={e => onValueChange(e.target.value)}>
				{Object.keys(options).map(key => (
					<option key={key} value={key}>{options[key]}</option>
				))}
			</select>
		)
	}
}
