/**
 * Created by rockyl on 2020/9/19.
 */

import {RedPack} from "./RedPack";
import {WidgetBase, ObjectPool, Event, MouseEvent, injectProp, TextureCache} from "fyge";

const PoolName = 'pack';

ObjectPool.registerPool(PoolName, function () {
	return new RedPack();
}, function (redPack, data) {
	redPack.init(data);
});

export class RedPackRainWidget extends WidgetBase {
	_status;
	_intervalCounting;

	constructor() {
		super();

		this.addEventListener(Event.ENTER_FRAME, this.onEnterFrame, this);
		this.addEventListener(MouseEvent.CLICK, this.onTap, this);
	}

	onEvent(type, payload) {
		switch (type) {
			case 'reset':
				this.reset();
				break;
			case 'start':
                injectProp(this, payload);
                // console.log("aa",payload)
				this.start();
				break;
			case 'pause':
				this.pause();
				break;
			case 'resume':
				this.start();
				break;
			case 'stop':
				this.stop();
				break;
			default:
				console.log(type);
		}
	}

	reset() {
		this.pause();

		while (this.children.length > 0) {
			this.recycleOne(this.children[0]);
		}
	}

	start() {
        console.log(TextureCache)
        console.log("props",this.props);
		this._status = 1;
		this._intervalCounting = this.props.intervalFrames;
	}

	pause() {
		this._status = 0;
	}

	stop() {
		this.reset();
	}

	recycleOne(child) {
		this.removeChild(child);
		ObjectPool.recycleObject(PoolName, child);
	}

	dropOne() {
		const {assets, angleOffset, speedRange, initPosRange} = this.props;
        
        console.log("Ass",assets);
		let r = Math.random();
		let targetAssetIndex;
		for (let i = 0, li = assets.length; i < li; i++) {
			const asset = assets[i];
			r -= asset.ratio;
			if (r <= 0) {
				targetAssetIndex = i;
				break;
			}
		}

		let pack = ObjectPool.getObject(PoolName, {
			type: targetAssetIndex,
			source: assets[targetAssetIndex].source,
			angleOffset,
			speed: Math.random() * (speedRange.max - speedRange.min) + speedRange.min,
			initPos: Math.random() * (initPosRange.max - initPosRange.min) + initPosRange.min,
		});

		this.addChild(pack);
	};

	onEnterFrame() {
		if (this._status === 1) {
			this._intervalCounting--;
			if (this._intervalCounting <= 0) {
				this._intervalCounting = this.props.intervalFrames;
				this.dropOne();
			}

			for (let i = 0, li = this.children.length; i < li; i++) {
				const child = this.children[i];

				if (child.schedule()) {
					i--;
					li--;

					this.recycleOne(child);
				}
			}
		}
	}

	onTap(event) {
		if (event.currentTarget instanceof RedPack) {
			const {type, pos, globalPos} = event.currentTarget;
			let payload = {type, pos, globalPos};

			this.recycleOne(event.currentTarget);
			this.dispatchOutEvent('hit', payload);
		}
	}
}
