import { Sprite, TextureCache, Tween } from "fyge";

export class Smoke extends Sprite{
    
    smokeImg;

    constructor(x,y,r){
        super();
        this.x = x;
        this.y = y;
        if(r){
            this.rotation = r;
        }
        this.init();
    }

    init(){
        this.smokeImg = new Sprite(TextureCache["13ef2773-e156-4bef-8730-37f3a0578a22"]);
        this.addChild(this.smokeImg);
        this.smokeImg.x = -this.smokeImg.width*0.5;
        this.smokeImg.y = -this.smokeImg.height*0.5;
        // this.rotation = 180;
        // this.smokeImg.scaleX = this.smokeImg.scaleY = 0.5;

        Tween.get(this).to({alpha:0},300).call(()=>{
            if(this&&this.parent){
                this.parent.removeChild(this);
            }
        })
    }
}