import { Sprite, TextField, Tween } from "fyge";

export class ScoreTips extends Sprite{

    score = 0;
    scoreLabel;

    constructor(){
        super();
    }

    init(val,x,y){
        this.score = val;
        this.x = x;
        this.y = y;
        this.scoreLabel = new TextField();
        this.scoreLabel.size = 32;
        this.scoreLabel.strokeColor = "#66ccff"
        this.scoreLabel.stroke = 2;
        this.scoreLabel.text = '+'+this.score;
        this.addChild(this.scoreLabel);
        this.scoreLabel.x = -this.scoreLabel.textWidth*0.5;
        this.scoreLabel.y = -this.scoreLabel.textHeight*0.5;

        Tween.get(this).to({y:y-50},500).call(()=>{
            if(this&&this.parent){
                this.parent.removeChild(this);
            }
        })
    }
}