import { Sound } from "fyge";
import * as SvgaParser from "svga-parser";
export class Ins{
    static stageW;
    static stageH;
    static normalCarArr;
    static vipCarArr;
    static speedX;
    static speedY;
    static minSpeedY = 10;
    static maxLevel = 2;
    static effectLayer;
    static CarState = {
        default:1,
        goStage:2,
        inStage:3,
        turning:4,
        wait:5,
        turnOver:6
    }
    static leftStartX = 150;
    static rightStartX = 600;
    static canTouch = false;

    static trackCarArr1 = [];
    static trackCarArr2 = [];

    static msg = {
        trackTurnOver:"trackTurnOver",
        oneTurnOver:"oneTurnOver",
        vipStartTurn:"vipStartTurn"
    }

    static svgaSource = [
        {src:'https://yun.duiba.com.cn/spark/assets/dedd4a9ac243add7a6d98832169d7cf9619b8ace.svga',pool:'vipWhite'}, //白色vip轨迹
        {src:'https://yun.duiba.com.cn/spark/assets/408c7fef572cb91d72c61d6683fd58195bdb0d6b.svga',pool:'vipOrigen'}, //橙色vip轨迹
        {src:'https://yun.duiba.com.cn/spark/assets/73ac94bd65aac58ae9aa579c5c002c2580ba1b4f.svga',pool:'vipRed'}, //红色vip轨迹
        {src:'https://yun.duiba.com.cn/spark/assets/262dc08ac3d0854dd0a476ba8840831598d7f233.svga',pool:'vipBlue'}, //蓝色vip轨迹
        {src:'https://yun.duiba.com.cn/spark/assets/1fd4eb658813a6662186ab6d867e80b5ea7d2860.svga',pool:'Wait'}, //等待尾气
        {src:'https://yun.duiba.com.cn/spark/assets/64ce8e739f9fdc1718fb03401d170f413755ade5.svga',pool:'trailGas'}, //普通车转弯轨迹
        {src:'https://yun.duiba.com.cn/spark/assets/753d6cd47b35a6da2065e902dfaa7820e7df5865.svga',pool:'turnFailed'}   //右转弯失败
    ]

    static svgaPool={
        vipWhite:'',
        vipOrigen:'',
        vipRed:'',
        vipBlue:'',
        Wait:'',
        trailGas:'',
        turnFailed:''
    };

    static vipText = [
        '智能安全模式',
        '沉浸式座舱',
        '宽敞舒适空间',
        '动力强油耗低'
    ]

    static levelInitTrackerTime = {
        1:[30,100],
        2:[30,100],
        3:[30,100],
        4:[30,100],
        5:[30,100],
        6:[30,90],
        7:[30,90],
        8:[30,90],
        9:[30,90],
        10:[30,90],
        11:[40,60],
        12:[40,60],
        13:[40,60],
        14:[40,60],
        15:[40,60],
        16:[40,50],
        17:[40,50],
        18:[40,50],
        19:[40,50],
        20:[40,50]
    }
}
export function LoadSvgaToCache(callback, arr) {
        
    let count = 0;
    let countAll = arr.length;
    // console.log(countAll)
    if (!countAll) callback(true);
    let mark = true;
    for (let i = 0; i < countAll; i++) {
        SvgaParser.loadSvga(
            arr[i].src,
            (v) => {
                Ins.svgaPool[arr[i].pool] = v;
            },
            (err) => {
                mark = false;
                console.log(err);
            }
        )
        if (++count == countAll) callback(mark);
    }
}

export function loadSvgaList() {
    console.log("开始加载svga资源")
    let list = [];
    for (let key in Ins.svgaSource) {
        list.push(Ins.svgaSource[key]);
    }
    // console.log(list)
    let p = new Promise((resolve, reject) => {

        LoadSvgaToCache((s) => {
            if (s) {
                console.log("svgapool",Ins.svgaPool);
                resolve()
            } else {
                reject();
            }
        }, list /*, resPath + name*/ )
    })
    Sound
    return p;
}

export class vector {
    x;
    y;
    constructor(x, y) {
        this.x = x||0;
        this.y = y||0;
    }

    sub(v) {
        return new vector(this.x-v.x,this.y-v.y);
    }

    dot(v) {
        return this.x * v.x + this.y * v.y;
    }
}

export class OBB {
    centerPoint;
    extents;
    axes;
    w;
    h;
    rotation;

    constructor(cenerPoint,w,h,r){
        let radius = r*Math.PI/180;
        this.centerPoint = cenerPoint;
        this.extents = [w/2,h/2];
        this.axes = [new vector(Math.cos(radius),Math.sin(radius)),new vector(-1*Math.sin(radius),Math.cos(radius))];

        this.w=w;
        this.h=h;
        this.rotation = r;
    }

    getProjectionRadius(axis) {
        return this.extents[0] * Math.abs(axis.dot(this.axes[0]))+this.extents[1]*Math.abs(axis.dot(this.axes[1]));
    }
}

export function detectorOBBvsOBB(OBB1, OBB2) {
    var nv = OBB1.centerPoint.sub(OBB2.centerPoint);
    var axisA1 = OBB1.axes[0];
    if (OBB1.getProjectionRadius(axisA1) + OBB2.getProjectionRadius(axisA1) <= Math.abs(nv.dot(axisA1))) return false;
    var axisA2 = OBB1.axes[1];
    if (OBB1.getProjectionRadius(axisA2) + OBB2.getProjectionRadius(axisA2) <= Math.abs(nv.dot(axisA2))) return false;
    var axisB1 = OBB2.axes[0];
    if (OBB1.getProjectionRadius(axisB1) + OBB2.getProjectionRadius(axisB1) <= Math.abs(nv.dot(axisB1))) return false;
    var axisB2 = OBB2.axes[1];
    if (OBB1.getProjectionRadius(axisB2) + OBB2.getProjectionRadius(axisB2) <= Math.abs(nv.dot(axisB2))) return false;
    return true;

}

/**生成范围内的随机数 */
export function getRandomValue(min,max){
    return Math.floor(Math.random()*(max-min+1)+min);
}

// 二次贝塞尔,用于做曲线运动
export function bezier(t, p0, p1, p2) {
    // (1-t)^2 P0 + 2(1-t)tP1+ t^2P2
    return Math.pow(1 - t, 2) * p0 + 2 * (1 - t) * t * p1 + Math.pow(t, 2) * p2;
}