import {
    Ease,
    Event,
    GDispatcher,
    MovieClip,
    Point,
    Shape,
    Sound,
    Sprite,
    TextField,
    TextureCache,
    TEXT_ALIGN,
    Tween,
    VERTICAL_ALIGN
} from "fyge";
import {
    Ins,
    bezier
} from "./Ins";
import {
    Smoke
} from "./Smoke";
import { cusPlaySound } from "./Sound";

export class Car extends Sprite {

    worldTime = 0;
    carImg; //车辆图片
    speedX; //X轴速度
    speedY; //Y轴速度
    speedVector; //速度矢量
    type; //类型，0：路上的车，1：玩家的车
    isTurning; //正在转弯，特指玩家的车
    isVip; //是否是vip车辆
    vipId; //vipId,判断是哪种vip,主要用于不同的svga动效
    dir; //方向，0：朝右，1：朝左，2：朝上，3：朝下
    carState; //车辆状态
    distance;
    turnOver = false;
    t;
    isLast; //是否是当前车辆的最后一辆
    smokePoint; //生成烟的位置,为了简单快捷，用shape当作点，因为shape会跟着rotation变动
    smokePoint1;

    waitSvga; //等待尾气svga动效
    gasSvga; //甩尾svga动效

    vipTipsFrame; //vip提示框图片
    vipTipsLabel; //vip提示框文本

    light; //车辆灯，vip是蓝灯，普通车是转弯失败的红灯
    turnFailedImg;  //右转失败的图片

    constructor() {
        super();
        this.addEventListener(Event.ADDED_TO_STAGE, this.addToViewPort, this)
        GDispatcher.addEventListener(Event.REMOVED_FROM_STAGE, this.removeFromViewPort, this);
    }

    addToViewPort() {
        this.removeEventListener(Event.ADDED_TO_STAGE, this.addToViewPort, this)
        this.initEle();
    }

    removeFromViewPort() {
        this.removeEventListener(Event.REMOVED_FROM_STAGE, this.removeFromViewPort, this);
        if (this.waitSvga) {
            Ins.effectLayer.removeChild(this.waitSvga);
        }
        if (this.gasSvga) {
            Ins.effectLayer.removeChild(this.gasSvga);
        }
        if(this.vipTipsLabel&&this.vipTipsFrame){
            this.vipTipsFrame.removeChild(this.vipTipsLabel);
        }
        if(this.vipTipsFrame&&this.vipTipsFrame.parent){
            this.vipTipsFrame.parent.removeChild(this.vipTipsFrame);
        }
        Tween.removeTweens(this);
    }

    initEle() {

    }

    /**
     * 
     * @param type 类型，0：路上的车，1：玩家的车
     * @param isVip 是否是vip车辆
     * @param x x坐标
     * @param y y坐标
     * @param dir 方向，0：朝右，1：朝左，2：朝上，3：朝下
     * @param 
     */
    initUi({
        type,
        isVip,
        x,
        y,
        dir,
        isLast
    }) {
        this.type = type;
        this.isVip = isVip;
        this.dir = dir;
        this.x = x;
        this.y = y;
        this.isLast = isLast;
        this.speedVector = new Point(0, 0);
        this.carImg = new Sprite();
        this.addChild(this.carImg);
        let index1 = Math.floor(Math.random() * Ins.normalCarArr.length);
        let uuid1 = Ins.normalCarArr[index1];
        let index2 = Math.floor(Math.random() * Ins.vipCarArr.length);
        let uuid2 = Ins.vipCarArr[index2];
        
        if (type == 0) {
            if (Math.random() > 0.3) {
                this.carImg.texture = TextureCache[uuid1];
            } else {
                this.carImg.texture = TextureCache[uuid2];
            }

        } else {
            // this.turnFailedImg = new Sprite(TextureCache['c1ab4c77-ec5e-48f3-9bdc-8753e892c705']);
           
            this.light = new Sprite();
            this.addChildAt(this.light, 0);
            if (isVip) {
                this.vipId = index2;
                this.carImg.texture = TextureCache[uuid2];
                this.light.texture = TextureCache["144a900b-e799-468d-b511-0f71b7caa114"];
                this.vipTipsFrame = new Sprite(TextureCache["8177b4e1-2032-47e3-b8e9-f3b802b85b5b"]);
                this.parent.addChild(this.vipTipsFrame);
                this.vipTipsLabel = new TextField();
                this.vipTipsLabel.textWidth = this.vipTipsFrame.width;
                this.vipTipsLabel.textHeight = this.vipTipsFrame.height;
                this.vipTipsLabel.textAlign = TEXT_ALIGN.CENTER;
                this.vipTipsLabel.verticalAlign = VERTICAL_ALIGN.MIDDLE;
                this.vipTipsLabel.size = 24;
                this.vipTipsLabel.text = Ins.vipText[Math.floor(Math.random()*Ins.vipText.length)]
                this.vipTipsFrame.addChild(this.vipTipsLabel);
                this.vipTipsFrame.alpha = 0; 
            } else {
                // console.log(TextureCache[uuid1]);
                this.carImg.texture = TextureCache[uuid1];
                this.light.texture = TextureCache["5460bdbf-5770-4b99-a570-3013bb4fe415"];
            }
            this.light.x = -this.light.width * 0.5;
            this.light.y = -this.light.height - this.carImg.height * 0.5 + 10;
            this.light.alpha = 0;
        }
        this.carImg.x = -this.carImg.width * 0.5;
        this.carImg.y = -this.carImg.height * 0.5;

        this.smokePoint = new Shape();
        this.smokePoint.beginFill(6, 1);
        this.smokePoint.drawCircle(0, 0, 0);
        this.smokePoint.endFill();
        this.addChild(this.smokePoint);
        this.smokePoint.x = 0;
        this.smokePoint.y = this.carImg.height * 0.5 + 5;



        // this.smokePoint1 = new Shape();
        // this.smokePoint1.beginFill(6, 0);
        // this.smokePoint1.drawCircle(0, 0, 10);
        // this.smokePoint1.endFill();
        // this.addChild(this.smokePoint1);
        // this.smokePoint1.x = -16;
        // this.smokePoint1.y = this.carImg.height * 0.5+10;

        //方向，0：朝右，1：朝左，2：朝上，3：朝下
        switch (dir) {
            case 0:
                this.rotation = 90;
                this.speedX = Ins.speedX;
                this.speedY = 0;
                this.speedVector.x = 1;
                this.speedVector.y = 0;
                this.changeState(Ins.CarState.goStage);
                break;
            case 1:
                this.rotation = -90;
                this.speedX = Ins.speedX;
                this.speedY = 0;
                this.speedVector.x = -1;
                this.speedVector.y = 0;
                this.changeState(Ins.CarState.goStage);
                break;
            case 2:
                this.speedY = Ins.speedY;
                this.speedX = 0;
                this.speedVector.y = -1;
                break;
            case 3:
                this.rotation = 180;
                this.speedY = Ins.speedY;
                this.speedX = 0;
                this.speedVector.y = 1;
                break;
            default:
                console.log("dir设置出错");
                break;
        }

    }

    setDistance(distance) {
        this.resetFailSvga();
        this.distance = distance
    }

    /**重置失败动效 */
    resetFailSvga(){
        if(this.light){
            Tween.removeTweens(this.light)
            this.light.alpha = 0;
        }

        if(this.turnFailedImg){
            this.turnFailedImg.visible = false;;
            // this.turnFailedImg.scaleX = 1.2;
            // this.turnFailedImg.scaleY = 1.2;
            // this.turnFailedImg.alpha = 0.2
        }
    }

    stopSvga() {
        if (this.gasSvga) {
            this.gasSvga.stop();
        }
    }

    /**转弯失败 */
    turnFailed(){
        this.stopSvga();
        console.log("音效",this.sound);
        if(this.sound){
            
            this.sound.stop();
        }
        if(!this.turnFailedImg){
            // console.log("haha",Ins.svgaPool['turnFailed'])
            this.turnFailedImg = new MovieClip(Ins.svgaPool.turnFailed)
            this.parent.addChildAt(this.turnFailedImg,999);
            // this.turnFailedImg.anchorX = this.turnFailedImg.videoWidth*0.5;
            // this.turnFailedImg.anchorY = this.turnFailedImg.videoHeight*0.5;
            
            this.turnFailedImg.visible = true;
            this.turnFailedImg.x = this.x-this.turnFailedImg.videoWidth*0.5;
            this.turnFailedImg.y = this.y+this.carImg.height*0.5-this.turnFailedImg.videoHeight*0.4;
            this.turnFailedImg.startAniRange(1,this.turnFailedImg.totalFrames,1);
            // console.log(this.turnFailedImg);
        }else{
            this.turnFailedImg.visible = true;
            this.turnFailedImg.x = this.x-this.turnFailedImg.videoWidth*0.5;
            this.turnFailedImg.y = this.y+this.carImg.height*0.5-this.turnFailedImg.videoHeight*0.4;
            this.turnFailedImg.startAniRange(1,this.turnFailedImg.totalFrames,1);
            // console.log(this.turnFailedImg);
        }
        // Tween.get(this.turnFailedImg).to({alpha:1},100);
        // Tween.get(this.turnFailedImg).to({alpha:1,scaleX:1,scaleY:1},600,Ease.quartOut);
        if(!this.isVip){
            Tween.get(this.light)
            .to({alpha:1},100)
            .to({alpha:0.2},100)
            .to({alpha:1},100)
            .to({alpha:0.2},100)
            .to({alpha:1},100)
            .to({alpha:0.2},100)
            .to({alpha:1},100)
        }
        
    }

    updateSelf(index) {
        if (this.type == 0) {
            this.x += this.speedX * this.speedVector.x;
            this.y += this.speedY * this.speedVector.y;
            if (this.speedVector.y > 0) {
                if (this.y >= 3348) {
                    return true;
                }
            } else if (this.speedVector.y < 0) {
                if (this.y <= -100) {
                    return true;
                }
            }
        } else {
            switch (this.carState) {
                case Ins.CarState.default:
                    break;
                case Ins.CarState.goStage:
                    this.goStage(index);
                    break;
                case Ins.CarState.inStage:
                    this.inStage(index);
                    break;
                case Ins.CarState.turning:
                    this.turning();
                    break;
                case Ins.CarState.wait:
                    break;
                case Ins.CarState.turnOver:
                    this.x += this.speedX * this.speedVector.x;
                    this.y += this.speedY * this.speedVector.y;
                    if (this.speedVector.y > 0) {
                        if (this.y >= 3348) {
                            return true;
                        }
                    } else if (this.speedVector.y < 0) {
                        if (this.y <= -100) {
                            return true;
                        }
                    }
                    break;
                default:
                    console.log("变换车辆状态错误");
                    break;
            }
        }
    }

    inStage(index) {
        if (this.waitSvga) {
            let p = this.localToGlobal(new Point(this.smokePoint.x, this.smokePoint.y))
            this.waitSvga.x = p.x - this.waitSvga.videoWidth * 0.5;
            this.waitSvga.y = p.y - this.waitSvga.videoHeight * 0.5;
        }
        if (this.isVip && index == 0) {
            let targetX = 0;
            let targetY = 0;
            let canTurn = true;
            let scale = Ins.speedY / Ins.minSpeedY;
            if (this.dir == 0) { //朝右
                targetY = bezier(1, 820, 820, 920);
                for (let i = 0; i < Ins.trackCarArr1.length; i++) {
                    let y1 = Ins.trackCarArr1[i].y + Ins.trackCarArr1[i].carImg.height * 0.5 + Ins.speedY * 12;
                    let y2 = Ins.trackCarArr1[i].y - Ins.trackCarArr1[i].carImg.height * 0.5 + Ins.speedY * 12;
                    if ((y1) >= (this.y - this.carImg.height * 0.8) && y2 <= (targetY + this.carImg.height * 0.8)) {
                        canTurn = false;
                    }
                }
            } else if (this.dir == 1) { //朝左
                // targetX = bezier(1, Ins.rightStartX, 451, 451);
                targetY = bezier(1, 2422, 2422, 2322);
                for (let i = 0; i < Ins.trackCarArr2.length; i++) {
                    let y1 = Ins.trackCarArr2[i].y - Ins.trackCarArr2[i].carImg.height * 0.5 - Ins.speedY * 12;
                    let y2 = Ins.trackCarArr2[i].y + Ins.trackCarArr2[i].carImg.height * 0.5 - Ins.speedY * 12;
                    if ((y1) <= (this.y + this.carImg.height * 0.8) && y2 >= (targetY - this.carImg.height * 0.8)) {
                        canTurn = false;
                    }
                }
            }
            if (canTurn) {
                // this.changeState(Ins.CarState.turning)
                GDispatcher.dispatchEvent(Ins.msg.vipStartTurn);
            }
        }
    }

    carMoveNormal() {

    }

    turning() {
        // this.worldTime ++ ;
        // if (this.worldTime % 5 == 0) {
        //     let p = this.localToGlobal(new Point(this.smokePoint.x, this.smokePoint.y))
        //     console.log(p.x, p.y);
        //     Ins.effectLayer.addChild(new Smoke(p.x, p.y,this.rotation));

        //     let p1 = this.localToGlobal(new Point(this.smokePoint1.x, this.smokePoint1.y))
        //     console.log(p1.x, p1.y);
        //     Ins.effectLayer.addChild(new Smoke(p1.x, p1.y,this.rotation));
        // }


        if (this.dir == 0) {
            this.t += 0.04;
            if (this.t >= 1) {
                this.changeState(Ins.CarState.turnOver);
                return;
            }
            this.x = bezier(this.t, Ins.leftStartX, 302, 302);
            this.y = bezier(this.t, 820, 820, 920);
            if (this.t <= 0.6) {
                this.rotation += 3;
            } else {
                let r = this.rotation + 5;
                if (r >= 180) {
                    this.rotation = 180;
                } else {
                    this.rotation += 5;
                }

            }

        } else if (this.dir == 1) {
            this.t += 0.04;
            if (this.t >= 1) {
                this.changeState(Ins.CarState.turnOver);
                return;
            }
            this.x = bezier(this.t, Ins.rightStartX, 451, 451);
            this.y = bezier(this.t, 2422, 2422, 2322);
            if (this.t <= 0.6) {
                this.rotation += 3;
            } else {
                let r = this.rotation + 5;
                if (r >= 0) {
                    this.rotation = 0;
                } else {
                    this.rotation += 5;
                }

            }
        }

    }


    goStage(index) {
        if (this.dir == 0) { //朝右
            this.x += this.speedX * this.speedVector.x;
            if (this.x >= (Ins.leftStartX - this.distance)) {
                this.changeState(Ins.CarState.inStage,index);
            }
        } else if (this.dir == 1) { //朝左
            this.x += this.speedX * this.speedVector.x;
            if (this.x <= Ins.rightStartX + this.distance) {
                this.changeState(Ins.CarState.inStage,index);
            }
        }
    }

    setGasSvga() {
        if (!this.gasSvga) {
            if (!this.isVip) {
                this.gasSvga = new MovieClip(Ins.svgaPool.trailGas);
                Ins.effectLayer.addChild(this.gasSvga);
                if (this.dir == 0) {
                    let p = this.localToGlobal(new Point(0, 0));
                    this.gasSvga.anchorX = this.gasSvga.videoWidth * 0.5;
                    this.gasSvga.anchorY = this.gasSvga.videoHeight * 0.5;
                    this.gasSvga.rotation = 180;
                    this.gasSvga.x = p.x - 130;
                    this.gasSvga.y = p.y - 142;
                    // console.log("gasSvga", p.x, p.y);
                    this.gasSvga.visible = true;
                    this.gasSvga.startAniRange(1, this.gasSvga.totalFrames, 1, () => {
                        this.gasSvga.visible = false
                    });
                } else if (this.dir == 1) {
                    let p = this.localToGlobal(new Point(0, 0));
                    this.gasSvga.x = p.x - 274;
                    this.gasSvga.y = p.y - 242;
                    // console.log("gasSvga", p.x, p.y);
                    this.gasSvga.visible = true;
                    this.gasSvga.startAniRange(1, this.gasSvga.totalFrames, 1, () => {
                        this.gasSvga.visible = false
                    });
                }
            } else {
                switch (this.vipId) {
                    case 0:
                        this.gasSvga = new MovieClip(Ins.svgaPool.vipWhite);
                        break;
                    case 1:
                        this.gasSvga = new MovieClip(Ins.svgaPool.vipOrigen)
                        break;
                    case 2:
                        this.gasSvga = new MovieClip(Ins.svgaPool.vipRed);
                        break;
                    case 3:
                        this.gasSvga = new MovieClip(Ins.svgaPool.vipBlue);
                        break;
                    default:
                        console.log("vipId出错");
                        break;
                }
                Ins.effectLayer.addChild(this.gasSvga);
                if (this.dir == 0) {
                    let p = this.localToGlobal(new Point(0, 0));
                    this.gasSvga.anchorX = this.gasSvga.videoWidth * 0.5;
                    this.gasSvga.anchorY = this.gasSvga.videoHeight * 0.5;
                    this.gasSvga.rotation = 180;
                    this.gasSvga.x = p.x - 100;
                    this.gasSvga.y = p.y - 50;
                    // console.log("gasSvga", p.x, p.y);
                    this.gasSvga.visible = true;
                    this.gasSvga.startAniRange(5, this.gasSvga.totalFrames, 1, () => {
                        this.gasSvga.visible = false
                    });
                } else if (this.dir == 1) {
                    let p = this.localToGlobal(new Point(0, 0));
                    this.gasSvga.x = p.x - 205;
                    this.gasSvga.y = p.y - 150;
                    // console.log("gasSvga", p.x, p.y);
                    this.gasSvga.visible = true;
                    this.gasSvga.startAniRange(5, this.gasSvga.totalFrames, 1, () => {
                        this.gasSvga.visible = false
                    });
                }
            }


        } else {
            this.gasSvga.visible = true;
            this.gasSvga.startAniRange(1, this.gasSvga.totalFrames, 1, () => {
                this.gasSvga.visible = false
            });
        }
    }

    sound;

    changeState(state,index) {
        this.carState = state;
        if (state != Ins.CarState.inStage) {
            if (this.waitSvga) {
                this.waitSvga.visible = false;
            }
        } else {
            if (this.waitSvga) {
                this.waitSvga.visible = true;
            }
        }
        switch (state) {
            case Ins.CarState.default:
                break;
            case Ins.CarState.goStage:
                this.resetFailSvga();
                if (this.gasSvga) {
                    this.gasSvga.visible = false;
                }
                if (this.dir == 0) {
                    this.speedVector.x = 1;
                    this.speedVector.y = 0;
                } else if (this.dir == 1) {
                    this.speedVector.x = -1;
                    this.speedVector.y = 0;
                }

                break;
            case Ins.CarState.inStage:
                this.resetFailSvga();
                if (!this.waitSvga) {
                    this.waitSvga = new MovieClip(Ins.svgaPool.Wait);
                    // this.waitSvga.visible = false;
                    // console.log(p.x, p.y);
                    Ins.effectLayer.addChild(this.waitSvga);
                    let p = this.localToGlobal(new Point(this.smokePoint.x, this.smokePoint.y))
                    // console.log("动效属性",p.videoWidth,p.videoHeight)
                    this.waitSvga.anchorY = this.waitSvga.videoHeight * 0.5;
                    this.waitSvga.anchorX = this.waitSvga.videoWidth * 0.5;
                    if (this.dir == 0) {
                        this.waitSvga.scaleY = -1
                        this.waitSvga.rotation = 180;
                    }
                    this.waitSvga.x = p.x - this.waitSvga.videoWidth * 0.5;
                    this.waitSvga.y = p.y - this.waitSvga.videoHeight * 0.5;
                    this.waitSvga.visible = true;
                    // console.log(this.waitSvga);
                }
                if (this.isLast) {
                    Ins.canTouch = true;
                }
                if(index == 0){
                    if(this.vipTipsFrame){
                        this.vipTipsFrame.x = this.x - this.vipTipsFrame.width*0.5;
                        this.vipTipsFrame.y = this.y - this.carImg.width-this.vipTipsFrame.height-20;
                        Tween.removeTweens(this.vipTipsFrame);
                        Tween.get(this.vipTipsFrame).to({alpha:1},200)
                    }
                }
                this.speedVector.x = this.speedVector.y = 0;
                break;
            case Ins.CarState.turning:
                if(this.vipTipsFrame){
                    Tween.removeTweens(this.vipTipsFrame);
                    Tween.get(this.vipTipsFrame).to({alpha:0},200)
                }
                this.setGasSvga();
                this.worldTime = 0;
                this.speedVector.x = 1;
                this.speedVector.y = 1;
                this.speedX = Ins.speedX;
                this.speedY = Ins.speedY;
                this.t = 0;
                if(this.isVip){
                    this.light.alpha = 1;
                    this.sound = cusPlaySound("https://yun.duiba.com.cn/aurora/assets/cb2b36805e0040b89574cfebb2669f3032d5fdb8.mp3")
                }else{
                    this.sound = cusPlaySound("https://yun.duiba.com.cn/aurora/assets/b06dee061913e866c4cec051be7020224aa220d3.mp3")
                }
                
                break;
            case Ins.CarState.wait:
                break;
            case Ins.CarState.turnOver:
                if(this.isVip){
                    Tween.get(this.light).to({alpha:0},200)
                    // this.light.alpha = 0;
                }
                this.turnOver = true;
                this.speedVector.x = 0;
                if (this.dir == 0) {
                    this.speedVector.y = 1;
                } else if (this.dir == 1) {
                    this.speedVector.y = -1;
                }
                GDispatcher.dispatchEvent(Ins.msg.trackTurnOver, {isVip:this.isVip,x:this.x,y:this.y});
                break;
            default:
                console.log("变换车辆状态错误");
                break;
        }
    }
}