'use strict';

import React, { Component } from 'react';
import resList from '../../resconfig/resList';
import dataCenter from '../../util/dataCenter';
import Enum from '../../util/enum';
import util from '../../util/util';
import ViewCtrl from '../../util/viewCtrl';

import './ComspendPointsSure.less';

class ComspendPointsSure extends Component {
  constructor(props) {
    super(props);
    this.state = this.state || { resList: resList, needPointsLabel: '' };
  }

  componentDidMount() {
    const { needCreditsLong } = dataCenter.getData("ajaxElement").element;
    this.setState({
      needPointsLabel: "是否花费" + needCreditsLong + window.CFG.unitName
    })
  }

  spendPointSure() {
    const { status } = dataCenter.getData("ajaxElement").element;
    if (status == 1) {
      ViewCtrl.showWin(Enum.Com.ComgetPoints);
      this.props.closeWin();
    } else {
      // let e = new Event("startGame")
      // document.dispatchEvent(e)
      util.clickDelay("que_ren_an_niu20")
      this.props.call();
      this.props.closeWin();
    }

  }

  render() {
    return (
      <div className="shi_fou_hua_fei_ji_fen zoom">
        <img className="dan_chuang_bei_jing22" src={this.state.resList['a30b6b9e-3a1f-4e5e-94e7-d9f6c118f7a0'].url} />
        <img className="guan_bi_an_niu21" src={this.state.resList['28caebe0-9290-49fe-9661-ccc2c9885520'].url} onClick={this.props.closeWin} />
        <img className="que_ren_an_niu20" src={this.state.resList['fe70684d-21d6-4da0-b55d-65531968c63c'].url} onClick={this.spendPointSure.bind(this)} />
        <label className="que_ren_hua_fei_ji_fenlabel">{this.state.needPointsLabel}</label>
      </div>
    );
  }
}
export default ComspendPointsSure;
