'use strict';

import React, { Component } from 'react';
import resList from '../../resconfig/resList';
import { sendLogBuji } from '../../util/net';
//import API from '../../api';

import './ComGameSuccess.less';
class ComGameSuccess extends Component {
    constructor(props) {
        super(props);
        // debugger
        this.state = {
            resList: resList,
            bgSource: "",
            btnSource: "",
            scoreClass: "score ",
            tipsClass: "tips "
        };
    }

    componentDidMount() {
        if (this.props.data.score < 200) {
            sendLogBuji(4, true)
            this.setState({ bgSource: this.state.resList['86e6d9b6-1494-4404-9b16-c5c560291f9a'].url })
            this.setState({ btnSource: this.state.resList['ce76f2ba-1e2b-4372-98ab-f22c559bc2c1'].url })
            this.setState({ scoreClass: "score red", })
            this.setState({ tipsClass: "tips red", })
        } else {
            sendLogBuji(5, true)
            this.setState({ bgSource: this.state.resList['24270f9f-5fcb-4a8c-b9e3-f6cd9a974609'].url })
            this.setState({ btnSource: this.state.resList['819dffa8-a443-468f-a487-8ef8d9702adc'].url })
            this.setState({ scoreClass: "score gold", })
            this.setState({ tipsClass: "tips gold", })
        }
    }

    async gameSubmit() {
        if (this.props.data.score < 200) {
            sendLogBuji(4, false)
        } else {
            sendLogBuji(5, false)
        }
        await this.props.call()
        this.props.closeWin();
    }

    render() {
        return (
            <div className="ComGameSuccess">
                <img className="bg" src={this.state.bgSource} />
                <span className={this.state.tipsClass}>本局收集好运值</span>
                <span className={this.state.scoreClass} >{this.props.data.score}</span>
                <img className="submitBtn " src={this.state.btnSource} onClick={this.gameSubmit.bind(this)} />
            </div>
        );
    }
}
export default ComGameSuccess;