(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define([], factory);
	else {
		var a = factory();
		for(var i in a) (typeof exports === 'object' ? exports : root)[i] = a[i];
	}
})(window, function() {
return /******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = "./src/Main.ts");
/******/ })
/************************************************************************/
/******/ ({

/***/ "./module/RES.ts":
/*!***********************!*\
  !*** ./module/RES.ts ***!
  \***********************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.RES = void 0;
var RES;
(function (RES) {
    var resData;
    var videoEntityHash = {};
    var soundHash = {};
    var groupsCompleteHash = {};
    var groupsPromiseHash = {};
    var singleResPromiseHash = {};
    function loadConfig(res) {
        resData = res;
        RES.resPath = res.path;
    }
    RES.loadConfig = loadConfig;
    function loadSparkAssets(resList) {
        var list = [];
        for (var key in resList) {
            list.push(resList[key]);
        }
        var p = new Promise(function (resolve, reject) {
            loadResList(function (s) {
                if (s) {
                    resolve();
                }
                else {
                    reject();
                }
            }, list);
        });
        return p;
    }
    RES.loadSparkAssets = loadSparkAssets;
    function loadGroup(name) {
        if (groupsCompleteHash[name]) {
            return new Promise(function (resolve) {
                resolve();
            });
        }
        if (groupsPromiseHash[name]) {
            return groupsPromiseHash[name];
        }
        var arr = getGroupResByName(name);
        if (!arr || !arr.length) {
            groupsCompleteHash[name] = true;
            return new Promise(function (resolve) {
                resolve();
            });
        }
        var p = new Promise(function (resolve, reject) {
            loadResList(function (s) {
                delete groupsPromiseHash[name];
                if (s) {
                    groupsCompleteHash[name] = true;
                    resolve();
                }
                else {
                    reject();
                }
            }, arr);
        });
        groupsPromiseHash[name] = p;
        return p;
    }
    RES.loadGroup = loadGroup;
    function getResAsync(str, comFun, thisObj) {
        var type = str.substring(str.lastIndexOf(".") + 1, str.length);
        if (type == "png" || type == "jpg") {
            if (FYGE.TextureCache[str]) {
                comFun && comFun.call(thisObj, FYGE.TextureCache[str], str);
                new Promise(function (r) {
                    r(FYGE.TextureCache[str]);
                });
            }
            else {
                return new Promise(function (resolve, reject) {
                    FYGE.GlobalLoader.loadImage(function (s, image) {
                        if (s) {
                            FYGE.Texture.addToCache(FYGE.Texture.from(image), str);
                            comFun && comFun.call(thisObj, FYGE.TextureCache[str], str);
                            resolve(FYGE.TextureCache[str]);
                        }
                        else {
                            comFun && comFun.call(thisObj, null, str);
                            reject();
                        }
                    }, str);
                });
            }
        }
    }
    RES.getResAsync = getResAsync;
    function getResByUrl() {
    }
    RES.getResByUrl = getResByUrl;
    function getRes(str) {
        var type = str.substring(str.lastIndexOf(".") + 1, str.length);
        if (type == "png" || type == "jpg") {
            return FYGE.TextureCache[str] || null;
        }
    }
    RES.getRes = getRes;
    function hasRes(str) {
        for (var i = 0; i < resData.groups.length; i++) {
            var group = resData.groups[i];
            var keys = group.keys;
            if (keys && keys.split(",").indexOf(str) > -1) {
                return group.name;
            }
            if (group.atlas && group.name + ".json" == str) {
                return group.name;
            }
        }
        return null;
    }
    function getGroupResByName(name) {
        var group = getGroupByName(name);
        if (!group)
            return null;
        if (group.atlas) {
            var arr = [name + ".json"];
            if (group.keys) {
                arr = arr.concat(group.keys.split(",").filter(function (k) {
                    return k.substr(-4) != ".png";
                }));
            }
            return arr;
        }
        else if (group.keys) {
            return group.keys.split(",");
        }
        else {
            return null;
        }
    }
    function getGroupByName(name) {
        var groups = resData.groups;
        var group;
        for (var i = 0; i < groups.length; i++) {
            if (groups[i].name === name) {
                group = groups[i];
                break;
            }
        }
        return group;
    }
    function loadResList(callback, arr) {
        var count = 0;
        var countAll = arr.length;
        if (!countAll)
            callback(true);
        var mark = true;
        for (var i = 0; i < countAll; i++) {
            var resName = arr[i]['url'];
            getResAsync(resName, function (res, str) {
                if (!res)
                    mark = false;
                if (++count == countAll)
                    callback(mark);
            }, this);
        }
    }
    RES.loadResList = loadResList;
    function returnSingleResPromise(str, comFun, thisObj) {
        singleResPromiseHash[str].then(function (r) {
            comFun && comFun.call(thisObj, r, str);
        }, function () {
            comFun && comFun.call(thisObj, null, str);
        });
        return singleResPromiseHash[str];
    }
    var skinData;
    function loadSkinConfig(skinJson) {
        skinData = skinJson;
    }
    RES.loadSkinConfig = loadSkinConfig;
    function initSkinDisplay(con, skin, root) {
        var data = typeof (skin) == 'string' ? getSkinDataByName(skin) : skin;
        if (!data.children || !data.children.length)
            return;
        for (var i = 0; i < data.children.length; i++) {
            var child = data.children[i];
            if (child.type == "skin")
                continue;
            var dis = con.addChild(getDisplayByData(child));
            if (root && child.id)
                root[child.id] = dis;
            if (child.type == "container")
                initSkinDisplay(dis, child, root);
        }
    }
    RES.initSkinDisplay = initSkinDisplay;
    function getSkinDataByName(skinName, skinNode) {
        if (skinNode === void 0) { skinNode = skinData; }
        if (!skinNode || !skinNode.children || !skinNode.children.length)
            return null;
        for (var i = 0; i < skinNode.children.length; i++) {
            var child = skinNode.children[i];
            if (child.name == skinName && (child.type == "container" || child.type == "skin"))
                return child;
            var gson = getSkinDataByName(skinName, child);
            if (gson)
                return gson;
        }
        return null;
    }
    RES.getSkinDataByName = getSkinDataByName;
    function getSrcByUuid(resList, uuid) {
        resList = resList || [];
        for (var i = 0; i < resList.length; i++) {
            if (resList[i].uuid == uuid) {
                return resList[i].url;
            }
        }
        return "";
    }
    RES.getSrcByUuid = getSrcByUuid;
    function getDisplayByData(data) {
        var dis;
        switch (data.type) {
            case "container":
                dis = new FYGE.Container();
                break;
            case "button":
                dis = new FYGE.Button(getRes(data.props.tUp), data.props.tDown ? getRes(data.props.tDown) : null, data.props.tDisable ? getRes(data.props.tDisable) : null);
                break;
            case "text":
                dis = new FYGE.TextField();
                for (var key in data.props)
                    dis[key] = data.props[key];
                break;
            case "sprite":
                dis = new FYGE.Sprite(getRes(data.props.source));
                break;
            case "rect":
                dis = new FYGE.Shape();
                dis.beginFill(FYGE.string2hex(data.props.fillColor));
                dis.drawRect(0, 0, data.props.width, data.props.height);
                dis.endFill();
                break;
        }
        dis.name = data.name;
        dis.alpha = data.alpha || 1;
        dis.position.set(data.x, data.y);
        return dis;
    }
    function destroyRES() {
    }
})(RES = exports.RES || (exports.RES = {}));


/***/ }),

/***/ "./module/ctrls/index.ts":
/*!*******************************!*\
  !*** ./module/ctrls/index.ts ***!
  \*******************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !exports.hasOwnProperty(p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.destroyAllCtrls = exports.removeTweens = exports.clearWait = exports.wait = exports.showAlert = exports.getCurrentScene = exports.changeScene = exports.closeCurrentPanel = exports.closeAllPanels = exports.showConfirm = exports.showPanel = void 0;
var waitingCtrl_1 = __webpack_require__(/*! ./waitingCtrl */ "./module/ctrls/waitingCtrl.ts");
var panelCtrl_1 = __webpack_require__(/*! ./panelCtrl */ "./module/ctrls/panelCtrl.ts");
var sceneCtrl_1 = __webpack_require__(/*! ./sceneCtrl */ "./module/ctrls/sceneCtrl.ts");
var toastCtrl_1 = __webpack_require__(/*! ./toastCtrl */ "./module/ctrls/toastCtrl.ts");
var toastCtrl_2 = __webpack_require__(/*! ./toastCtrl */ "./module/ctrls/toastCtrl.ts");
Object.defineProperty(exports, "showToast", { enumerable: true, get: function () { return toastCtrl_2.showToast; } });
__exportStar(__webpack_require__(/*! ./waitingCtrl */ "./module/ctrls/waitingCtrl.ts"), exports);
exports.showPanel = function (panel, data) {
    return panelCtrl_1.default.instance.show(panel, data);
};
exports.showConfirm = function (panel, data) {
    var confirmPanel = panelCtrl_1.default.instance.show(panel, data);
    return confirmPanel.makePromise();
};
exports.closeAllPanels = function () {
    panelCtrl_1.default.instance.closeAll();
};
exports.closeCurrentPanel = function () {
    panelCtrl_1.default.instance.closeCurrent();
};
exports.changeScene = function (scene, data) {
    sceneCtrl_1.default.instance.change(scene, data);
};
function getCurrentScene() {
    return sceneCtrl_1.default.instance.currentScene;
}
exports.getCurrentScene = getCurrentScene;
exports.showAlert = function (title, content) {
    if (my) {
        my.alert({
            title: title || "",
            content: content || ""
        });
    }
    else {
        console.log(title, content);
    }
};
function wait(callback, time) {
    var obj = {};
    FYGE.Tween.get(obj)
        .wait(time)
        .call(callback);
    return obj;
}
exports.wait = wait;
function clearWait(obj) {
    obj && FYGE.Tween.removeTweens(obj);
}
exports.clearWait = clearWait;
function removeTweens(obj, isRecursive) {
    if (isRecursive === void 0) { isRecursive = true; }
    if (!obj)
        return;
    FYGE.Tween.removeTweens(obj);
    if (!isRecursive || !obj.children || !obj.children.length)
        return;
    obj.children.forEach(function (child) {
        removeTweens(child);
    });
}
exports.removeTweens = removeTweens;
function destroyAllCtrls() {
    toastCtrl_1.destroyToast();
    waitingCtrl_1.destroyWaiting();
    panelCtrl_1.default.instance.destroy();
    sceneCtrl_1.default.instance.destroy();
}
exports.destroyAllCtrls = destroyAllCtrls;


/***/ }),

/***/ "./module/ctrls/panelCtrl.ts":
/*!***********************************!*\
  !*** ./module/ctrls/panelCtrl.ts ***!
  \***********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var layers_1 = __webpack_require__(/*! ../views/layers */ "./module/views/layers.ts");
var waitingCtrl_1 = __webpack_require__(/*! ./waitingCtrl */ "./module/ctrls/waitingCtrl.ts");
var toastCtrl_1 = __webpack_require__(/*! ./toastCtrl */ "./module/ctrls/toastCtrl.ts");
var PanelCtrl = (function () {
    function PanelCtrl() {
        this.stacks = [];
    }
    Object.defineProperty(PanelCtrl, "instance", {
        get: function () {
            return PanelCtrl._instance || (PanelCtrl._instance = new PanelCtrl());
        },
        enumerable: false,
        configurable: true
    });
    PanelCtrl.prototype.init = function (parent) {
        this._parent = parent;
        var bg = new FYGE.Shape();
        bg.beginFill(0);
        bg.drawRect(layers_1.layers.stageOffsetX - parent.x, layers_1.layers.stageOffsetY - parent.y, layers_1.layers.stageWidth, layers_1.layers.stageHeight);
        bg.endFill();
        bg.hitTestByPixel = false;
        bg.visible = false;
        this._parent.addChild(bg);
        this._bg = bg;
    };
    PanelCtrl.prototype.closeAll = function () {
        this.stacks.forEach(function (e) { return e.hidePanel(); });
    };
    PanelCtrl.prototype.show = function (cls, data) {
        var _this = this;
        waitingCtrl_1.showWaiting();
        var panel = new cls(data);
        this.add(panel);
        this.stacks.push(panel);
        panel.onLoaded = function () {
            waitingCtrl_1.hideWaiting();
            _this.updateView(false);
            panel.start(data);
            if (panel.visible)
                panel.showAni();
        };
        panel.onLoadError = function () {
            waitingCtrl_1.hideWaiting();
            toastCtrl_1.showToast("资源加载失败");
            panel.removeEventListener('onDestroy', _this.onPanelHide, _this);
            _this.remove(panel);
        };
        return panel;
    };
    PanelCtrl.prototype.updateView = function (showPanelAni) {
        var _this = this;
        if (showPanelAni === void 0) { showPanelAni = true; }
        if (!this.stacks.length) {
            if (this._bg.visible) {
                this.bgAni = "hide";
                FYGE.Tween.removeTweens(this._bg);
                FYGE.Tween.get(this._bg)
                    .to({ alpha: 0 }, 200, FYGE.Ease.cubicOut)
                    .call(function () {
                    _this._bg.visible = false;
                    _this._current = null;
                    _this._parent.visible = false;
                });
            }
        }
        else {
            this._parent.visible = true;
            if (this.bgAni == "hide") {
                this.bgAni = "show";
                FYGE.Tween.removeTweens(this._bg);
                this._bg.alpha = 0.7;
            }
            if (this._bg.visible === false) {
                this._bg.visible = true;
                this._bg.alpha = 0;
                FYGE.Tween.get(this._bg).to({ alpha: 0.7 }, 200, FYGE.Ease.cubicOut);
            }
        }
        for (var i = 0; i < this.stacks.length; i++) {
            if (i < this.stacks.length - 1) {
                this.stacks[i].visible = false;
            }
            else {
                this.stacks[i].visible = true;
                if (showPanelAni)
                    this.stacks[i].showAni();
                this._current = this.stacks[i];
            }
        }
    };
    PanelCtrl.prototype.add = function (panel) {
        this._parent.addChild(panel);
        panel.addEventListener('onDestroy', this.onPanelHide, this);
    };
    PanelCtrl.prototype.remove = function (panel) {
        this._parent.removeChild(panel);
        this.stacks = this.stacks.filter(function (e) { return e != panel; });
    };
    PanelCtrl.prototype.onPanelHide = function (e) {
        var panel = e.target;
        panel.removeEventListener('onDestroy', this.onPanelHide, this);
        this.remove(panel);
        this.updateView();
    };
    PanelCtrl.prototype.closeCurrent = function () {
        if (this._current) {
            this._current.hidePanel();
        }
    };
    PanelCtrl.prototype.destroy = function () {
        PanelCtrl._instance = null;
        this.stacks = null;
        this._current = null;
        this._parent = null;
        FYGE.Tween.removeTweens(this._bg);
        this._bg = null;
    };
    return PanelCtrl;
}());
exports.default = PanelCtrl;


/***/ }),

/***/ "./module/ctrls/sceneCtrl.ts":
/*!***********************************!*\
  !*** ./module/ctrls/sceneCtrl.ts ***!
  \***********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var waitingCtrl_1 = __webpack_require__(/*! ./waitingCtrl */ "./module/ctrls/waitingCtrl.ts");
var toastCtrl_1 = __webpack_require__(/*! ./toastCtrl */ "./module/ctrls/toastCtrl.ts");
var SceneCtrl = (function () {
    function SceneCtrl() {
    }
    Object.defineProperty(SceneCtrl, "instance", {
        get: function () {
            return SceneCtrl._instance || (SceneCtrl._instance = new SceneCtrl());
        },
        enumerable: false,
        configurable: true
    });
    SceneCtrl.prototype.init = function (parent) {
        this._parent = parent;
    };
    SceneCtrl.prototype.change = function (cls, data) {
        var _this = this;
        var scene = new cls(data);
        scene.visible = false;
        waitingCtrl_1.showWaiting();
        var preScene = this._currentScene;
        scene.onLoaded = function () {
            waitingCtrl_1.hideWaiting();
            scene.showAni(function () {
                if (preScene)
                    preScene.destroy();
            });
            scene.visible = true;
            scene.start(data);
        };
        scene.onLoadError = function () {
            waitingCtrl_1.hideWaiting();
            toastCtrl_1.showToast("资源加载失败");
            _this._currentScene = preScene || null;
            _this._parent.removeChild(scene);
        };
        this._currentScene = scene;
        this._parent.addChild(scene);
    };
    Object.defineProperty(SceneCtrl.prototype, "currentScene", {
        get: function () {
            return this._currentScene;
        },
        enumerable: false,
        configurable: true
    });
    SceneCtrl.prototype.destroy = function () {
        SceneCtrl._instance = null;
        this._currentScene = null;
        this._parent = null;
    };
    return SceneCtrl;
}());
exports.default = SceneCtrl;


/***/ }),

/***/ "./module/ctrls/toastCtrl.ts":
/*!***********************************!*\
  !*** ./module/ctrls/toastCtrl.ts ***!
  \***********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.destroyToast = exports.showToast = void 0;
var layers_1 = __webpack_require__(/*! ../views/layers */ "./module/views/layers.ts");
var RES_1 = __webpack_require__(/*! ../RES */ "./module/RES.ts");
var inited = false;
var _toast;
var _parent;
var startY;
var endY;
var initToast = function () {
    if (!inited) {
        inited = true;
        _toast = new Toast();
        _parent = layers_1.layers.toastLayer;
        _toast.alpha = 0;
        _toast.x = layers_1.layers.stageOffsetX - _parent.x + (layers_1.layers.stageWidth - _toast.width) / 2;
        var h = _toast.height;
        var y = layers_1.layers.stageOffsetY - _parent.y;
        startY = y - h;
        endY = y + (layers_1.layers.stageHeight - h) / 2;
    }
};
exports.showToast = function (msg) {
    initToast();
    _toast.show(msg);
    _parent.addChild(_toast);
    FYGE.Tween.removeTweens(_toast);
    FYGE.Tween.get(_toast)
        .set({ y: startY, alpha: 1 })
        .to({ y: endY }, 500, FYGE.Ease.quartOut)
        .wait(800)
        .to({ alpha: 0 }, 300)
        .call(function () {
        _parent.removeChild(_toast);
    });
};
exports.destroyToast = function () {
    if (inited && _toast && !_toast.destroyed) {
        _toast.destroy();
        _toast = null;
        _parent = null;
        inited = false;
    }
};
var Toast = (function (_super) {
    __extends(Toast, _super);
    function Toast() {
        var _this = _super.call(this) || this;
        _this.PADDING = 40;
        _this.mouseChildren = false;
        _this.mouseEnable = false;
        var toastBgTexture = RES_1.RES.getRes("toastBg.png");
        if (toastBgTexture) {
            _this.bg = new FYGE.Sprite(toastBgTexture);
            _this.addChild(_this.bg);
        }
        _this.msg = new FYGE.TextField();
        _this.msg.size = 28;
        _this.msg.fillColor = "0xffffff";
        _this.msg.text = "";
        _this.msg.verticalAlign = FYGE.VERTICAL_ALIGN.MIDDLE;
        _this.msg.textHeight = toastBgTexture ? toastBgTexture.height : 200;
        _this.msg.textAlign = FYGE.TEXT_ALIGN.CENTER;
        _this.addChild(_this.msg);
        return _this;
    }
    Toast.prototype.show = function (msg) {
        this.msg.text = msg;
        this.msg.x = ((this.bg ? this.bg.width : 0) - this.msg.textWidth) / 2;
    };
    Toast.prototype.destroy = function () {
        _super.prototype.destroy.call(this);
        this.msg = null;
        this.bg = null;
    };
    return Toast;
}(FYGE.Container));


/***/ }),

/***/ "./module/ctrls/waitingCtrl.ts":
/*!*************************************!*\
  !*** ./module/ctrls/waitingCtrl.ts ***!
  \*************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.destroyWaiting = exports.hideWaiting = exports.showWaiting = void 0;
var RES_1 = __webpack_require__(/*! ../RES */ "./module/RES.ts");
var layers_1 = __webpack_require__(/*! ../views/layers */ "./module/views/layers.ts");
var inited = false;
var _waiting;
var _parent;
var initWaiting = function () {
    if (!inited) {
        inited = true;
        var waiting = new Waiting();
        _parent = layers_1.layers.topLayer;
        _waiting = waiting;
        var offX = (layers_1.layers.stageWidth - 160) / 2;
        var offY = (layers_1.layers.stageHeight - _waiting.height) / 2;
        _waiting.x = layers_1.layers.stageOffsetX - _parent.x + offX;
        _waiting.y = layers_1.layers.stageOffsetY - _parent.y + offY;
        var bg = new FYGE.Graphics()
            .beginFill(0x000000)
            .drawRect(-offX, -offY, layers_1.layers.stageWidth, layers_1.layers.stageHeight)
            .endFill();
        bg.alpha = 0;
        _waiting.addChildAt(bg, 0);
    }
};
exports.showWaiting = function (msg) {
    initWaiting();
    _waiting.show(msg);
    _parent.addChild(_waiting);
};
exports.hideWaiting = function () {
    _parent.removeChild(_waiting);
};
exports.destroyWaiting = function () {
    if (inited && _waiting && !_waiting.destroyed) {
        _waiting.destroy();
        _waiting = null;
        _parent = null;
        inited = false;
    }
};
var Waiting = (function (_super) {
    __extends(Waiting, _super);
    function Waiting() {
        var _this = _super.call(this) || this;
        var rectBgTexture = RES_1.RES.getRes("waitingBg.png");
        if (rectBgTexture) {
            var rectBg = new FYGE.Sprite(rectBgTexture);
            _this.addChild(rectBg);
            var rotTexture = RES_1.RES.getRes("waitingRot.png");
            var rot_1 = new FYGE.Sprite(rotTexture);
            rot_1.x = (rectBgTexture.width - rotTexture.width) / 2;
            rot_1.y = 47;
            rot_1.anchorX = rotTexture.width / 2;
            rot_1.anchorY = rotTexture.height / 2;
            _this.addChild(rot_1);
            var count_1 = 0;
            rot_1.addEventListener(FYGE.Event.ENTER_FRAME, function () {
                count_1++;
                if (count_1 % 30 == 0)
                    rot_1.rotation += 45;
            }, _this);
        }
        _this.msg = new FYGE.TextField();
        _this.msg.y = 125;
        _this.msg.textWidth = rectBgTexture ? rectBgTexture.width : 200;
        _this.msg.textAlign = FYGE.TEXT_ALIGN.CENTER;
        _this.msg.size = 26;
        _this.msg.fillColor = "#ffffff";
        _this.addChild(_this.msg);
        return _this;
    }
    Waiting.prototype.show = function (msg) {
        if (msg === void 0) { msg = "加载中"; }
        this.msg.text = msg;
    };
    Waiting.prototype.destroy = function () {
        _super.prototype.destroy.call(this);
        this.msg = null;
    };
    return Waiting;
}(FYGE.Container));


/***/ }),

/***/ "./module/tools/GTool.ts":
/*!*******************************!*\
  !*** ./module/tools/GTool.ts ***!
  \*******************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.GTool = void 0;
var GTool = (function () {
    function GTool() {
    }
    GTool.changeURLArg = function (url, arg, arg_val) {
        var pattern = arg + '=([^&]*)';
        var replaceText = arg + '=' + arg_val;
        if (url.match(pattern)) {
            var tmp = '/(' + arg + '=)([^&]*)/gi';
            tmp = url.replace(new RegExp(tmp), replaceText);
            return tmp;
        }
        else {
            if (url.match('[\?]')) {
                return url + '&' + replaceText;
            }
            else {
                return url + '?' + replaceText;
            }
        }
    };
    GTool.readCache = function (key) {
        return my ? my.getStorageSync({ key: key }).data : (localStorage ? localStorage.getItem(key) : window[key]);
    };
    GTool.writeCache = function (key, value) {
        if (value === void 0) { value = 'true'; }
        my ? my.setStorageSync({ key: key, data: value }) : (localStorage ? localStorage.setItem(key, value) : window[key] = value);
    };
    GTool.returnTodayTimes = function (cacheKey) {
        var year1 = this.readCache("year" + cacheKey);
        var month1 = this.readCache("month" + cacheKey);
        var day1 = this.readCache("day" + cacheKey);
        var date = new Date();
        var year2 = date.getFullYear().toString();
        var month2 = date.getMonth().toString();
        var day2 = date.getDate().toString();
        if (this.int(year2) <= this.int(year1)) {
            if (this.int(month2) <= this.int(month1)) {
                if (this.int(day2) <= this.int(day1)) {
                    return this.int(this.readCache(cacheKey));
                }
            }
        }
        var today = "0";
        this.writeCache("year" + cacheKey, year2);
        this.writeCache("month" + cacheKey, month2);
        this.writeCache("day" + cacheKey, day2);
        this.writeCache(cacheKey, today);
        return 0;
    };
    GTool.randomT = function (e, n) {
        return e && "number" == typeof e.length && e.length ? e[Math.floor(Math.random() * e.length)] : ("number" != typeof n && (n = e || 1, e = 0), e + Math.random() * (n - e));
    };
    GTool.removeEle = function (e, arr) {
        var index = arr.indexOf(e);
        if (index >= 0) {
            arr.splice(index, 1);
        }
    };
    GTool.insert = function (num, arr) {
        for (var i = arr.length - 1; i >= 0; i--) {
            if (num > arr[i]) {
                arr.splice(i + 1, 0, num);
                break;
            }
        }
    };
    GTool.getRandomNumber = function (start, end, n) {
        var arr = [];
        for (var i = 0; i < n; i++) {
            var number = Math.floor(Math.random() * (end - start + 1) + start);
            if (arr.indexOf(number) < 0) {
                arr.push(number);
            }
            else {
                i--;
            }
        }
        return arr;
    };
    GTool.disturbNumberArr = function (arr) {
        arr.sort(function () {
            return (0.5 - Math.random());
        });
    };
    GTool.getRandomArrayElements = function (arr, count) {
        var shuffled = arr.slice(0), i = arr.length, min = i - count, temp, index;
        if (min <= 0)
            return shuffled;
        if (count <= 0)
            return [];
        while (i-- > min) {
            index = Math.floor((i + 1) * Math.random());
            temp = shuffled[index];
            shuffled[index] = shuffled[i];
            shuffled[i] = temp;
        }
        return shuffled.slice(min);
    };
    GTool.getRandomArrayElementsEx = function (arr, count) {
        if (arr.length <= count)
            return arr.slice();
        if (count <= 0)
            return [];
        var arrCopy = arr.slice();
        var outArr = [];
        while (count--) {
            var rand = Math.floor(Math.random() * arrCopy.length);
            var ele = arrCopy.splice(rand, 1)[0];
            outArr.push(ele);
        }
        return outArr;
    };
    GTool.int = function (n) {
        return n >> 0;
    };
    ;
    GTool.addSpaceInString = function (str) {
        if (!str.length || str.length == 1)
            return str;
        var txt = "";
        for (var i = 0; i < str.length - 1; i++) {
            txt = txt + str[i] + " ";
        }
        txt = txt + str[str.length - 1];
        return txt;
    };
    GTool.getShiFenMiaoByTimeStamp = function (timeStamp) {
        var hours = Math.floor((timeStamp % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
        var minutes = Math.floor((timeStamp % (1000 * 60 * 60)) / (1000 * 60));
        var seconds = Math.floor((timeStamp % (1000 * 60)) / 1000);
        hours = hours < 10 ? ('0' + hours) : hours;
        minutes = minutes < 10 ? ('0' + minutes) : minutes;
        seconds = seconds < 10 && seconds >= 1 ? ('0' + seconds) : seconds;
        return hours + "小时" + minutes + "分" + seconds + "秒";
    };
    GTool.emojiReg = /[\uD83C|\uD83D|\uD83E][\uDC00-\uDFFF][\u200D|\uFE0F]|[\uD83C|\uD83D|\uD83E][\uDC00-\uDFFF]|[0-9|*|#]\uFE0F\u20E3|[0-9|#]\u20E3|[\u203C-\u3299]\uFE0F\u200D|[\u203C-\u3299]\uFE0F|[\u2122-\u2B55]|\u303D|[\A9|\AE]\u3030|\uA9|\uAE|\u3030/ig;
    return GTool;
}());
exports.GTool = GTool;


/***/ }),

/***/ "./module/tools/GameConst.ts":
/*!***********************************!*\
  !*** ./module/tools/GameConst.ts ***!
  \***********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.wait = exports.arr = void 0;
var GameConst = (function () {
    function GameConst() {
    }
    GameConst.fixString = function (str, number) {
        if (number === void 0) { number = 4; }
        if (!str || str == "") {
            return "";
        }
        var strArr = str.split("");
        if (strArr.length <= number) {
            return str;
        }
        else {
            var _name = "";
            for (var i = 0; i < number; i++) {
                _name += strArr[i];
            }
            _name += "...";
            return _name;
        }
    };
    GameConst.tranNumber = function (num, point) {
        if (point === void 0) { point = 1; }
        if (!num && num != 0) {
            console.log("tranNumber格式错误");
            return;
        }
        var numStr = num.toString();
        if (numStr.length < 5) {
            return numStr;
        }
        else if (numStr.length > 8) {
            var decimal = numStr.substring(numStr.length - 8, numStr.length - 8 + point);
            return parseFloat(Math.floor(num / 100000000) + '.' + decimal) + '亿';
        }
        else if (numStr.length > 4) {
            var decimal = numStr.substring(numStr.length - 4, numStr.length - 4 + point);
            return parseFloat(Math.floor(num / 10000) + '.' + decimal) + '万';
        }
    };
    GameConst.bezier = function (t, p0, p1, p2) {
        return Math.pow(1 - t, 2) * p0 + 2 * (1 - t) * t * p1 + Math.pow(t, 2) * p2;
    };
    GameConst.distance = function (obj1, obj2) {
        var distance = Math.sqrt(Math.pow(obj1.x - obj2.x, 2) + Math.pow(obj1.y - obj2.y, 2));
        return distance;
    };
    GameConst.randomsort = function (a, b) {
        return Math.random() > .5 ? -1 : 1;
    };
    GameConst.randomNum = function (n1, n2) {
        if (arguments.length === 2) {
            return Math.round(n1 + Math.random() * (n2 - n1));
        }
        else if (arguments.length === 1) {
            return Math.round(Math.random() * n1);
        }
        else {
            return Math.round(Math.random() * 255);
        }
    };
    GameConst.isIOS = function () {
        var u = navigator.userAgent;
        var isiOS = !!u.match(/\(i[^;]+;( U;)? CPU.+Mac OS X/);
        return isiOS;
    };
    GameConst.isMPBank = function () {
        var ua = navigator.userAgent;
        if (ua.indexOf('MPBank') > -1)
            return true;
        else
            return false;
    };
    GameConst.getQueryString = function (name) {
        var reg = new RegExp("(^|&)" + name + "=([^&]*)(&|$)", "i");
        var r = window.location.search.substr(1).match(reg);
        if (r != null)
            return unescape(r[2]);
        return null;
    };
    GameConst.collisionDetection = function (obj0, obj1, gap) {
        if (gap === void 0) { gap = 0; }
        var l1 = obj0.x - gap;
        var t1 = obj0.y - gap;
        var r1 = obj0.x + obj0.width + gap;
        var b1 = obj0.y + obj0.height + gap;
        var l2 = obj1.x;
        var t2 = obj1.y;
        var r2 = obj1.x + obj1.width;
        var b2 = obj1.y + obj1.height;
        return !(b1 < t2 || l1 > r2 || t1 > b2 || r1 < l2);
    };
    GameConst.contain = function (obj1, obj2) {
        var condition = obj2.x >= obj1.x && obj2.y >= obj1.y && obj2.x + obj2.width <= obj1.x + obj1.width && obj2.y + obj2.height <= obj1.y + obj1.height;
        return condition;
    };
    GameConst.setCookie = function (name, value, day) {
        if (day !== 0) {
            var expires = day * 24 * 60 * 60 * 1000;
            var date = new Date(+new Date() + expires);
            document.cookie = name + "=" + escape(value) + ";expires=" + date.toUTCString();
        }
        else {
            document.cookie = name + "=" + escape(value);
        }
    };
    ;
    GameConst.getCookie = function (name) {
        var arr;
        var reg = new RegExp("(^| )" + name + "=([^;]*)(;|$)");
        if (arr = document.cookie.match(reg))
            return unescape(arr[2]);
        else
            return null;
    };
    ;
    GameConst.removeCookie = function (name) {
        this.setCookie(name, 1, -1);
    };
    GameConst.isPlayMusic = true;
    GameConst.time = {
        getTodayMark: function () {
            return new Date(new Date().setHours(0, 0, 0, 0)).getTime();
        },
        getEndTime: function (endTime) {
            var startDate = new Date();
            var endDate = new Date(endTime);
            var t = endDate.getTime() - startDate.getTime();
            var d = 0, h = 0, m = 0, s = 0;
            if (t >= 0) {
                d = Math.floor(t / 1000 / 3600 / 24);
                h = Math.floor(t / 1000 / 60 / 60 % 24);
                m = Math.floor(t / 1000 / 60 % 60);
                s = Math.floor(t / 1000 % 60);
            }
            return { d: d, h: h, m: m, s: s };
        },
        now: function () {
            return new Date().getTime();
        }
    };
    GameConst.object = {
        inFn: function (object, val) {
            var array = Object.keys(object);
            var listArray = [];
            var list = new Object();
            for (var item in array) {
                if (array[item].indexOf(val) == -1) {
                }
                else {
                    if (object[array[item]] != "" && object[array[item]] != null && object[array[item]] != 0) {
                        console.log(array[item]);
                        console.log(object[array[item]]);
                        list[array[item]] = object[array[item]];
                    }
                }
            }
            console.log(list);
        }
    };
    return GameConst;
}());
exports.default = GameConst;
var arr = (function () {
    function arr() {
    }
    arr.removeEle = function (e, arr) {
        var index = arr.indexOf(e);
        if (index >= 0) {
            arr.splice(index, 1);
        }
    };
    arr.contain = function (arr, e) {
        var mark = false;
        arr.forEach(function (ee) {
            if (ee == e) {
                mark = true;
            }
        });
        return mark;
    };
    arr.unique = function (arr) {
        if (!arr.length)
            return arr;
        var hash = [];
        hash.push(arr[0]);
        for (var i = 1; i < arr.length; i++) {
            var ele = arr[i];
            if (hash.indexOf(ele) == -1) {
                hash.push(ele);
            }
        }
        return hash;
    };
    arr.shuffle = function (arr) {
        var _a;
        var i = arr.length;
        while (i) {
            var j = Math.floor(Math.random() * i--);
            _a = [arr[i], arr[j]], arr[j] = _a[0], arr[i] = _a[1];
        }
        return arr;
    };
    arr.getOne = function (arr) {
        if (arr && arr.length) {
            return arr.shift();
        }
        return false;
    };
    arr.getDifference = function (arr1, arr2) {
        return arr1.concat(arr2).filter(function (v, i, arr) {
            return arr.indexOf(v) === arr.lastIndexOf(v);
        });
    };
    arr.getEqual = function (arr1, arr2) {
        var newArr = [];
        for (var i = 0; i < arr2.length; i++) {
            for (var j = 0; j < arr1.length; j++) {
                if (arr1[j] === arr2[i]) {
                    newArr.push(arr1[j]);
                }
            }
        }
        return newArr;
    };
    arr.getRandomOne = function (e, n) {
        return e && "number" == typeof e.length && e.length ? e[Math.floor(Math.random() * e.length)] : ("number" != typeof n && (n = e || 1, e = 0), e + Math.random() * (n - e));
    };
    return arr;
}());
exports.arr = arr;
exports.wait = function (time) {
    if (time === void 0) { time = 500; }
    return new Promise(function (resolve) {
        setTimeout(function () {
            resolve();
        }, time);
    });
};


/***/ }),

/***/ "./module/views/Module.ts":
/*!********************************!*\
  !*** ./module/views/Module.ts ***!
  \********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.Module = void 0;
var RES_1 = __webpack_require__(/*! ../RES */ "./module/RES.ts");
var ctrls_1 = __webpack_require__(/*! ../ctrls */ "./module/ctrls/index.ts");
var Module = (function (_super) {
    __extends(Module, _super);
    function Module(data) {
        var _this = _super.call(this) || this;
        _this.data = data;
        _this.init();
        return _this;
    }
    Module.prototype.init = function () {
        var _this = this;
        this.preLoadRes().then(function () {
            if (_this.skinName)
                RES_1.RES.initSkinDisplay(_this, _this.skinName, _this);
            _this.initUi();
            _this.onLoaded && _this.onLoaded();
        }, function () {
            _this.onLoadError && _this.onLoadError();
        });
    };
    Module.prototype.preLoadRes = function () {
        var _this = this;
        return new Promise(function (resolve, reject) {
            if (_this.groupNames && _this.groupNames.length) {
                var arr = [];
                for (var i = 0; i < _this.groupNames.length; i++) {
                    arr.push(RES_1.RES.loadGroup(_this.groupNames[i]));
                }
                Promise.all(arr).then(resolve, reject);
            }
            else {
                resolve();
            }
        });
    };
    Module.prototype.initUi = function () {
    };
    Object.defineProperty(Module.prototype, "groupNames", {
        get: function () { return null; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Module.prototype, "skinName", {
        get: function () { return null; },
        enumerable: false,
        configurable: true
    });
    ;
    Module.prototype.start = function (data) {
        this.initEvents();
    };
    Module.prototype.initEvents = function () {
    };
    Module.prototype.removeEvents = function () {
    };
    Module.prototype.enableMouseEvt = function (enable) {
        this.mouseEnable = enable;
        this.mouseChildren = enable;
    };
    Module.prototype.btnDelay = function (target, delay) {
        if (delay === void 0) { delay = 2000; }
        target.mouseEnable = false;
        target.mouseChildren = false;
        setTimeout(function () {
            target.mouseEnable = true;
            target.mouseChildren = true;
        }, delay);
    };
    Module.prototype.destroy = function () {
        ctrls_1.removeTweens(this);
        this.removeEvents();
        this.dispatchEvent("onDestroy");
        _super.prototype.destroy.call(this);
    };
    return Module;
}(FYGE.Container));
exports.Module = Module;


/***/ }),

/***/ "./module/views/Scene.ts":
/*!*******************************!*\
  !*** ./module/views/Scene.ts ***!
  \*******************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.Scene = void 0;
var Module_1 = __webpack_require__(/*! ./Module */ "./module/views/Module.ts");
var Scene = (function (_super) {
    __extends(Scene, _super);
    function Scene() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Scene.prototype.showAni = function (callback) {
        callback();
    };
    Scene.prototype.updateScene = function () {
    };
    return Scene;
}(Module_1.Module));
exports.Scene = Scene;


/***/ }),

/***/ "./module/views/layers.ts":
/*!********************************!*\
  !*** ./module/views/layers.ts ***!
  \********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.destroyLayers = exports.layers = void 0;
var panelCtrl_1 = __webpack_require__(/*! ../ctrls/panelCtrl */ "./module/ctrls/panelCtrl.ts");
var sceneCtrl_1 = __webpack_require__(/*! ../ctrls/sceneCtrl */ "./module/ctrls/sceneCtrl.ts");
var Layers = (function (_super) {
    __extends(Layers, _super);
    function Layers() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Layers.prototype.init = function (stage) {
        stage.addChild(this);
        var arr = [
            "_bottomLayer",
            "_sceneLayer",
            "_popupLayer",
            "_toastLayer",
            "_topLayer",
            "_shareLayer"
        ];
        for (var i = 0; i < arr.length; i++) {
            this[arr[i]] = new FYGE.Container();
            this.addChild(this[arr[i]]);
        }
        this.sceneLayer.y = this.stageOffsetY;
        this.shareLayer.y = -this.stageOffsetY;
        sceneCtrl_1.default.instance.init(this.sceneLayer);
        panelCtrl_1.default.instance.init(this.popupLayer);
    };
    Object.defineProperty(Layers.prototype, "bottomLayer", {
        get: function () { return this._bottomLayer; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Layers.prototype, "sceneLayer", {
        get: function () { return this._sceneLayer; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Layers.prototype, "popupLayer", {
        get: function () { return this._popupLayer; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Layers.prototype, "toastLayer", {
        get: function () { return this._toastLayer; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Layers.prototype, "topLayer", {
        get: function () { return this._topLayer; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Layers.prototype, "shareLayer", {
        get: function () { return this._shareLayer; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Layers.prototype, "stageHeight", {
        get: function () {
            if (!this.stage)
                return 0;
            return this.stage.viewRect.height;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Layers.prototype, "stageWidth", {
        get: function () {
            if (!this.stage)
                return 0;
            return this.stage.viewRect.width;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Layers.prototype, "stageOffsetX", {
        get: function () {
            if (!this.stage)
                return 0;
            return this.stage.viewRect.x;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Layers.prototype, "stageOffsetY", {
        get: function () {
            if (!this.stage)
                return 0;
            return this.stage.viewRect.y;
        },
        enumerable: false,
        configurable: true
    });
    return Layers;
}(FYGE.Container));
exports.layers = new Layers();
function destroyLayers() {
    exports.layers.removeChildren();
    if (exports.layers.parent)
        exports.layers.parent.removeChild(exports.layers);
}
exports.destroyLayers = destroyLayers;


/***/ }),

/***/ "./resCanvasList.js":
/*!**************************!*\
  !*** ./resCanvasList.js ***!
  \**************************/
/*! exports provided: resCanvasList, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "resCanvasList", function() { return resCanvasList; });
const resCanvasList = {
  '41f1aa61-feba-4f8f-ab73-3dd33a9b24ee': {
    name: 'bg',
    ext: '.png',
    uuid: '41f1aa61-feba-4f8f-ab73-3dd33a9b24ee',
    url: '//yun.duiba.com.cn/spark/assets/d698fcce7d3777356a72345d1ca5aa55c86792e1.png'
  },
  '3225a506-2e78-49a8-8853-1beea73af645': {
    name: '牛',
    ext: '.png',
    uuid: '3225a506-2e78-49a8-8853-1beea73af645',
    url: '//yun.duiba.com.cn/spark/assets/1cc15a3159dabca0b71c6e978044c3043a299948.png'
  },
  '37edf171-b412-46ea-aa1d-92e9e27ce4e9': {
    name: '福袋',
    ext: '.png',
    uuid: '37edf171-b412-46ea-aa1d-92e9e27ce4e9',
    url: '//yun.duiba.com.cn/spark/assets/cfdff45790d3017aae4e662e4610afe67b1a1dde.png'
  },
  '65176053-5c1c-4323-a145-069686739101': {
    name: '组 3',
    ext: '.png',
    uuid: '65176053-5c1c-4323-a145-069686739101',
    url: '//yun.duiba.com.cn/spark/assets/a5f80e6db8a6f4aacc395025f64ca4a2b019be5f.png'
  },
  'b3b64916-14bd-46a1-8610-9fb2acf01c40': {
    name: '元宝 ',
    ext: '.png',
    uuid: 'b3b64916-14bd-46a1-8610-9fb2acf01c40',
    url: '//yun.duiba.com.cn/spark/assets/edda7b415ccd6a64552a212efbb9b74522be3ed5.png'
  },
  '5b10683a-12b9-4862-9b2f-0fc60f920c53': {
    name: '云',
    ext: '.png',
    uuid: '5b10683a-12b9-4862-9b2f-0fc60f920c53',
    url: '//yun.duiba.com.cn/spark/assets/c92d7fe5200d1ed2345b0961225e729248f83abe.png'
  },
  '3f5d636d-7e76-43fa-bdaa-dcb6330b06ff': {
    name: 'bg',
    ext: '.png',
    uuid: '3f5d636d-7e76-43fa-bdaa-dcb6330b06ff',
    url: '//yun.duiba.com.cn/spark/assets/0d4bb3d9aad52d40aab1b7998ae28c476fd92c87.png'
  },
  '9e864c50-55f6-4d93-b884-075930a74d7f': {
    name: '圆角矩形 5',
    ext: '.png',
    uuid: '9e864c50-55f6-4d93-b884-075930a74d7f',
    url: '//yun.duiba.com.cn/spark/assets/5723cfafd09a99b1a7702637a63bbc8e7d1458a3.png'
  },
  '55eb0146-31e9-4996-9b87-0ac5d277a29a': {
    name: 'processBar',
    ext: '.png',
    url: '//yun.duiba.com.cn/spark/assets/4ebedec179eacd9bbf865d11c92cefb61ddbbe15.png',
    uuid: '55eb0146-31e9-4996-9b87-0ac5d277a29a'
  },
  '415bad2b-7ee5-41c9-80ee-99154131118d': {
    name: '黄福袋',
    ext: '.png',
    uuid: '415bad2b-7ee5-41c9-80ee-99154131118d',
    url: '//yun.duiba.com.cn/spark/assets/62cda72432b17c9378fc248c366665ff656c00f8.png'
  },
  '457a5750-3cf1-4813-956e-90e5a4746382': {
    name: '红福袋',
    ext: '.png',
    uuid: '457a5750-3cf1-4813-956e-90e5a4746382',
    url: '//yun.duiba.com.cn/spark/assets/7af7ed13cc3342febf5bab5f5d7763bb42bc84b2.png'
  },
  'c87a85d8-9c8d-4b04-b552-27d5c8d30a02': {
    name: '200好运值',
    ext: '.png',
    url: '//yun.duiba.com.cn/spark/assets/1bf17e690b4a14d6157ebfa719abd86cddd2a52c.png',
    uuid: 'c87a85d8-9c8d-4b04-b552-27d5c8d30a02'
  },
  'c5304981-0885-4e00-86f1-070f99a8c5cc': {
    name: '100好运值',
    ext: '.png',
    url: '//yun.duiba.com.cn/spark/assets/0d60f4ad365050c244021fdf85e6fd7d5473e72e.png',
    uuid: 'c5304981-0885-4e00-86f1-070f99a8c5cc'
  },

  '2c5f50c8-46e1-463c-8831-0a6572177cec': {
    name: '下一步__m',
    ext: '.png',
    uuid: '2c5f50c8-46e1-463c-8831-0a6572177cec',
    url: '//yun.duiba.com.cn/spark/assets/b254704fe6de831e3fed8e462948bb8a08262809.png'
  },
  'f0c92a46-0e0e-48fb-8639-11f7ab0aac8b': {
    name: '拖动小牛左右移动收取好运值',
    ext: '.png',
    uuid: 'f0c92a46-0e0e-48fb-8639-11f7ab0aac8b',
    url: '//yun.duiba.com.cn/spark/assets/1028ffa25bf46391c2029dfebb352d98da46c738.png'
  },
  '4ae63c2e-6797-4038-8f17-30f61a305207': {
    name: '知道了__m',
    ext: '.png',
    uuid: '4ae63c2e-6797-4038-8f17-30f61a305207',
    url: '//yun.duiba.com.cn/spark/assets/6ac5dd0760e39614f7173069a354c23737a9f05c.png'
  },
  '18bb00b3-9596-489c-a8fe-43daeb6bc9ce': {
    name: '在30秒内收集相应数量 好运值即可通关',
    ext: '.png',
    uuid: '18bb00b3-9596-489c-a8fe-43daeb6bc9ce',
    url: '//yun.duiba.com.cn/spark/assets/84f9b854eea9c855a34e5d2ce9a28bf2d9466e78.png'
  },
  'd1cc1596-f532-4a47-af01-ccc666dab184': {
    name: '椭圆 19',
    ext: '.png',
    uuid: 'd1cc1596-f532-4a47-af01-ccc666dab184',
    url: '//yun.duiba.com.cn/spark/assets/da7c4d795656f04393940ce8d6652b1f4b7d06b9.png'
  },
  'f0c8dd60-6c2a-49e7-b9cb-fb7786b87a2b': {
    name: '游戏开始倒计时',
    ext: '.png',
    url: '//yun.duiba.com.cn/spark/assets/01dc04f72ebaa4dc2102780be0783b9acd9c44ee.png',
    uuid: 'f0c8dd60-6c2a-49e7-b9cb-fb7786b87a2b'
  }
};
/* harmony default export */ __webpack_exports__["default"] = (resCanvasList);

/***/ }),

/***/ "./src/Main.ts":
/*!*********************!*\
  !*** ./src/Main.ts ***!
  \*********************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Main = exports.GDispatcher = void 0;
var RES_1 = __webpack_require__(/*! ../module/RES */ "./module/RES.ts");
var layers_1 = __webpack_require__(/*! ../module/views/layers */ "./module/views/layers.ts");
var G_EVENT_1 = __webpack_require__(/*! ./common/G_EVENT */ "./src/common/G_EVENT.ts");
var ctrls_1 = __webpack_require__(/*! ../module/ctrls */ "./module/ctrls/index.ts");
var StartScene_1 = __webpack_require__(/*! ./scenes/StartScene */ "./src/scenes/StartScene.ts");
var TaoBaoNet_1 = __webpack_require__(/*! ./TaoBaoNet */ "./src/TaoBaoNet.ts");
var resCanvasList_1 = __webpack_require__(/*! ../resCanvasList */ "./resCanvasList.js");
exports.GDispatcher = new FYGE.EventDispatcher();
var Main = (function () {
    function Main(canvas) {
        var sysInfo;
        if (my) {
            FYGE.initedByCanvas(canvas);
            sysInfo = my.getSystemInfoSync();
        }
        var type = FYGE.RENDERER_TYPE.WEBGL;
        var can = document.createElement("canvas");
        var ctx = can.getContext("webgl");
        if (!ctx)
            type = FYGE.RENDERER_TYPE.CANVAS;
        var stage = new FYGE.Stage(canvas, 750, 1624, sysInfo && sysInfo.windowWidth || document.body.clientWidth, sysInfo && sysInfo.windowHeight || document.body.clientHeight, type);
        this.stage = stage;
        stage.addEventListener(FYGE.Event.INIT_STAGE, this.onAddToStage, this);
        var self = this;
        loop();
        function loop() {
            if (!self._pause) {
                FYGE.Tween.flush();
                stage.flush();
            }
            self.requestID = FYGE.getRequestAnimationFrame()(loop);
        }
    }
    Main.prototype.onAddToStage = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        layers_1.layers.init(this.stage);
                        console.log("初始化层级完成");
                        return [4, RES_1.RES.loadSparkAssets(resCanvasList_1.default)];
                    case 1:
                        _a.sent();
                        console.log("通用资源加载完成");
                        ctrls_1.changeScene(StartScene_1.StartScene);
                        return [2];
                }
            });
        });
    };
    Main.prototype.run = function () {
        this._pause = false;
        exports.GDispatcher.dispatchEvent(G_EVENT_1.G_EVENT.ON_SHOW);
    };
    Main.prototype.pause = function () {
        exports.GDispatcher.dispatchEvent(G_EVENT_1.G_EVENT.ON_HIDE);
    };
    Main.prototype.addGlobalEvent = function (name, fun, thisObj, once) {
        if (once === void 0) { once = false; }
        if (once) {
            exports.GDispatcher.once(name, fun, thisObj);
        }
        else {
            exports.GDispatcher.addEventListener(name, fun, thisObj);
        }
    };
    Main.prototype.dispatchGlobalEvent = function (name, data) {
        exports.GDispatcher.dispatchEvent(name, data);
    };
    Main.prototype.removeGlobalEvent = function (name, fun, thisObj) {
        exports.GDispatcher.removeEventListener(name, fun, thisObj);
    };
    Main.prototype.destroy = function () {
        FYGE.Tween.removeAllTweens();
        FYGE.getCancelAnimationFrame()(this.requestID);
        layers_1.destroyLayers();
        ctrls_1.destroyAllCtrls();
        this.stage.destroy();
        exports.GDispatcher.removeAllEventListener();
        TaoBaoNet_1.destroyNetData();
    };
    return Main;
}());
exports.Main = Main;


/***/ }),

/***/ "./src/TaoBaoNet.ts":
/*!**************************!*\
  !*** ./src/TaoBaoNet.ts ***!
  \**************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.destroyNetData = exports.getTbData = exports.sendTbNet = exports.TbNetName = void 0;
var ctrls_1 = __webpack_require__(/*! ../module/ctrls */ "./module/ctrls/index.ts");
var Main_1 = __webpack_require__(/*! ./Main */ "./src/Main.ts");
var TbNetName;
(function (TbNetName) {
    TbNetName["trackingReport"] = "squirrelsAdoptRest2c.trackingReport";
    TbNetName["getIndex"] = "babycare.getIndex";
    TbNetName["getActivityBaseInfoById"] = "babycare.getActivityBaseInfoById";
    TbNetName["getGameInfo"] = "babycare.getGameInfo";
    TbNetName["consumerTools"] = "babycare.consumerTools";
    TbNetName["gameOver"] = "babycare.gameOver";
    TbNetName["receiveTaskRewards"] = "babycare.receiveTaskRewards";
    TbNetName["exchange"] = "babycare.exchange";
    TbNetName["getPrizesByLevel"] = "babycare.getPrizesByLevel";
    TbNetName["queryCredits"] = "babycare.queryCredits";
    TbNetName["dojoin"] = "babycare.dojoin";
    TbNetName["completeTask"] = "babycare.completeTask";
    TbNetName["getTaskList"] = "babycare.getTaskList";
    TbNetName["authorize"] = "mine.authorize";
    TbNetName["favorShop"] = "mine.favorShop";
    TbNetName["getUserAddress"] = "mine.getUserAddress";
    TbNetName["getAdoptName"] = "mine.getAdoptName";
    TbNetName["getAppData"] = "mine.getAppData";
    TbNetName["navigateToOutside"] = "mine.navigateToOutside";
    TbNetName["navigateTo"] = "mine.navigateTo";
    TbNetName["navigateBack"] = "mine.navigateBack";
    TbNetName["showSharePanel"] = "mine.showSharePanel";
    TbNetName["openDetail"] = "mine.openDetail";
    TbNetName["reportAnalytics"] = "mine.reportAnalytics";
})(TbNetName = exports.TbNetName || (exports.TbNetName = {}));
var dataRecord = {};
var fc;
function sendTbNet(netName, parameter, callback, hideMsg) {
    if (hideMsg === void 0) { hideMsg = false; }
    return new Promise(function (resolve, reject) {
        var waitObj;
        if (!my) {
            var url = "../../mock/miniTb/" + netName + ".json";
            fetchAsync(url)
                .then(function (data) {
                dataRecord[netName] = data;
                if (!hideMsg && !data.success)
                    ctrls_1.showToast(data.message || "网络异常");
                callback && callback(data.success, data);
                resolve(data);
                console.log("\n%c[ mock ]\n"
                    + ("NAME  : " + netName + " \n")
                    + "STATE : %o \n"
                    + "PARAM : %o \n"
                    + "%cDATA  : %o \n", "" + (data.success ? 'color:green' : 'color:red'), data.success, parameter, "" + (data.success ? 'color:green' : 'color:red'), data);
            }, function () {
            });
            return;
        }
        var fun = function (e) {
            ctrls_1.clearWait(waitObj);
            Main_1.GDispatcher.removeEventListener(netName, fun);
            var d = e.data;
            dataRecord[netName] = d;
            if (!hideMsg && !d.success)
                ctrls_1.showToast(d.message || "网络超时");
            callback && callback(d.success, d);
            resolve(d);
            console.log("\n%c[ request ]\n"
                + ("NAME  : " + netName + " \n")
                + "STATE : %o \n"
                + "PARAM : %o \n"
                + "%cDATA  : %o \n", "" + (d.success ? 'color:green' : 'color:red'), d.success, parameter, "" + (d.success ? 'color:green' : 'color:red'), d);
        };
        Main_1.GDispatcher.addEventListener(netName, fun);
        waitObj = ctrls_1.wait(function () {
            if (netName != TbNetName.favorShop &&
                netName != TbNetName.getUserAddress &&
                netName != TbNetName.authorize &&
                netName != TbNetName.getAdoptName &&
                netName != TbNetName.trackingReport &&
                netName != TbNetName.reportAnalytics) {
                fun({ type: netName, data: { success: false } });
            }
        }, 10000);
        Main_1.GDispatcher.dispatchEvent({ type: "onMessage" }, { netName: netName, parameter: parameter });
    });
}
exports.sendTbNet = sendTbNet;
function getTbData(netName) {
    return dataRecord[netName] || null;
}
exports.getTbData = getTbData;
function destroyNetData() {
    dataRecord = {};
}
exports.destroyNetData = destroyNetData;
function fetchAsync(url) {
    return __awaiter(this, void 0, void 0, function () {
        var response, data;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4, fetch(url)];
                case 1:
                    response = _a.sent();
                    return [4, response.json()];
                case 2:
                    data = _a.sent();
                    return [2, data];
            }
        });
    });
}
var codeMsg = {
    "210001": "服务器异常",
    "210002": "用户不存在",
    "210003": "邀请已达上限",
    "210004": "无法邀请自己",
    "210006": "该活动ID无效",
    "210009": "该活动暂未开始",
    "210010": "该分享ID不存在",
    "210012": "该用户暂未获奖",
    "210013": "领取失败",
    "210015": "该活动已删除",
    "210016": "该活动已经结束",
    "210017": "该奖品已达领取上线",
    "210018": "请先分享好友",
    "210019": "暂有奖品未领取",
    "210020": "暂有奖品未完成",
    "210021": "请先玩一局游戏",
    "210022": "请先选择奖品",
    "210023": "领取失败，库存不足",
    "210024": "请先成为会员",
    "210025": "奖品已经过期",
    "210026": "不能重复助力",
    "210028": "请至我的奖品页重新领取",
};


/***/ }),

/***/ "./src/common/G_EVENT.ts":
/*!*******************************!*\
  !*** ./src/common/G_EVENT.ts ***!
  \*******************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.G_EVENT = void 0;
var G_EVENT;
(function (G_EVENT) {
    G_EVENT["ON_SHOW"] = "onShow";
    G_EVENT["ON_HIDE"] = "onHide";
    G_EVENT["UPDATE_TASK"] = "UpdateTask";
})(G_EVENT = exports.G_EVENT || (exports.G_EVENT = {}));


/***/ }),

/***/ "./src/common/ProgressBarS.ts":
/*!************************************!*\
  !*** ./src/common/ProgressBarS.ts ***!
  \************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.ProgressBarS = void 0;
var ProgressBarS = (function () {
    function ProgressBarS(upImage, txt) {
        this._value = 0;
        this.maxLength = upImage.width;
        this.upImage = upImage;
        this.progressTxt = txt;
        this.oriX = upImage.x;
        var delta = 0;
        if (upImage instanceof FYGE.FrameAni)
            delta = 0.5;
        this.upImage.mask = this.upImage.parent.addChild(new FYGE.Graphics())
            .beginFill(0xf8c862)
            .drawRoundedRect(upImage.x - upImage.width * delta, upImage.y - upImage.height * delta, upImage.width, upImage.height, 111)
            .endFill();
        this.value = 0;
    }
    Object.defineProperty(ProgressBarS.prototype, "value", {
        get: function () {
            return this._value;
        },
        set: function (v) {
            if (v < 0)
                v = 0;
            if (v > 1)
                v = 1;
            this._value = v;
            if (this.progressTxt)
                this.progressTxt.text = ((v * 100) >> 0) + "%";
            this.upImage.x = this.oriX - (1 - this._value) * this.maxLength;
        },
        enumerable: false,
        configurable: true
    });
    return ProgressBarS;
}());
exports.ProgressBarS = ProgressBarS;


/***/ }),

/***/ "./src/scenes/StartScene.ts":
/*!**********************************!*\
  !*** ./src/scenes/StartScene.ts ***!
  \**********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.StartScene = void 0;
var G_EVENT_1 = __webpack_require__(/*! ./../common/G_EVENT */ "./src/common/G_EVENT.ts");
var GTool_1 = __webpack_require__(/*! ./../../module/tools/GTool */ "./module/tools/GTool.ts");
var Main_1 = __webpack_require__(/*! ./../Main */ "./src/Main.ts");
var layers_1 = __webpack_require__(/*! ./../../module/views/layers */ "./module/views/layers.ts");
var GameConst_1 = __webpack_require__(/*! ./../../module/tools/GameConst */ "./module/tools/GameConst.ts");
var Scene_1 = __webpack_require__(/*! ../../module/views/Scene */ "./module/views/Scene.ts");
var RES_1 = __webpack_require__(/*! ../../module/RES */ "./module/RES.ts");
var GameConst_2 = __webpack_require__(/*! ../../module/tools/GameConst */ "./module/tools/GameConst.ts");
var resCanvasList_1 = __webpack_require__(/*! ../../resCanvasList */ "./resCanvasList.js");
var ProgressBarS_1 = __webpack_require__(/*! ../common/ProgressBarS */ "./src/common/ProgressBarS.ts");
var StartScene = (function (_super) {
    __extends(StartScene, _super);
    function StartScene() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.SPEED = 9;
        _this.ADDSPEED = 0.015;
        _this._emojiState = 0;
        _this._score = 0;
        _this._preTimerNum = 3;
        _this._timerNum = 20;
        _this.rains = [];
        _this.hasLuckyBag = false;
        _this.pause = false;
        _this.playMusic = true;
        _this.resConfig = {
            playBg: "41f1aa61-feba-4f8f-ab73-3dd33a9b24ee",
            cow: "3225a506-2e78-49a8-8853-1beea73af645",
            cloud: "5b10683a-12b9-4862-9b2f-0fc60f920c53",
            guideLevel1: "f0c92a46-0e0e-48fb-8639-11f7ab0aac8b",
            guideLevel2: "18bb00b3-9596-489c-a8fe-43daeb6bc9ce",
            guideNextBtn: "2c5f50c8-46e1-463c-8831-0a6572177cec",
            guideEndBtn: "4ae63c2e-6797-4038-8f17-30f61a305207",
            countDownBg: "f0c8dd60-6c2a-49e7-b9cb-fb7786b87a2b",
            scoreProcessBg: "9e864c50-55f6-4d93-b884-075930a74d7f",
            fillProgressBar: "55eb0146-31e9-4996-9b87-0ac5d277a29a",
            redBag: "c5304981-0885-4e00-86f1-070f99a8c5cc",
            goldBag: "c87a85d8-9c8d-4b04-b552-27d5c8d30a02",
            timerBg: "3f5d636d-7e76-43fa-bdaa-dcb6330b06ff",
            luckyBag: "37edf171-b412-46ea-aa1d-92e9e27ce4e9",
            ingot: "b3b64916-14bd-46a1-8610-9fb2acf01c40",
            redPacket: "65176053-5c1c-4323-a145-069686739101",
        };
        _this._guideLevel = 0;
        _this.isGameOver = false;
        _this.count = 0;
        _this.rainLuckyBag = false;
        _this.rainConfig = ['redPacket', 'redPacket', 'luckyBag', 'ingot', 'ingot'];
        return _this;
    }
    StartScene.prototype.res = function (name) {
        var url = resCanvasList_1.default[this.resConfig[name]] ? resCanvasList_1.default[this.resConfig[name]].url : "";
        if (!url) {
            return "";
        }
        return RES_1.RES.getRes(url);
    };
    Object.defineProperty(StartScene.prototype, "guideLevel", {
        get: function () {
            return this._guideLevel;
        },
        set: function (num) {
            this._guideLevel = num;
            this.guideBox.visible = false;
            this.guideLevel1.visible = false;
            this.guideLevel2.visible = false;
            this.guideNextBtn.visible = false;
            this.guideEndBtn.visible = false;
            switch (num + "") {
                case "0":
                    this.guideBox.visible = true;
                    this.guideLevel1.visible = true;
                    this.guideNextBtn.visible = true;
                    break;
                case "1":
                    this.guideBox.visible = true;
                    this.guideLevel2.visible = true;
                    this.guideEndBtn.visible = true;
                    break;
            }
        },
        enumerable: false,
        configurable: true
    });
    StartScene.prototype.initUi = function () {
        this.bg = this.addChild(new FYGE.Sprite(this.res("playBg")));
        this.bg.width = 750;
        this.bg.height = 1624;
        this.bg.y = layers_1.layers.stageHeight - 1624;
        this.cowBox = this.addChild(new FYGE.Container());
        this.cowBox.width = 60;
        this.cowBox.height = 231;
        this.cowBox.y = layers_1.layers.stageHeight - 450;
        this.cowBox.x = (750 - 60) / 2;
        var cow = this.cowBox.addChild(new FYGE.Sprite(this.res('cow')));
        cow.x = -100;
        cow.y = -100;
        var cloud = this.addChild(new FYGE.Sprite(this.res("cloud")));
        cloud.y = 150;
        this.rainBox = this.addChild(new FYGE.Container());
        this.UIBox = this.addChild(new FYGE.Container());
        var redBag = this.UIBox.addChild(new FYGE.Sprite(this.res('redBag')));
        redBag.x = 430;
        redBag.y = 30;
        var goldBag = this.UIBox.addChild(new FYGE.Sprite(this.res('goldBag')));
        goldBag.x = 620;
        goldBag.y = 30;
        this.scoreProgressBox = this.UIBox.addChild(new FYGE.Container());
        var progressBarBg = this.scoreProgressBox.addChild(new FYGE.Sprite(this.res("scoreProcessBg")));
        progressBarBg.x = 240;
        progressBarBg.y = 130;
        var progressBar = this.scoreProgressBox.addChild(new FYGE.Sprite(this.res("fillProgressBar")));
        progressBar.x = 240;
        progressBar.y = 130;
        this.scoreProgressBar = new ProgressBarS_1.ProgressBarS(progressBar);
        this.scoreProgressBar.value = (this.score / 200).toFixed(2);
        var scoreRect = this.scoreProgressBox.addChild(new FYGE.Shape());
        scoreRect.beginFill(0xff0000, 1);
        scoreRect.drawRect(460, 130, 5, 30);
        scoreRect.endFill();
        this.scoreTips = this.UIBox.addChild(new FYGE.TextField());
        this.scoreTips.x = 250;
        this.scoreTips.y = 178;
        this.scoreTips.size = 28;
        this.scoreTips.fillColor = "#ff0000";
        this.scoreTips.text = "\u8FD8\u5DEE             \u70B9\u597D\u8FD0\u503C\u5F97\u7EA2\u798F\u888B";
        this.scoreTxt = new FYGE.TextField();
        this.scoreTxt.x = 307;
        this.scoreTxt.y = 168;
        this.scoreTxt.text = this.score > 200 ? 0 : (this.score > 100 ? 200 - this.score : 100 - this.score) + "";
        this.scoreTxt.fillColor = "#ff0000";
        this.scoreTxt.textAlign = "center";
        this.scoreTxt.size = 55;
        this.scoreTxt.textWidth = 100;
        this.UIBox.addChild(this.scoreTxt);
        var timerBg = this.UIBox.addChild(new FYGE.Sprite(this.res('timerBg')));
        timerBg.x = 30;
        timerBg.y = 30;
        this.redPacketTxt = this.UIBox.addChild(new FYGE.TextField());
        this.redPacketTxt.y = 78;
        this.redPacketTxt.x = 40;
        this.redPacketTxt.textWidth = 200;
        this.redPacketTxt.text = "0";
        this.redPacketTxt.textAlign = FYGE.TEXT_ALIGN.CENTER;
        this.redPacketTxt.fillColor = "#FEEABB";
        this.redPacketTxt.size = 40;
        var timerTips = this.UIBox.addChild(new FYGE.TextField());
        timerTips.size = 30;
        timerTips.fillColor = "#ff0000";
        timerTips.textWidth = 200;
        timerTips.textAlign = "center";
        timerTips.x = 15;
        timerTips.y = 75;
        timerTips.text = "倒计时";
        this.timerTxt = this.UIBox.addChild(new FYGE.TextField());
        this.timerTxt.text = this.timerNum;
        this.timerTxt.size = 60;
        this.timerTxt.fillColor = "#ff0000";
        this.timerTxt.textWidth = 200;
        this.timerTxt.textAlign = "center";
        this.timerTxt.x = 15;
        this.timerTxt.y = 115;
        this.guideBox = this.addChild(new FYGE.Container());
        this.guideLevel1 = this.guideBox.addChild(new FYGE.Sprite(this.res("guideLevel1")));
        this.guideLevel1.y = (layers_1.layers.stageHeight - this.guideLevel1.height);
        this.guideNextBtn = this.guideBox.addChild(new FYGE.Sprite(this.res("guideNextBtn")));
        this.guideNextBtn.x = (750 - this.guideNextBtn.width) / 2;
        this.guideNextBtn.y = layers_1.layers.stageHeight - 610;
        this.guideLevel2 = this.guideBox.addChild(new FYGE.Sprite(this.res("guideLevel2")));
        this.guideLevel2.y = (layers_1.layers.stageHeight - this.guideLevel2.height);
        this.guideEndBtn = this.guideBox.addChild(new FYGE.Sprite(this.res("guideEndBtn")));
        this.guideEndBtn.x = (750 - this.guideEndBtn.width) / 2 + 80;
        this.guideEndBtn.y = layers_1.layers.stageHeight - 760;
        this.guideLevel = 0;
        this.countDownBox = this.addChild(new FYGE.Container());
        this.countDownBox.x = 0;
        this.countDownBox.y = (layers_1.layers.stageHeight - 1624) / 2;
        this.countDownBox.visible = false;
        this.countDownBg = this.countDownBox.addChild(new FYGE.Sprite(this.res("countDownBg")));
        this.countDownTxt = this.countDownBox.addChild(new FYGE.TextField());
        this.countDownTxt.text = this.preTimerNum;
        this.countDownTxt.size = 100;
        this.countDownTxt.fillColor = "#ffffff";
        this.countDownTxt.textWidth = 200;
        this.countDownTxt.textAlign = "center";
        this.countDownTxt.x = 275;
        this.countDownTxt.y = 755;
        this.pause = true;
        if (GTool_1.GTool.readCache("isNQCTGuide")) {
            this.guideLevel = 2;
            this.gamePreCountDown();
        }
    };
    Object.defineProperty(StartScene.prototype, "preTimerNum", {
        get: function () {
            return this._preTimerNum;
        },
        set: function (val) {
            if (this._preTimerNum == val) {
                return;
            }
            this._preTimerNum = val;
            if (this.countDownTxt) {
                this.countDownTxt.text = this._preTimerNum + "";
            }
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(StartScene.prototype, "timerNum", {
        get: function () {
            return this._timerNum;
        },
        set: function (val) {
            if (this._timerNum == val) {
                return;
            }
            this._timerNum = val;
            if (this.timerTxt) {
                this.timerTxt.text = this._timerNum + "";
            }
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(StartScene.prototype, "score", {
        get: function () {
            return this._score;
        },
        set: function (val) {
            if (this._score == val) {
                return;
            }
            this._score = val;
            if (this.scoreTxt) {
                this.scoreTxt.text = this.score >= 200 ? 0 + "" : (this.score >= 100 ? 200 - this.score : 100 - this.score) + "";
            }
            if (this.scoreTips) {
                this.scoreTips.text = this.score >= 100 ? "\u8FD8\u5DEE             \u70B9\u597D\u8FD0\u503C\u5F97\u91D1\u798F\u888B" : "\u8FD8\u5DEE             \u70B9\u597D\u8FD0\u503C\u5F97\u7EA2\u798F\u888B";
            }
            if (this.scoreProgressBar) {
                this.scoreProgressBar.value = this.score > 200 ? 1 : (this.score / 200).toFixed(2);
            }
        },
        enumerable: false,
        configurable: true
    });
    StartScene.prototype.initEvents = function () {
        this.addEventListener(FYGE.MouseEvent.MOUSE_DOWN, this.onDown_bottle, this);
        this.addEventListener(FYGE.MouseEvent.MOUSE_MOVE, this.onMove_bottle, this);
        this.addEventListener(FYGE.MouseEvent.MOUSE_UP, this.onUp_bottle, this);
        this.addEventListener(FYGE.MouseEvent.MOUSE_OUT, this.onUp_bottle, this);
        this.addEventListener(FYGE.MouseEvent.MOUSE_OVER, this.onUp_bottle, this);
        this.guideNextBtn.addEventListener(FYGE.MouseEvent.CLICK, this.nextGuide, this);
        this.guideEndBtn.addEventListener(FYGE.MouseEvent.CLICK, this.endGuide, this);
        this.addEventListener(FYGE.Event.ENTER_FRAME, this.raining, this);
        Main_1.GDispatcher.addEventListener(G_EVENT_1.G_EVENT.ON_SHOW, this.onShow, this);
        Main_1.GDispatcher.addEventListener(G_EVENT_1.G_EVENT.ON_HIDE, this.onHide, this);
    };
    StartScene.prototype.onShow = function () {
    };
    StartScene.prototype.onHide = function () {
    };
    StartScene.prototype.destroy = function () {
        this.onHide();
        Main_1.GDispatcher.removeEventListener(G_EVENT_1.G_EVENT.ON_SHOW, this.onShow, this);
        Main_1.GDispatcher.removeEventListener(G_EVENT_1.G_EVENT.ON_HIDE, this.onHide, this);
        _super.prototype.destroy.call(this);
    };
    StartScene.prototype.gamePreCountDown = function () {
        var _this = this;
        this.pause = true;
        this.countDownBox.visible = true;
        this.preTimerNum = 3;
        clearInterval(this.gamePreTimer);
        this.gamePreTimer = setInterval(function () {
            if (_this.preTimerNum <= 0) {
                clearInterval(_this.gamePreTimer);
                _this.countDownBox.visible = false;
                _this.pause = false;
                _this.gameStart();
            }
            else {
                _this.preTimerNum -= 1;
            }
        }, 1000);
    };
    StartScene.prototype.gameStart = function () {
        var _this = this;
        this.hasLuckyBag = false;
        clearInterval(this.gameTimer);
        this.gameTimer = setInterval(function () {
            if (_this.pause) {
                return;
            }
            _this.timerNum -= 1;
            if (_this.timerNum <= 0) {
                _this.timerNum = 0;
                _this.gameOver();
            }
            if (_this.timerNum < 10) {
                _this.ADDSPEED = 0.045;
                _this.SPEED = 19;
            }
            else if (_this.timerNum < 20) {
                _this.ADDSPEED = 0.035;
                _this.SPEED = 17;
            }
            else if (_this.timerNum < 30) {
                _this.ADDSPEED = 0.025;
                _this.SPEED = 15;
            }
        }, 1000);
        this.pause = false;
    };
    StartScene.prototype.gameOver = function () {
        console.log("游戏结束");
        if (this.isGameOver) {
            return;
        }
        this.pause = true;
        this.isGameOver = true;
        Main_1.GDispatcher.dispatchEvent("GAME_OVER", { score: this.score });
    };
    StartScene.prototype.onDown_bottle = function (e) {
        if (this.pause) {
            return;
        }
        this.startX = e.stageX;
    };
    StartScene.prototype.onMove_bottle = function (e) {
        if (this.pause) {
            return;
        }
        if (!this.startX) {
            return;
        }
        if (e.stageY > layers_1.layers.stageHeight - 400) {
            var offsetX = e.stageX - this.startX;
            this.cowBox.x += offsetX;
            if (this.cowBox.x < 0) {
                this.cowBox.x = 0;
            }
            if (this.cowBox.x > 750 - 103) {
                this.cowBox.x = 750 - 103;
            }
            this.startX = e.stageX;
        }
    };
    StartScene.prototype.onUp_bottle = function (e) {
        if (this.pause) {
            return;
        }
        this.startX = null;
    };
    StartScene.prototype.nextGuide = function () {
        this.guideLevel = 1;
    };
    StartScene.prototype.endGuide = function () {
        GTool_1.GTool.writeCache("isNQCTGuide", "true");
        this.guideLevel = 2;
        this.pause = false;
        this.gamePreCountDown();
    };
    StartScene.prototype.checkGetRain = function () {
        var _this = this;
        var _loop_1 = function (i) {
            var rain = this_1.rains[i];
            var checkBox = { x: this_1.cowBox.x, y: this_1.cowBox.y, width: 130, height: this_1.cowBox.height };
            if (GameConst_2.default.collisionDetection(rain, checkBox)) {
                var addScoreTxt_1 = new FYGE.TextField();
                addScoreTxt_1.size = 36;
                addScoreTxt_1.fillColor = "#ff0000";
                addScoreTxt_1.x = this_1.cowBox.x;
                addScoreTxt_1.y = this_1.cowBox.y;
                switch (rain.spType) {
                    case "luckyBag":
                        this_1.hasLuckyBag = true;
                        this_1.rainLuckyBag = false;
                        this_1.score += 20;
                        addScoreTxt_1.text = "+20";
                        this_1.addChild(addScoreTxt_1);
                        FYGE.Tween.get(addScoreTxt_1)
                            .to({ alpha: 1, y: this_1.cowBox.y - 100 }, 170)
                            .to({ y: this_1.cowBox.y - 200 }, 170)
                            .call(function () {
                            _this.removeChild(addScoreTxt_1);
                        });
                        break;
                    case "ingot":
                        this_1.score += 10;
                        addScoreTxt_1.text = "+10";
                        this_1.addChild(addScoreTxt_1);
                        FYGE.Tween.get(addScoreTxt_1)
                            .to({ alpha: 1, y: this_1.cowBox.y - 100 }, 170)
                            .to({ y: this_1.cowBox.y - 200 }, 170)
                            .call(function () {
                            _this.removeChild(addScoreTxt_1);
                        });
                        break;
                    case "redPacket":
                        this_1.score += 5;
                        addScoreTxt_1.text = "+5";
                        this_1.redPacketTxt.text = "+5";
                        this_1.addChild(addScoreTxt_1);
                        FYGE.Tween.get(addScoreTxt_1)
                            .to({ alpha: 1, y: this_1.cowBox.y - 100 }, 170)
                            .to({ y: this_1.cowBox.y - 200 }, 170)
                            .call(function () {
                            _this.removeChild(addScoreTxt_1);
                        });
                        break;
                }
                this_1.rainBox.removeChild(rain);
                GameConst_1.arr.removeEle(rain, this_1.rains);
            }
        };
        var this_1 = this;
        for (var i = this.rains.length - 1; i >= 0; i--) {
            _loop_1(i);
        }
    };
    StartScene.prototype.raining = function () {
        if (this.pause) {
            return;
        }
        var now = Date.now();
        var delta = this.lastTime ? now - this.lastTime : 16.7;
        this.lastTime = now;
        if (delta > 1000)
            delta = 16.7;
        var scale = delta / 16.7;
        this.checkGetRain();
        this.count++;
        var rainNum = layers_1.layers.stageHeight >= 1334 ? 30 : 20;
        if (this.rains.length < rainNum && this.count % 50 == 0) {
            var rain = this.rainBox.addChild(new FYGE.Sprite(this.res("redPacket")));
            rain.y = -200;
            rain.x = Math.max(10 * Math.random(), 680 * Math.random());
            rain['speed'] = Math.max(this.SPEED * Math.random(), 6);
            var type = GameConst_1.arr.getRandomOne(this.rainConfig);
            if (type == "luckyBag" && (this.hasLuckyBag || this.rainLuckyBag)) {
                type = "redPacket";
            }
            if (type == "luckyBag") {
                this.rainLuckyBag = true;
            }
            switch (type) {
                case "luckyBag":
                    rain.texture = this.res("luckyBag");
                    rain.width = 123;
                    rain.height = 132;
                    rain['spType'] = "luckyBag";
                    break;
                case "ingot":
                    rain.texture = this.res("ingot");
                    rain.width = 135;
                    rain.height = 97;
                    rain['spType'] = "ingot";
                    break;
                case "redPacket":
                    rain.texture = this.res("redPacket");
                    rain.width = 95;
                    rain.height = 131;
                    rain['spType'] = "redPacket";
                    break;
            }
            this.rains.push(rain);
        }
        if (this.rains.length > 0) {
            for (var i = this.rains.length - 1; i >= 0; i--) {
                this.rains[i].y += this.rains[i].speed * scale;
                this.rains[i].speed += this.ADDSPEED;
                this.rains[i].alpha = (this.rains[i].y < layers_1.layers.stageHeight - 300 ? 1 : (layers_1.layers.stageHeight - this.rains[i].y - 100) / 300);
                if (this.rains[i].y > 1800) {
                    if (this.rains[i].type == "luckyBag") {
                        this.rainLuckyBag = false;
                    }
                    this.rainBox.removeChild(this.rains[i]);
                    GameConst_1.arr.removeEle(this.rains[i], this.rains);
                }
            }
        }
    };
    StartScene.prototype.removeEvents = function () {
        this.removeEventListener(FYGE.MouseEvent.MOUSE_DOWN, this.onDown_bottle, this);
        this.removeEventListener(FYGE.MouseEvent.MOUSE_MOVE, this.onMove_bottle, this);
        this.removeEventListener(FYGE.MouseEvent.MOUSE_UP, this.onUp_bottle, this);
        this.removeEventListener(FYGE.MouseEvent.MOUSE_OUT, this.onUp_bottle, this);
        this.removeEventListener(FYGE.MouseEvent.MOUSE_OVER, this.onUp_bottle, this);
        this.guideNextBtn.removeEventListener(FYGE.MouseEvent.CLICK, this.nextGuide, this);
        this.guideEndBtn.removeEventListener(FYGE.MouseEvent.CLICK, this.endGuide, this);
        this.removeEventListener(FYGE.Event.ENTER_FRAME, this.raining, this);
    };
    return StartScene;
}(Scene_1.Scene));
exports.StartScene = StartScene;


/***/ })

/******/ });
});
//# sourceMappingURL=output.js.map