import React, { Component } from "react";
import ReactDOM from "react-dom";
import "./app.less";
import { MOCK_STATUS } from '../sparkrc';
MOCK_STATUS && (require('../mock/index'));
import MD from '../MD';
MD();
//此处为spark-cli动态生成
import PageIndex from "./pages/PageIndex/PageIndex.jsx";
import TWEEN from "./util/Tween";
import Enum from "./util/enum";
import PageCanvas from "./pages/pagecanvas/pagecanvas.jsx";
import ViewCtrl from "./util/viewCtrl";
class App extends Component {

    constructor(props) {
        super(props);
        this.state = this.state || { mainPage: <PageIndex /> };
    }
    componentDidMount() {
        document.body.addEventListener('touchstart', function (e) { console.log(e.target) });
        requestAnimationFrame(animate);
        function animate(time) {
            requestAnimationFrame(animate);
            TWEEN.update(time);
        }
        ViewCtrl.initWaiting();
        if (window.location.host == "beacon.duiba.com.cn" || window.location.host.indexOf("localhost") >= 0) {
            window.CFG = {
                actId: '3743121',
                oaId: '3743121',
                unitName: '金币',
                btnUnitName: '积分',
                doJoin: '/hdtool/doJoin?dpm=1.3.1.0&activityId=3743121',
                quireOrder: '/hdtool/getOrderStatus',
                styleConfig: '/hdtool/getHdtoolConfig',
                getElement: '/hdtool/ajaxElement',
                getPrizeDetail: '/hdtool/prizeDetail',
                ajaxThroughInfo: '/hdtool/ajaxThroughInfo',
                throughSubmit: '/hdtool/throughSubmit',
                gameGetOrder: '/hdtool/getOrderInfo',//游戏获取订单信息接口
                gameSubmit: '/hdtool/gameSubmit',//游戏结果提交接口
                doSubmit: '/hdtool/submit',
                adslotId: '',
                consumerId: '1',
                isNotLoginUser: false,
                uid: '1',
                hdType: 'duiba',
                hdToolId: '44245',
                appType: 'credits',
                subType: 'fishinggold_2',
                directSendCoupon: 'false',
                ajaxAction: '',
                recommendQueue: '/recommend/getRecommend',
                recommendSkin: '/recommend/getRecommendSkin',
                isShowDetail: true,
                preview: false,
                from: '',
                login: '//dbnc.activity-1.m.duiba.com.cn/hdtool/login?dpm=1.3.3.0',
                flowRedirectUrl: '',
                flowRedirectTuiaUrl: '',
                isOpenRecommend: false,
                getCreditsLink: 'http://www.iqiyi.com',
                appId: '1',
                recordUrl: '//dbnc.activity-1.m.duiba.com.cn/crecord/record?dbnewopen&dpm=1.3.2.0',
                shareDesc: '分享分享文案文案',
                entranceDesc: '测试领奖，也可到我的奖品领奖哦！！！',
                isSHowMeat: true,
                needCouponModal: true,  // 给前端用，判断是否需要使用配置的优惠券弹窗
                needRecommendModal: true,  // 给前端用，判断是否需要公用推荐位弹窗
                asyncFiles: [],         // 给前端用，异步加载的文件
                shareAndroidLinkActivity: 'http://www.baidu.com',
                shareIosLinkActivity: 'http://www.iqiyi.com'
            };
        }
        var that = this;
        document.addEventListener("changePage", (e) => { console.log(e.detail.id); that.changePage(e.detail.id) })
    }

    changePage(pageIndex) {
        switch (pageIndex) {
            case Enum.Page.PageCanvas:
                let node = document.getElementById("root");
                if (node) {
                    node.id = "root1"
                }
                this.setState({
                    mainPage: <PageCanvas></PageCanvas>
                })
                break;

            default:
                let node1 = document.getElementById("root1");
                if (node1) {
                    node1.id = "root"
                }
                this.setState({
                    mainPage: <PageIndex></PageIndex>
                })
                break;
        }
    }

    render() {
        return (
            this.state.mainPage
        );
    }
}

ReactDOM.render(<App />, document.getElementById("root"));
