import react, { useRef } from "react";

export function useEdDebounce(fn, delay = 2000) {
    const { current } = useRef({});

    return function call(...args) {
        if (!current.timer) {
            current.timer = setTimeout(() => {
                delete current.timer;
            }, delay)
            fn && fn(...args)
        }
    };
}