'use strict';

import React, { Component } from 'react';
import API from '../../api';
import dataCenter from '../../util/dataCenter.js';
import Enum from '../../util/enum.js';
import util from '../../util/util';
import ViewCtrl from '../../util/viewCtrl.js';
import './output.js';
//import API from '../../api';

class PageCanvas extends Component {
    constructor(props) {
        super(props);
        this.state = this.state || {};
    }
    main;
    componentDidMount() {
        var that = this;
        that.main = this.spark_startEngine();
        window.myMain = that.main;
        // this.main1 = main;
        console.log("jajaja", that.main)
        //main.addEventListener....
        document.addEventListener("GAME_FAILED", that.gameFailed, that);

        document.addEventListener("GAME_CLEARCURLEVEL", that.gameClearCurLevel, that);
        document.addEventListener("GAME_SUCCESS", that.gameClear, that);
        document.addEventListener("nextLevel", that.nextLevel, that);
    }

    componentWillUnmount() {
        var that = this;
        document.removeEventListener("GAME_FAILED", that.gameFailed, that);
        document.removeEventListener("GAME_CLEARCURLEVEL", this.gameClearCurLevel, this);
        document.removeEventListener("GAME_SUCCESS", this.gameClear, this);
        document.removeEventListener("nextLevel", this.nextLevel, this);
    }
    /**
     * 模板自动生成。不参与转换,请勿在此方法内修改逻辑。
     */
    spark_startEngine() {
        if (typeof Main !== 'function') {
            console.error("ERROR::::先发布引擎后，将output.js放入同目录下");
            return null;
        }
        var canvas = document.getElementById("canvas");
        canvas.width = document.body.clientWidth * (window.devicePixelRatio || 1)
        canvas.height = document.body.clientHeight * (window.devicePixelRatio || 1);
        var main = new Main(canvas);
        var mouseEvent = main.stage.onMouseEvent.bind(main.stage);
        canvas.addEventListener("touchstart", mouseEvent, false);
        canvas.addEventListener('touchmove', mouseEvent, false);
        canvas.addEventListener('touchend', mouseEvent, false);
        return main;
    }

    nextLevel() {
        console.log(";llalala", window.myMain)
        window.myMain.dispatchGlobalEvent("nextLevel")
    }

    /**游戏失败 */
    gameFailed() {
        console.log("游戏失败")
        ViewCtrl.showWin(Enum.Com.ComGameFailed);
    }

    /**通过当前关卡 */
    gameClearCurLevel(e) {
        console.log("通过当前关卡啦啦")
        ViewCtrl.showWin(Enum.Com.ComGameClear, { level: e.detail.level });
    }

    /**通过所有关卡 */
    async gameClear() {
        console.log("通过所有关卡")
        ViewCtrl.showWaiting();
        let { submitToken } = dataCenter.getData("gameStartStatus").data;

        function createSgin(ticketId, score, gameData, submitToken) {
            return window['duiba_md5'](ticketId + '' + score + '' + gameData + '' + submitToken);
        }

        var orderId = dataCenter.getData("doJoin").data;
        let gameData = "[]";
        let score = 1;
        let sgin = createSgin(orderId, score, "[]", submitToken);
        let dynamicData = JSON.stringify(`{t2:${new Date().getTime()}}`);

        console.log("oderId:" + orderId)
        var params = {
            orderId,
            score,
            gameData,
            sgin,
            dynamicData
        }
        const gameSubmit = await API.gameSubmit(params);
        if (gameSubmit && gameSubmit.success) {
            const getOrderStatus = await util.getApiStatus(API.getOrderStatus, "code", "0000000000", { orderId: orderId }, 10, 500);
            if (getOrderStatus && getOrderStatus.success) {
                ViewCtrl.hideWaiting();
                let {lottery} = getOrderStatus.data;
                if (lottery) {
                    if (lottery.type != "thanks" && lottery.link) {
                        //中奖
                        ViewCtrl.showWin(Enum.Com.ComGameFinalClear,getOrderStatus.data);
                    } else {
                        //未中奖
                        ViewCtrl.showWin(Enum.Com.ComNoPrize);
                    }
                } else {
                    //未中奖
                    ViewCtrl.showWin(Enum.Com.ComNoPrize);
                }
                // ViewCtrl.showWin(Enum.Com.ComGameFinalClear,getOrderStatus.data);
            } else {
                ViewCtrl.hideWaiting();
                ViewCtrl.showToast();
            }
        } else {
            ViewCtrl.hideWaiting();
            ViewCtrl.showToast();
        }
        // ViewCtrl.showWin(Enum.Com.ComGameFinalClear);
    }

    // /**提交游戏信息并抽奖 */
    // async submitAndGetPrize() {

    // }

    render() {
        return (<div>
            <canvas id="canvas" style={{ width: "100%", height: "100%" }}></canvas>
        </div>)
    }
}
export default PageCanvas;
