import { Tools } from "../Tools";
import { RES } from "../../module/RES";


/**
 * 传入文案和进度条图片
 * 进度条图片位移，固定遮罩
 * 貌似这样就不需要继承显示类了
 */
export class ProgressBarS {
    /**
     * 0到1的进度
     */
    private _value = 0;
    private upImage: FYGE.Sprite;
    private progressTxt: FYGE.TextField;
    private maxLength: number;
    private oriX: number
    constructor(upImage: FYGE.Sprite, txt?: FYGE.TextField) {
        this.maxLength = upImage.width;//最大长度，直接取图片宽度

        this.upImage = upImage;

        this.progressTxt = txt;


        this.oriX = upImage.x;
        var delta = 0
        //传入的也可能是帧动画，这样原点就有问题了
        if (upImage instanceof FYGE.FrameAni) delta = 0.5
        //给图片加个矩形遮罩
        this.upImage.mask = this.upImage.parent.addChild(new FYGE.Graphics())
            .beginFill(0xf8c862)
            .drawRoundedRect(
                upImage.x - upImage.width * delta,
                upImage.y - upImage.height * delta,
                upImage.width,
                upImage.height,
                111
            )
            .endFill();


        this.value = 0;
    }

    get value() {
        return this._value;
    }
    set value(v) {
        if (v < 0) v = 0;
        if (v > 1) v = 1;
        this._value = v;
        if (this.progressTxt) this.progressTxt.text = ((v * 100) >> 0) + "%";
        this.upImage.x = this.oriX - (1 - this._value) * this.maxLength
    }
}
