/**
 * jsonp模拟，不考虑回调
 * @param url 
 * @param params 
 */
export function jsonp(url, params) {
    const src = url + '?' + getParams(params);
    const scriptEl = document.createElement('script');
    scriptEl.src = src;
    scriptEl.onload = function () {
        document.body.removeChild(scriptEl);
    };
    scriptEl.onerror = function () {
        document.body.removeChild(scriptEl);
    };
    document.body.appendChild(scriptEl);
}

function getParams(data) {
    if (!data) return ""; //没有就返回空字符
    var arr = [];
    for (var param in data) {
        arr.push(encodeURIComponent(param) + '=' + encodeURIComponent(data[param]));
    }
    //不缓存
    arr.push('_=' + Date.now());
    return arr.join('&');
}

export function sendLogBuji(area, isExposure) {
    var appId = window["CFG"].appId;
    var oaId = window["CFG"].oaId;
    var dpm = appId + '.' + 267 + '.' + area + '.' + 1;
    var dcm = 273 + '.' + oaId + '.' + 0 + '.' + 0;
    let params = {
        dpm,
        dcm,
        appId,
        consumerId: window["CFG"].consumerId,
        domain: '//embedlog.duiba.com.cn'
    };
    if (isExposure) {
        jsonp('//embedlog.duiba.com.cn/exposure/standard', params);
    } else {
        jsonp('/log/click', params);
    }
}