'use strict';

import React, { Component } from 'react';
import API from '../../api';
import dataCenter from '../../util/dataCenter.js';
import Enum from '../../util/enum.js';
import util from '../../util/util';
import ViewCtrl from '../../util/viewCtrl.js';
import './output.js';
//import API from '../../api';

class PageCanvas extends Component {
    constructor(props) {
        super(props);
        this.state = this.state || {};
    }
    main;
    componentDidMount() {
        var that = this;
        that.main = this.spark_startEngine();
        window.myMain = that.main;
        // this.main1 = main;
        console.log("jajaja", that.main)
        //main.addEventListener....

        this.main.addGlobalEvent("GAME_OVER", this.gameOver, this)
        // document.addEventListener("GAME_OVER", that.gameOver, that);
    }

    componentWillUnmount() {
        var that = this;

        this.main.removeGlobalEvent("GAME_OVER", this.gameOver, this)
    }
    /**
     * 模板自动生成。不参与转换,请勿在此方法内修改逻辑。
     */
    spark_startEngine() {
        if (typeof Main !== 'function') {
            console.error("ERROR::::先发布引擎后，将output.js放入同目录下");
            return null;
        }
        var canvas = document.getElementById("canvas");
        canvas.width = document.body.clientWidth * (window.devicePixelRatio || 1)
        canvas.height = document.body.clientHeight * (window.devicePixelRatio || 1);
        var main = new Main(canvas);
        var mouseEvent = main.stage.onMouseEvent.bind(main.stage);
        canvas.addEventListener("touchstart", mouseEvent, false);
        canvas.addEventListener('touchmove', mouseEvent, false);
        canvas.addEventListener('touchend', mouseEvent, false);
        return main;
    }

    gameOver(params) {
        console.log(params)
        if (params.data.score < 100) {
            this.gameFailed()
        } else if (params.data.score >= 100) {
            this.gameSuccess({ score: params.data.score })
        }
    }

    /**游戏失败 */
    gameFailed() {
        console.log("游戏失败")
        ViewCtrl.showWin(Enum.Com.ComGameFailed);
    }

    gameSuccess(params) {
        console.log("游戏成功")
        ViewCtrl.showWin(Enum.Com.ComGameSuccess, { score: params.score }, () => {
            this.gameSubmit(params.score)
        });
    }

    /**发送分数 */
    async gameSubmit(score) {
        console.log("发送分数")
        ViewCtrl.showWaiting();
        let { submitToken } = dataCenter.getData("gameStartStatus").data;

        function createSgin(ticketId, score, gameData, submitToken) {
            return window['duiba_md5'](ticketId + '' + score + '' + gameData + '' + submitToken);
        }

        var orderId = dataCenter.getData("doJoin").data;
        let gameData = "[]";
        let sgin = createSgin(orderId, score, "[]", submitToken);
        let dynamicData = JSON.stringify(`{t2:${new Date().getTime()}}`);

        console.log("oderId:" + orderId)
        var params = {
            orderId,
            score,
            gameData,
            sgin,
            dynamicData
        }
        const gameSubmit = await API.gameSubmit(params);
        if (gameSubmit && gameSubmit.success) {
            const getOrderStatus = await util.getApiStatus(API.getOrderStatus, "code", "0000000000", { orderId: orderId }, 10, 500);
            if (getOrderStatus && getOrderStatus.success) {
                ViewCtrl.hideWaiting();
                let { lottery } = getOrderStatus.data;
                if (lottery) {
                    if (lottery.type != "thanks" && lottery.imgUrl) {
                        //中奖
                        ViewCtrl.showWin(Enum.Com.ComGameFinalClear, getOrderStatus.data);
                    } else {
                        //未中奖
                        ViewCtrl.showWin(Enum.Com.ComNoPrize);
                    }
                } else {
                    //未中奖
                    ViewCtrl.showWin(Enum.Com.ComNoPrize);
                }
                // ViewCtrl.showWin(Enum.Com.ComGameFinalClear, getOrderStatus.data);
            } else {
                ViewCtrl.hideWaiting();
                ViewCtrl.showToast();
                ViewCtrl.changePage();
            }
        } else {
            ViewCtrl.hideWaiting();
            ViewCtrl.changePage();
            ViewCtrl.showToast();
        }
        // ViewCtrl.showWin(Enum.Com.ComGameFinalClear);
    }

    // /**提交游戏信息并抽奖 */
    // async submitAndGetPrize() {

    // }

    render() {
        return (<div>
            <canvas id="canvas" style={{ width: "100%", height: "100%" }}></canvas>
        </div>)
    }
}
export default PageCanvas;
