'use strict';

import React, { Component } from 'react';
import resList from '../../resconfig/resList';
import API from '../../api';

import './PageIndex.less';
import ViewCtrl from '../../util/viewCtrl';
import Enum from '../../util/enum';
import config from '../../util/config';
import { GTool } from '../../util/GTool';
import dataCenter from '../../util/dataCenter';
import util from '../../util/util';
import { sendLogBuji } from '../../util/net';


// import {Route} from 'react-router-dom'


class PageIndex extends Component {
    constructor(props) {
        super(props);
        this.state = this.state ||
        {
            resList: resList,
            myGameCountText: "",
        };
    }

    //组件加载
    componentDidMount() {
        var that = this;
        document.getElementById("root").addEventListener("touchmove", (e) => {
            e.preventDefault()
        })
        that.initData();

        sendLogBuji(1, true)
        sendLogBuji(2, true)
        sendLogBuji(3, true)
    }

    //初始化数据
    async initData() {
        var that = this;
        const ajaxElement = await API.ajaxElement({
            duibaId: window.CFG.hdToolId,
            activityId: window.CFG.actId
        });
        if (ajaxElement && ajaxElement.success) {
            dataCenter.setData("ajaxElement", ajaxElement.data);
            that.judgeCount(ajaxElement.data.element);
        } else {
            ViewCtrl.showToast(ajaxElement.desc || config.netError);
        }
    }

    //判断游戏次数是否充足
    judgeCount(data) {
        var that = this;
        var text;
        const { freeLimit, status, needCreditsLong } = data;
        // if (freeLimit > 0) {
        //     text = "剩余免费挑战次数：" + freeLimit;
        // } else if (status == 4 || status == 3) {
        //     text = "挑战次数已达上限";
        // } else {
        //     text = needCreditsLong + window.CFG.unitName + "/每次";
        // }

        if (status == 4) {
            text = "今日无剩余次数"
        } else if (status == 3) {
            text = "无剩余次数"
        } else if (freeLimit >= 1) {
            text = "剩余免费挑战次数：" + freeLimit
        } else {
            if (status == 1) {
                text = "积分不足"
            } else {
                text = needCreditsLong + window.CFG.unitName + "/每次";
            }
        }
        that.setState({
            myGameCountText: text
        })
    }

    //打开规则弹窗
    openRule() {

        sendLogBuji(2, false)

        // ViewCtrl.showWin(Enum.Com.ComGameFailed);
        ViewCtrl.showWin(Enum.Com.ComRule);

        // ViewCtrl.showWin(Enum.Com.ComnoChance);
        // ViewCtrl.showWin(Enum.Com.Comdeng_lu);
        // ViewCtrl.showWin(Enum.Com.ComNoPrize);
    }

    //跳转到奖品页
    openRecordPage() {

        sendLogBuji(3, false)
        window.location.href = getRecordUrl('00');

        function getRecordUrl(type, ids) {
            let recordUrl;
            let oaId;

            oaId = window.CFG.oaId;
            recordUrl = window.CFG.recordUrl;

            if (!ids) {
                ids = [oaId];
            }

            let i = 0;
            const len = ids.length;
            for (i; i < len; i++) {
                if (window.location.href.indexOf("?") == -1) {
                    recordUrl += '?origins=' + ids[i] + type;
                } else {
                    recordUrl += '&origins=' + ids[i] + type;
                }

            }
            return recordUrl;
        }
    }

    //判断是否可以开始游戏
    judgeCanStartGame() {
        var that = this;
        util.clickDelay("startBtn")
        sendLogBuji(1, false)
        if (CFG.isNotLoginUser == true) {
            ViewCtrl.showWin(Enum.Com.Comdeng_lu);
            return;
        }
        const { freeLimit, status } = dataCenter.getData("ajaxElement").element

        if (freeLimit >= 1) {
            that.startGame();
        } else if (status == 4 || status == 3) {
            ViewCtrl.showWin(Enum.Com.ComnoChance);
            // ViewCtrl.showToast("参与次数已达上限")
        } else {
            that.startGame();
            // ViewCtrl.showWin(Enum.Com.ComspendPoints, {}, that.startGame.bind(that));
            return;
        }

    }

    //参与游戏进行轮询检查
    async startGame() {
        var that = this;
        console.log("Wefew")
        ViewCtrl.showWaiting();

        const token = await util.getDuibaToken();
        if (token) {
            that.enterGame(token);
        } else {
            ViewCtrl.hideWaiting();
            ViewCtrl.showToast();
        }
    }

    pollingCount;
    //准备进入游戏
    async enterGame(token) {
        var that = this;
        let params = {
            activityId: window.CFG.actId,
            token: token,
            activityType: 'hdtool',
            consumerId: window.CFG.consumerId
        }

        const doJoin = await API.doJoin(params)
        if (!doJoin || !doJoin.success) {
            ViewCtrl.hideWaiting();
            that.startGameFailed(doJoin.code);
            return;
        }
        dataCenter.setData("doJoin", doJoin)
        // 开始轮询
        that.pollingCount = 0;
        await that.getNewGameStartStatus(doJoin.data);
        //   await this.pollingOrderStatusForThrough({
        //     orderId: doJoin.data
        //   })
    }

    // //新游戏状态查询
    // async getNewGameStartStatus(data) {
    //     var that = this;
    //     return new Promise(async resolve => {
    //         that.pollingCount++;
    //         var gameStartStatus = await API.gameStartStatus({ orderId: data });
    //         if (gameStartStatus.success) {
    //             if (gameStartStatus.code == "0000000000" && that.pollingCount <= 10) {
    //                 //轮询成功
    //                 ViewCtrl.hideWaiting();
    //                 ViewCtrl.changePage(Enum.Page.PageCanvas);
    //             } else if (that.pollingCount > 10) {
    //                 ViewCtrl.hideWaiting();
    //                 that.startGameFailed(gameStartStatus.code);
    //                 resolve();
    //             } else {
    //                 setTimeout(async () => {
    //                     await that.getNewGameStartStatus(data);
    //                 }, 500);
    //             }

    //         } else {
    //             ViewCtrl.hideWaiting();
    //             that.startGameFailed(gameStartStatus.code);
    //             resolve();
    //         }
    //     })
    // }

    //新游戏状态查询
    async getNewGameStartStatus(data) {
        var that = this;
        var gameStartStatus = await util.getApiStatus(API.gameStartStatus, "code", "0000000000", { orderId: data });
        var a = 1;
        console.log(gameStartStatus)
        if (gameStartStatus && gameStartStatus.success) {
            //轮询成功
            dataCenter.setData("gameStartStatus", gameStartStatus)
            ViewCtrl.hideWaiting();
            ViewCtrl.changePage(Enum.Page.PageCanvas);
        } else {
            console.log("轮询失败啦")
            ViewCtrl.hideWaiting();
            that.startGameFailed();
        }
    }

    startGameFailed(code) {
        if (code == "E100201001" || code == "E100201002") {
            ViewCtrl.showWin(Enum.Com.Comdeng_lu);
        }
        else if (code == "E100201007") {
            // ViewCtrl.showWin(Enum.Com.ComgetPoints);
            ViewCtrl.showToast((CFG.unitName ? CFG.unitName : "积分") + "不足，去赚积分吧~")
        } else if (code == "E100202007" || code == "E100202008" || code == "E100202009" || code == "E100202010") {
            ViewCtrl.showWin(Enum.Com.ComnoChance);
            // ViewCtrl.showToast("参与次数已达上限")
        } else {
            ViewCtrl.showToast("活动异常火爆，请稍后再试")
        }
    }

    render() {
        return (
            <div className="zhu_jie_mian ">
                {/* <img className="bg " src={this.state.resList['abb461e6-9eab-4333-88ed-3aea3977591d'].url} /> */}
                <img className="ruleBtn" src={this.state.resList['a917146f-76a3-412e-9168-6d2e19320ffc'].url} onClick={this.openRule.bind(this)} />
                <img className="recordBtn " src={this.state.resList['c158698f-450a-463e-9529-154a144a8369'].url} onClick={this.openRecordPage.bind(this)} />
                <img className="startBtn " src={this.state.resList['87bb7cc6-970b-4b5a-8495-c05668d12dc6'].url} onClick={this.judgeCanStartGame.bind(this)} />
                <span className="remainTimes ">{this.state.myGameCountText}</span>
            </div>
        );
    }
}

export default PageIndex;
