'use strict';

import React, { Component } from 'react';
import resList from '../../resconfig/resList';

import './ComgetPoints.less';

class ComgetPoints extends Component {
  constructor(props) {
    super(props);
    this.state = this.state || { resList: resList, isGo: false };
  }

  componentDidMount() {
    let { getCreditsLink } = window.CFG
    if (getCreditsLink && getCreditsLink !== "") {
      this.setState({
        isGo: true
      })
    } else {
      this.setState({
        isGo: false
      })
    }
  }

  getPointsLink() {
    console.log('去跳转赚取积分链接');
    let { getCreditsLink } = window.CFG
    if (getCreditsLink && getCreditsLink !== "") {
      window.location.href = getCreditsLink;
    } else {
      this.props.closeWin();
    }
  }

  render() {
    return (
      <div className="zhuan_ji_fen15 zoom">
        <img className="dan_chuang_bei_jing19" src={this.state.resList['9dee8a6c-0fef-4d77-9b78-bfdea719b5a8'].url} />
        <img className="guan_bi_an_niu18" src={this.state.resList['28caebe0-9290-49fe-9661-ccc2c9885520'].url} onClick={this.props.closeWin} />
        <img className="zhuan_ji_fen17" style={this.state.isGo ? { display: "" } : { display: "none" }} src={this.state.resList['5ac11cd5-4893-42d9-aa30-0002de09d02d'].url} onClick={this.getPointsLink.bind(this)} />
        <label className="hen_bao_qian16">很抱歉</label>
        <label className="ji_fen_bu_zulabel">积分不足，去赚积分吧~</label>
      </div>
    );
  }
}
export default ComgetPoints;
