
import { RES } from "../RES";
import { removeTweens } from "../ctrls";

/**
 *
 */
export class Module extends FYGE.Container {
    protected data: any;
    constructor(data?: any) {
        super();
        this.data = data;
        this.init();
    }
    /**
     * 初始化资源和皮肤
     */
    private init() {
        this.preLoadRes().then(
            () => {
                //添加皮肤配置
                if (this.skinName) RES.initSkinDisplay(this, this.skinName, this);
                this.initUi();
                this.onLoaded && this.onLoaded();
            },
            () => {
                this.onLoadError && this.onLoadError();
            }
        );
    }
    /**
     * 提前加载的资源
     */
    protected preLoadRes() {
        return new Promise((resolve, reject) => {
            if (this.groupNames && this.groupNames.length) {
                var arr: Promise<any>[] = [];
                for (var i = 0; i < this.groupNames.length; i++) {
                    arr.push(RES.loadGroup(this.groupNames[i]))
                }
                Promise.all(arr).then(resolve, reject)
            } else {
                resolve()
            }
        })
    }

    /**
     * 初始化ui
     * 子类修改
     */
    protected initUi() {

    }

    /**
     * 资源加载完成后执行，用于场景及弹框控制
     */
    onLoaded: () => void

    /**
     * 资源加载失败时执行，用于场景及弹框控制
     */
    onLoadError: () => void;


    /**
     * 可以有多个组
     */
    get groupNames(): string[] { return null }
    /**
     * 皮肤名字
     */
    get skinName(): string { return null };

    /**
     * 在构造函数后执行
     */
    start(data?: any) {
        this.initEvents();
    }

    /**
     * 添加事件
     */
    initEvents(): void {

    }

    /**
     * 移除事件
     */
    removeEvents(): void {

    }

    /**
     * 鼠标事件
     * @param enable
     */
    protected enableMouseEvt(enable: boolean): void {
        this.mouseEnable = enable;
        this.mouseChildren = enable;
    }

    /**
     * 延时防连点
     * @param target
     * @param {number} delay
     */
    protected btnDelay(target, delay = 2000) {
        target.mouseEnable = false;
        target.mouseChildren = false;
        setTimeout(() => {
            target.mouseEnable = true;
            target.mouseChildren = true;
        }, delay);
    }


    public destroy(): void {
        //以防有些地方用了showAni
        removeTweens(this);

        // this.data = null;//看情况吧，有时候hidePanel后用了data，注意，还是先去掉吧
        //移除事件
        this.removeEvents();
        //派发销毁事件，主要用于场景及弹框控制
        this.dispatchEvent("onDestroy");
        super.destroy();
    }
}
