import apiCfg from './apicfg';
import request from './request';

const apiList = {
  ...apiCfg
}


const API = generateAPI(apiList);
export default API;

function getRequestParams(value) {
  if (typeof value === 'string') {
    return {
      uri: value,
      method: 'get'
    }
  } else if (typeof value === 'object') {
    const {
      uri,
      method = 'post'
    } = value;
    return {
      uri,
      method
    }
  } else {
    console.error('getRequestParams: 传参有误');
  }
};


function generateAPI(apiList) {
  const api = {};
  Object.entries(apiList).forEach(([key, value]) => {
    const {
      method,
      uri
    } = getRequestParams(value);
    api[key] = params => request[method](uri, method === 'post' ? params : {
      params
    });
  });
  return api;

}