import { Module } from "../../../module/views/Module";
import HealthyUi from "./HealthyUi";

export default class Healthy {
    private _maxHealth: number;
    private _curHealth: number;
    private _ui: HealthyUi;

    set ui(_ui: HealthyUi) {
        this._ui = _ui;
    }

    get ui() { return this._ui; }

    set maxHealth(value: number) {
        this._maxHealth = value;
    }

    get maxHealth() { return this._maxHealth; }

    set curHealth(value: number) {
        this._curHealth = value <= 0 ? 0 : value;
        if (this.ui) {
            this.ui.updateUi(this.curHealth, this.maxHealth);
        }
    }

    get curHealth() {
        return this._curHealth;
    }

    reduceHealth(value) {
        this.curHealth -= value;
    }
}