import { changeScene } from "../../module/ctrls";
import { RES } from "../../module/RES";
import { Scene } from "../../module/views/Scene";
import { ProgressBarS } from "../common/ProgressBarS";
import { getWebData, sendWebNet, WebNetName } from "../WebNet";
import ActGameScene from "./Scene/ActGameScene";
import { StartScene } from "./StartScene";

export class LoadingScene extends Scene {
    get groupNames() {
        return ["loading"]
    }

    progressBar: ProgressBarS;

    initUi() {
        //适配
        // this.y = -layers.stageOffsetY
        //背景
        // this.addChild(FYGE.Sprite.fromUrl("xxxxxxxx"))
        //     .position.set(0, 0)

        //进度条底图
        this.addChild(FYGE.Sprite.fromFrame("进度条底.png"))
            .position.set((750 - 577) / 2, 1288 - 24)
        //进度条
        var pro = this.addChild(FYGE.Sprite.fromFrame("进度条.png"));
        pro.position.set((750 - 577) / 2, 1288 - 24)
        //进度条托管
        this.progressBar = new ProgressBarS(pro);
    }

    async start() {
        super.start()

        //监听进度条事件
        this.addEventListener(FYGE.Event.PROGRESS, this.progressEvent, this)
        //首次进度一点
        this.dispatchEvent(FYGE.Event.PROGRESS, 0.2)

        //做些啥?

        this.dispatchEvent(FYGE.Event.PROGRESS, 0.3);
        // 接口示例
        var res1 = await sendWebNet(WebNetName.index)
        //做些啥?
        if (!res1.success) return
        //判断是否结束
        //
        this.dispatchEvent(FYGE.Event.PROGRESS, 0.5);
        //资源1
        await RES.loadGroup("StartScene")
        this.dispatchEvent(FYGE.Event.PROGRESS, 0.6);
        //资源2
        // await RES.loadGroup("mapCrabEffect")
        this.dispatchEvent(FYGE.Event.PROGRESS, 0.7);
        //资源
        // await RES
        this.dispatchEvent(FYGE.Event.PROGRESS, 0.8);
        //随便异步示例
        await new Promise((r) => {
            setTimeout(r, 100)
        })
        this.dispatchEvent(FYGE.Event.PROGRESS, 1);
    }

    progressEvent(e: FYGE.Event) {
        let pro = e.data;
        FYGE.Tween.removeTweens(this.progressBar)
        FYGE.Tween.get(this.progressBar)
            .to({ value: pro }, 2000)
            .call(() => {
                if (pro >= 1) {
                    this.removeEventListener(FYGE.Event.PROGRESS, this.progressEvent, this);
                    changeScene(ActGameScene,getWebData(WebNetName.index).data)
                }
            })
    }
}



