import { RES } from "../../../module/RES";
import { layers } from "../../../module/views/layers";
import { Module } from "../../../module/views/Module";
import { GDispatcher } from "../../Main";
import { Anim, ANIM_TYPE } from "../Anim/Anim";
import Character from "../Character/Character";
import CollsionComp from "../Component/CollsionComp";
import { AttackData } from "../Data/AttackData";
import { COLLSION_GROUP, COLLSION_TYPE } from "../Enum/CollsionGroup";
import { PLAYER_ACT_STATE } from "../Enum/PlayerEnum";
import CollsionMgr from "../Manager/CollsionMgr";
import { Msg } from "../Message/Msg";
import { AttackStruct } from "../Struct/AttackStruct";
import { CollsionComStuct } from "../Struct/CollsionComStruct";

export default class Player extends Character {
    private keyBuffer: {};
    private playerState: PLAYER_ACT_STATE;
    private attackCnt: number;
    private curAttack: AttackStruct;
    private canAttack: boolean;
    private playerCollsion: CollsionComp;


    initUi() {
        console.log("??")
        super.initUi();
        this.initProp();
        this.initEvents();
    }

    /**初始化玩家数据 */
    initProp() {
        this.keyBuffer = [];
        this.speed = new FYGE.Point(0, 0);
        this.speedVector = new FYGE.Point(0, 0);
        this.runSpeed = 8;
        this.speed.x = this.runSpeed;
        this.attackCnt = 0;
        this.canAttack = true;
        let collsionData: CollsionComStuct = {
            x: 0,
            y: 95,
            w: 140,
            h: 150,
            collsionGroup: COLLSION_GROUP.PLAYER,
            collsionType: COLLSION_TYPE.RECT,
            owner: this
        }
        this.playerCollsion = CollsionMgr.instance.setCollsionComp(collsionData)
        this.switchPlayerState(PLAYER_ACT_STATE.IDLE);
    }

    initEvents() {
        console.log('aaa')
        super.initEvents();
        this.addEventListener(FYGE.Event.ENTER_FRAME, this.updatePlayer, this);
        GDispatcher.addEventListener(Msg.onKeyA, this.moveStart, this);
        GDispatcher.addEventListener(Msg.onKeyD, this.moveStart, this);
        GDispatcher.addEventListener(Msg.onKeyUpD, this.moveEnd, this);
        GDispatcher.addEventListener(Msg.onKeyUpA, this.moveEnd, this);
        GDispatcher.addEventListener(Msg.onKeyJ, this.attack, this);
    }

    removeEvents() {
        super.removeEvents();
        this.removeEventListener(FYGE.Event.ENTER_FRAME, this.updatePlayer, this);
        GDispatcher.removeEventListener(Msg.onKeyA, this.moveStart, this);
        GDispatcher.removeEventListener(Msg.onKeyD, this.moveStart, this);
        GDispatcher.removeEventListener(Msg.onKeyUpD, this.moveEnd, this);
        GDispatcher.removeEventListener(Msg.onKeyUpA, this.moveEnd, this);
        GDispatcher.removeEventListener(Msg.onKeyJ, this.attack, this);
    }


    updatePlayer() {
        this.runState();
    }

    /**跑步状态更新方法 */
    runState() {
        let offsetX = this.speedVector.x * this.speed.x;
        if ((this.x + offsetX) >= layers.stageWidth || (this.x + offsetX) <= 0) return;
        this.x += offsetX;
    }

    /**将按键添加到缓冲中 */
    setKeyToBuffer(key) {
        if (!this.keyBuffer[key]) {
            this.keyBuffer[key] = 1;
        }
    }

    /**将按键从缓冲中移除 */
    removeKeyFromBuffer(key) {
        if (this.keyBuffer[key]) {
            this.keyBuffer[key] = null;
        }
    }

    /**按键左右 */
    moveStart(e) {
        console.log('move', e)
        this.setKeyToBuffer(e.type);
        if (e.type == Msg.onKeyA) {
            if (this.playerState != PLAYER_ACT_STATE.IDLE) return;
            this.switchPlayerState(PLAYER_ACT_STATE.RUN_L)
        } else if (e.type == Msg.onKeyD) {
            if (this.playerState != PLAYER_ACT_STATE.IDLE) return;
            this.switchPlayerState(PLAYER_ACT_STATE.RUN_R)
        }
    }

    /**移动停止 */
    moveEnd(e) {
        console.log("停止？-->", e)
        if (e.type == Msg.onKeyUpA) {
            this.removeKeyFromBuffer(Msg.onKeyA);
            if (this.speed.x == 0) return;
            this.switchPlayerState(PLAYER_ACT_STATE.IDLE)
        } else if (e.type == Msg.onKeyUpD) {
            this.removeKeyFromBuffer(Msg.onKeyD);
            if (this.speed.x == 0) return;
            this.switchPlayerState(PLAYER_ACT_STATE.IDLE)
        }
    }

    attack(e) {
        if (!this.canAttack) return;
        this.switchAttack();
    }

    /**切换玩家状态 */
    switchPlayerState(state: PLAYER_ACT_STATE) {
        switch (state) {
            case PLAYER_ACT_STATE.IDLE:
                this.switchIdle();
                break;
            case PLAYER_ACT_STATE.RUN_L:
                this.switchRun(state);
                break;
            case PLAYER_ACT_STATE.RUN_R:
                this.switchRun(state);
                break;
            case PLAYER_ACT_STATE.ATTACK:
                this.switchAttack();
                break;
        }
    }

    setAnim(type:string, loop = 0, call?) {
        if (this.curAnim && this.curAnim.parent) this.removeChild(this.curAnim);
        //@ts-ignore
        let anim: FYGE.FrameAni = Anim.animPool[type];
        console.log('uauuaa-->', type,anim,Anim.animPool)
        this.addChild(anim);
        anim.play(loop, call);
        anim.frameRate = 60;
        anim.scale.set(1.5, 1.5)
        this.curAnim = anim;
    }

    attackEnd() {
        if (this.keyBuffer[Msg.onKeyA] && !this.keyBuffer[Msg.onKeyD]) {
            this.switchPlayerState(PLAYER_ACT_STATE.RUN_L);
        } else if (!this.keyBuffer[Msg.onKeyA] && this.keyBuffer[Msg.onKeyD]) {
            this.switchPlayerState(PLAYER_ACT_STATE.RUN_R);
        }
        else {
            this.switchPlayerState(PLAYER_ACT_STATE.IDLE);
        }
    }

    /**攻击 */
    switchAttack() {
        this.stopMove();
        if (this.curAttack && this.curAttack.nextAttackStructKey) {
            this.curAttack = AttackData[this.curAttack.nextAttackStructKey];
        } else {
            this.curAttack = AttackData.firstAttack;
        }
        this.canAttack = false;
        setTimeout(()=>{
            this.setAttackCollsionComp();
        },500)
        
        this.setAnim(this.curAttack.AttackAnim, 1, () => {
            this.canAttack = true;
            this.attackEnd();
        });
        this.playerState = PLAYER_ACT_STATE.ATTACK;
    }

    /**设置攻击碰撞盒 */
    setAttackCollsionComp(){
        let collsionData: CollsionComStuct = {
            x: 80,
            y: 95,
            w: 120,
            h: 150,
            collsionGroup: COLLSION_GROUP.WEAPON,
            collsionType: COLLSION_TYPE.RECT,
            owner: this
        }
        this.playerCollsion = CollsionMgr.instance.setWeaponCollsionComp(this.curAttack.damage,400,collsionData)
    }

    /**停止移动 */
    stopMove() {
        this.speedVector.x = this.speedVector.y = 0;
        this.speed.x = 0;
    }
    /**切换成静止状态 */
    switchIdle() {
        console.log("切换成静止状态")
        this.speedVector.x = this.speedVector.y = 0;
        this.speed.x = 0;
        this.setAnim(ANIM_TYPE.PLAYER_IDLE);
        this.playerState = PLAYER_ACT_STATE.IDLE;
    }

    /**切换成跑步状态 */
    switchRun(state) {
        console.log('切换跑步状态')
        this.speed.x = this.runSpeed;
        if (state == PLAYER_ACT_STATE.RUN_L) {
            this.speedVector.x = -1;
            this.scaleX = -1;
        } else if (state == PLAYER_ACT_STATE.RUN_R) {
            this.speedVector.x = 1;
            this.scaleX = 1;
        }
        this.setAnim(ANIM_TYPE.PLAYER_RUN);
        this.playerState = state;
    }
}