import { RES } from "../../../module/RES";
import { AnimData } from "../Data/AnimData";

export class Anim {
    static animPool = {};
    static initAnimFromKey(imgKey, AnimResEndTitle, AnimResStartIndex, length, key): FYGE.FrameAni {
        if (this.animPool[key]) return this.animPool[key]
        let animArr = [];
        for (let i = 0; i < length; i++) {
            // console.log(`${imgKey}${AnimResStartIndex + i + 1}.png`, RES.getRes(`${imgKey}${AnimResStartIndex + i + 1}${AnimResEndTitle}.png`))
            animArr.push(RES.getRes(`${imgKey}${AnimResStartIndex + i + 1}${AnimResEndTitle}.png`))
        }
        this.animPool[key] = new FYGE.FrameAni(animArr);
        console.log('aaa-->',key)
        return this.animPool[key]
    }

    /**根据动画数据加载帧动画并存入动画池 */
    static initAnimPool() {
        for (let i = 0; i < AnimData.length; i++) {
            let itm = AnimData[i];
            Anim.initAnimFromKey(itm.AnimTitle, itm.AnimResEndTitle, itm.AnimResStartIndex, itm.AnimFrameCnt, itm.AnimKey)
        }
    }
}

export enum ANIM_TYPE {
    PLAYER_RUN = 'PLAYER_RUN',
    PLAYER_ATTACK = 'PLAYER_ATTACK',
    PLAYER_SECOND_ATTACK = 'PLAYER_SECOND_ATTACK',
    PLAYER_IDLE = 'PLAYER_IDLE',
    ENEMY_IDLE = 'ENEMY_IDLE'
}