

import { Panel } from "../views/Panel";
import { layers } from "../views/layers";
import { showWaiting, hideWaiting } from "./waitingCtrl";
import { showToast } from "./toastCtrl";

export default class PanelCtrl {
    /**
     * 父级容器
     */
    private _parent: FYGE.Container;
    /**
     * 半透明黑色背景
     */
    private _bg: FYGE.Shape;//FYGE.Graphics;
    /**
     * 所有的弹框
     */
    private stacks: Panel[] = [];

    private static _instance: PanelCtrl;
    static get instance() {
        return PanelCtrl._instance || (PanelCtrl._instance = new PanelCtrl())
    }

    init(parent: FYGE.Container) {
        this._parent = parent;
        let bg = new FYGE.Shape();//Graphics()//Shape();
        bg.beginFill(0);
        bg.drawRect(//引用适配
            layers.stageOffsetX - parent.x,
            layers.stageOffsetY - parent.y,
            layers.stageWidth,
            layers.stageHeight
        );
        bg.endFill();
        bg.hitTestByPixel = false;
        bg.visible = false;
        this._parent.addChild(bg);
        this._bg = bg;
    }

    /**
     * 关闭所有弹框
     */
    closeAll() {
        this.stacks.forEach(e => e.hidePanel());
    }

    show<T extends Panel>(cls: any, data?: any): T {
        showWaiting()
        const panel: T = new cls(data);
        this.add(panel);
        this.stacks.push(panel);
        panel.onLoaded = () => {
            hideWaiting();
            this.updateView(false);//这里更新不显示动画先，自行判断是否显示
            //start只执行一边
            panel.start(data);
            //如果是最后一个才显示动画
            if (panel.visible) panel.showAni();
        }
        //资源加载失败时
        panel.onLoadError = () => {
            hideWaiting();
            showToast("资源加载失败")
            panel.removeEventListener('onDestroy', this.onPanelHide, this);
            this.remove(panel);
        }
        return panel;
    }
    private bgAni: "hide" | "show";
    private updateView(showPanelAni: boolean = true) {
        //没有弹框的时候
        if (!this.stacks.length) {
            // this._bg.visible = false;
            // this._current = null;
            // this._parent.visible = false;
            if (this._bg.visible) {//原先背景存在时，待测试
                this.bgAni = "hide"
                FYGE.Tween.removeTweens(this._bg);
                FYGE.Tween.get(this._bg)
                    .to({ alpha: 0 }, 200, FYGE.Ease.cubicOut)
                    .call(() => {
                        this._bg.visible = false;
                        this._current = null;
                        this._parent.visible = false;
                    })
            }
        } else {
            //显示弹框层
            this._parent.visible = true;
            if (this.bgAni == "hide") {//如果正在执行蒙层消失动画，
                this.bgAni = "show"
                FYGE.Tween.removeTweens(this._bg);
                this._bg.alpha = 0.7;
            }
            //如果首次出现弹框，加个动画
            if (this._bg.visible === false) {
                this._bg.visible = true;
                this._bg.alpha = 0;
                FYGE.Tween.get(this._bg).to({ alpha: 0.7 }, 200, FYGE.Ease.cubicOut)
            }
        }

        for (let i = 0; i < this.stacks.length; i++) {
            if (i < this.stacks.length - 1) {
                this.stacks[i].visible = false;
            } else {
                this.stacks[i].visible = true;
                if (showPanelAni) this.stacks[i].showAni();
                this._current = this.stacks[i];
            }
        }
    }

    /**
     * 添加进父级并添加事件
     * @param panel 
     */
    private add(panel: Panel) {
        this._parent.addChild(panel);
        panel.addEventListener('onDestroy', this.onPanelHide, this);
    }

    /**
     * 移除
     * @param panel 
     */
    private remove(panel: Panel) {
        this._parent.removeChild(panel);
        this.stacks = this.stacks.filter(e => e != panel);
    }

    /**
     * 弹框移除时执行
     * @param e 
     */
    private onPanelHide(e: FYGE.Event) {
        const panel = e.target as Panel;
        panel.removeEventListener('onDestroy', this.onPanelHide, this);
        this.remove(panel);
        this.updateView();
    }

    //当前弹框
    private _current: Panel;

    /**
     * 关闭当前弹框
     */
    closeCurrent() {
        if (this._current) {
            this._current.hidePanel();
            // this._current.removeEventListener('onDestroy', this.onPanelHide, this);
            // this.remove(this._current);
            // this.updateView();
        }
    }

    destroy() {
        PanelCtrl._instance = null;
        this.stacks = null;
        this._current = null;
        this._parent = null;
        FYGE.Tween.removeTweens(this._bg);
        this._bg = null;
    }
}