import Character from "./Character";

export default class CharacterMoveComp extends FYGE.EventDispatcher {
    constructor(character: Character) {
        super();
        this.character = character;
        this.initDefaultProp();
        this.addEventListener(FYGE.Event.ENTER_FRAME, this.updateMoveComp, this);
    }

    private _character: Character;
    private _speed: FYGE.Point;
    private _speedVector: FYGE.Point;

    get character() { return this._character };
    set character(_character) { this._character = _character };
    get speed() { return this._speed };
    set speed(_speed) { this._speed = _speed };
    get speedVector() { return this._speedVector };
    set speedVector(_speedVector) { this._speedVector = _speedVector };

    private initDefaultProp() {
        this.speed = new FYGE.Point(0, 0);
        this.speedVector = new FYGE.Point(0, 0);
    }

    private updateMoveComp() {
        if (!this.character) return;
        this.character.x += this.speed.x * this.speedVector.x;
        this.character.y += this.speed.y * this.speedVector.y;
    }
}