

import { layers, destroyLayers } from "../module/views/layers";
import { RES } from "../module/RES";
import { changeScene, showWaiting, destroyAllCtrls, showPanel, hideWaiting } from "../module/ctrls";

import { ResJson } from "./ResJson";
import { SkinJson } from "./SkinJson";
import { LoadingScene } from "./template/LoadingScene";
import { destroyWebNetData } from "./WebNet";
import ActGameScene from "./template/Scene/ActGameScene";


/**
 * 全局事件，为了和小程序交互
 * 有可能多处页面用到，所以单开
 */
export const GDispatcher = new FYGE.EventDispatcher();

export class Main {
    //主舞台
    stage: FYGE.Stage;
    private requestID;
    constructor(canvas: HTMLCanvasElement) {
        //建舞台
        var stage = new FYGE.Stage(
            canvas,
            1920,//设计宽度，按设计搞给的就行
            1080,//设计高度
            document.body.clientWidth,
            document.body.clientHeight,
            FYGE.RENDERER_TYPE.CANVAS,
            false  //视窗居中裁切
        );
        this.stage = stage;
        //stage初始化
        stage.addEventListener(FYGE.Event.INIT_STAGE, this.onAddToStage, this);
        //循环
        var self = this;
        loop();
        function loop() {
            FYGE.Tween.flush()
            stage.flush();
            self.requestID = window.requestAnimationFrame(loop);
        }
    }

    private async onAddToStage() {
        //初始化层级
        layers.init(this.stage);
        console.log("初始化层级完成")
        //初始化资源配置
        RES.loadConfig(ResJson);
        console.log("初始化资源配置完成")
        //皮肤配置加载
        RES.loadSkinConfig(SkinJson);
        console.log("初始化皮肤配置完成")
        //加载通用资源
        // await RES.loadGroup("common");
        // await RES.loadGroup("anim");
        // await RES.loadGroup("role1");
        // await RES.loadGroup('role1move');
        // await RES.loadGroup("map");
        await RES.loadAllGroup();
        console.log("通用资源加载完成")
        //h5环境时，隐藏加载中
        if (FYGE.getEnv() == "web" && document.getElementById("__loading__")) document.getElementById("__loading__").style.display = "none";
        //显示场景
        console.log("??")
        changeScene(ActGameScene)
    }

    /**
     * 添加全局事件，用于小程序的交互调用
     * 一直很犹豫要不要放在main的实例里，还是和Main同级导出，还有上面的pause，run，下面的事件等
     * @param name
     * @param fun
     * @param thisObj
     */
    addGlobalEvent(name: string, fun: Function, thisObj?: any, once: boolean = false) {
        if (once) {
            GDispatcher.once(name, fun, thisObj)
        } else {
            GDispatcher.addEventListener(name, fun, thisObj)
        }
    }
    /**
     * 派发全局事件，用于小程序的交互调用
     * @param name 可以是事件名，也可以是事件
     * @param data
     */
    dispatchGlobalEvent(name: string | any, data?: any) {
        GDispatcher.dispatchEvent(name, data)
    }
    /**
     * 移除全局事件，用于小程序交互调用
     * @param name
     * @param fun
     * @param thisObj
     */
    removeGlobalEvent(name: string, fun: Function, thisObj?: any) {
        GDispatcher.removeEventListener(name, fun, thisObj)
    }


    //在小程序页面卸载时调用onUnload，多次销毁后会有问题，再检查
    destroy() {
        //Tween都移除，注意吧，可能原先的也被移除,,对于多page时注意，会把其他页面的也去掉
        FYGE.Tween.removeAllTweens()
        //停掉计时器
        window.cancelAnimationFrame(this.requestID);
        //层级销毁
        destroyLayers()
        //销毁控制器
        destroyAllCtrls();
        //舞台销毁
        this.stage.destroy();
        //全局事件置空
        GDispatcher.removeAllEventListener();
        //网络数据记录清空
        destroyWebNetData();
    }
}

