import { getTexture, clickLog, showLog } from "./utils";
import {props, injectProps} from "../props";
import { getlogItem } from "./getlogItem";

export default class QAText extends engine.Sprite{
    bg:engine.Image[] = [];
    bgTexture:engine.Texture[] = [];
    titelLabel:engine.Label;
    QLabel:engine.Label[] = [];
    ALabel:engine.Label[] = [];
    ActLabel:engine.Label;
    QlabelGroup:engine.Sprite;
    AlabelGroup:engine.Sprite;
    ActlabelGroup:engine.Sprite;
    QText:string[];         //问题文本组
    AText:string[];         //回答文本组
    ActText:string[];       //互动文本组
    bigBgOrigin:engine.Point;
    smallBgOrigin:engine.Point;
    returnBtn:engine.Image; //回答文本组的返回按钮
    closeBtn:engine.Image;  //关闭按钮

    actLabelTimer;

    constructor(){
        super();
        this.addEventListener(engine.Event.ADDED_TO_STAGE,this.setup,this)
        this.init();
    }

    init(){
        var that = this; 
        that.bigBgOrigin = new engine.Point();
        that.smallBgOrigin = new engine.Point();
        that.QText = props.QTextStrArr.split(',');
        that.QText.unshift('你想问哪些问题？')
        console.log(props.QTextStrArr.split(','));

        that.AText = props.ATextStrArr.split(',')
        console.log(props.ATextStrArr.split(','));
        
        that.ActText = props.ACTTextStrArr.split(',');
        console.log(props.ACTTextStrArr.split(','));
    }

    setup(){
        var that = this;
        that.removeEventListener(engine.Event.ADDED_TO_STAGE,that.setup,that);
        that.hideText();
        that.setGroup();
        that.setQLabel();
        that.setALabel();
        that.setActLabel();
        that.setEvent();
    }

    setEvent(){
        
    }

    /**设置各个文本组 */
    setGroup(){
        var that  = this;
        //问题文本组
        that.QlabelGroup = new engine.Sprite();
        // that.QlabelGroup.addChild(that.bg[0]);
        that.addChild(that.QlabelGroup);
        that.QlabelGroup.visible = false;
        
        //答案文本组
        that.AlabelGroup = new engine.Sprite();
        // that.AlabelGroup.addChild(that.bg[1]);
        that.addChild(that.AlabelGroup)
        that.AlabelGroup.visible = false;

        //互动文本组
        that.ActlabelGroup = new engine.Sprite();
        // that.ActlabelGroup.addChild(that.bg[1]);
        that.addChild(that.ActlabelGroup);
        that.ActlabelGroup.visible = false;
        
        for(let i=0;i<3;i++){
            let bg = new engine.Image();
            if(i<2){
                bg.texture = getTexture("21d8b7ca-6ed3-44e5-ada0-f0433f471ac9");        //大气泡
                if(i==0){
                    that.QlabelGroup.addChild(bg);
                }else{
                    that.AlabelGroup.addChild(bg);
                }
            }
            else{
                bg.texture = getTexture("9e4d1860-4762-4ac1-bc44-b3dd8fb307a6");        //小气泡
                that.ActlabelGroup.addChild(bg);
            }
            that.bg.push(bg);
        }

        that.closeBtn = new engine.Image(getTexture("76f2c800-2174-4a90-ad6d-5853e95eb144"));
        that.addChild(that.closeBtn);
        that.closeBtn.mouseEnabled = true;
        that.closeBtn.addEventListener(engine.MouseEvent.CLICK,that.hideText,that);
    }

    /**设置问题文本组 */
    setQLabel(){
        var that = this;
        for(let i=0;i<that.QText.length;i++){
            let label = new engine.Label();
            label.text = that.QText[i];
            label.x = 40;
            label.width = that.bg[0].width-50;
            
            if(i<=1){
                label.y = 30+i*60
            }else{
                
                label.y = 30+60+(i-1)*50;
            }
            if(i==0){
                label.size = 34;
                // label.bold = true;
            }else{
                let img = new engine.Image(getTexture("8546dcf7-a6e8-4ba2-89f7-b929118e473a"))
                img.y = label.y;
                img.x = that.getBigBgSize().w-img.width-36;
                that.QlabelGroup.addChild(img);
                img.mouseEnabled = true;
                img.addEventListener(engine.MouseEvent.CLICK,that.showALabelGroup,that);
                label.fillColor = "#d36800";
                label.size = 24;
            }
            label.name = 'Q_'+i;
            // console.log("regeg",label.hasEventListener(engine.MouseEvent.CLICK))
            if(i>0){
                label.mouseEnabled = true;
                label.addEventListener(engine.MouseEvent.CLICK,that.showALabelGroup,that);
            }
            that.QlabelGroup.addChild(label);
            that.QLabel.push(label);
            
        }
    }

    /**设置答案文本 */
    setALabel(){
        var that = this;
        for(let i=0;i<2;i++){
            let label = new engine.Label();
            label.x = 40;
            label.y = 100+i*60;
            label.size = 24;
            label.width = that.bg[0].width-50;
            that.AlabelGroup.addChild(label);
            that.ALabel.push(label);
        }
        
        that.returnBtn = new engine.Image(getTexture('2a555da9-dc05-4046-a5fb-551f0c2692fa'));
        that.AlabelGroup.addChild(that.returnBtn);
        // that.returnBtn.x = that.bg[1].width - that.returnBtn.width*2;
        // that.returnBtn.y = that.bg[1].height - that.returnBtn.height-30;
        that.returnBtn.x = 18;
        that.returnBtn.y = 20;

        that.returnBtn.mouseEnabled = true;
        that.returnBtn.addEventListener(engine.MouseEvent.CLICK,that.showQLabelGroup,that);
    }

    /**设置互动文本 */
    setActLabel(){
        var that = this;
        that.ActLabel = new engine.Label();
        that.ActlabelGroup.addChild(that.ActLabel);
        that.ActLabel.x = 0;
        that.ActLabel.y = that.getSmallBgSize().h*0.5-24;
        that.ActLabel.width = that.getSmallBgSize().w;
        // that.ActLabel.height = that.getSmallBgSize().h;
        that.ActLabel.textAlign = engine.TEXT_ALIGN.CENTER;
        // that.ActLabel.verticalAlign = engine.VERTICAL_ALIGN.MIDDLE;
        that.ActLabel.size = 24;
    }

    /**展示问题组 */
    showQLabelGroup(e:engine.MouseEvent){
        var that = this;
        if(e&&e.target == that.returnBtn){
            if(props.type == 0){
                clickLog(getlogItem(30));
            }else if(props.type == 1){
                clickLog(getlogItem(80));
            }
        }
        that.x = that.bigBgOrigin.x;
        that.y = that.bigBgOrigin.y;
        that.closeBtn.x = that.bg[0].width - that.closeBtn.width-20;
        that.closeBtn.y = 20;
        that.AlabelGroup.visible = false;
        that.ActlabelGroup.visible = false;
        that.QlabelGroup.visible = true;
        that.showText();
    }

    /**展示答案组 */
    showALabelGroup(e:engine.MouseEvent){
        console.log("展示答案"+e.target.name);
        var that = this;
        that.x = that.bigBgOrigin.x;
        that.y = that.bigBgOrigin.y;
        that.closeBtn.x = that.bg[0].width - that.closeBtn.width-20;
        that.closeBtn.y = 20;

        let label = e.target;
        let str = label.name.split('_');
        if(str&&str.length>0)
            var index = str[1];
        that.ALabel[0].text = that.QText[index];
        that.ALabel[1].text = that.AText[index-1];
        that.QlabelGroup.visible = false;
        that.ActlabelGroup.visible = false;
        that.AlabelGroup.visible = true;
        that.showText();
        if(props.type == 0){
            showLog(getlogItem(30));
        }else if(props.type == 1){
            showLog(getlogItem(80));
        }
    }

    /**展示互动组 */
    showActLabelGroup(type){
        // injectProps(event.data);
        let index = type;
        var that = this;
        that.x = that.smallBgOrigin.x;
        that.y = that.smallBgOrigin.y;
        that.closeBtn.x = that.bg[2].width - that.closeBtn.width-10;
        that.closeBtn.y = 20;
        that.ActLabel.text = that.ActText[index];
        that.QlabelGroup.visible = false;
        that.AlabelGroup.visible = false;
        that.ActlabelGroup.visible = true;
        that.showText();
        if(!that.actLabelTimer){
            that.actLabelTimer = setTimeout(() => {
                that.ActlabelGroup.visible = false;
                that.hideText();
                clearTimeout(that.actLabelTimer)
            }, 3000);
        }else{
            clearTimeout(that.actLabelTimer);
            that.actLabelTimer = setTimeout(() => {
                that.hideText();
                that.ActlabelGroup.visible = false;
            }, 3000);
        }
        
        
    }

    setBigBgPositon(x:number,y:number){
        this.bigBgOrigin.x = x;
        this.bigBgOrigin.y = y;
    }

    setSmallBgPositon(x:number,y:number){
        this.smallBgOrigin.x = x;
        this.smallBgOrigin.y = y;
    }

    getBigBgSize(){
        return {w:this.bg[0].width,h:this.bg[0].height}
    }

    getSmallBgSize(){
        return {w:this.bg[2].width,h:this.bg[2].height}
    }

    showText(){
        this.visible = true;
    }

    hideText(){
        if(this.actLabelTimer){
            clearTimeout(this.actLabelTimer);
        }
        engine.globalEvent.dispatchEvent("hideRect");
        this.visible = false;
    }
}