
export class GTime {
    /**
     * 获取当前时间戳
     * @returns {number}
     */
    public static getTimestamp(): number {
        return new Date().getTime();
    }

    /**
     * 转化时分秒
     * @param time 
     */
    public static GetTimeHMS(time:number):string{
        let t;

        let h = Math.floor(time / 3600);
        let hstr = h > 9 ? h : '0' + h;

        let m = Math.floor((time % 3600) / 60);
        let mstr = m > 9 ? m : '0' + m;

        let s = Math.floor(time % 60);
        let sstr = s > 9 ? s : '0' + s;

        t = hstr + ':' + mstr + ':' + sstr;

        return t;
    }

    /**
     * 转化分秒
     * @param time 
     */
    public static GetTimeMS(time:number):string{
        let t;

        let m = Math.floor((time % 3600) / 60);
        let mstr = m > 9 ? m : '0' + m;

        let s = Math.floor(time % 60);
        let sstr = s > 9 ? s : '0' + s;

        t = mstr + ':' + sstr;

        return t;
    }
}