(function (global, factory) {
	typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('tslib')) :
	typeof define === 'function' && define.amd ? define(['tslib'], factory) :
	(global = global || self, global.superman = factory(global.tslib));
}(this, (function (tslib) { 'use strict';

	var props = {};
	function prepareProps() {
	    var metaProps = getProps();
	    engine.injectProp(props, metaProps);
	}
	function injectProps(p) {
	    engine.injectProp(props, p);
	}
	//# sourceMappingURL=props.js.map

	var GTime = (function () {
	    function GTime() {
	    }
	    GTime.getTimestamp = function () {
	        return new Date().getTime();
	    };
	    GTime.GetTimeHMS = function (time) {
	        var t;
	        var h = Math.floor(time / 3600);
	        var hstr = h > 9 ? h : '0' + h;
	        var m = Math.floor((time % 3600) / 60);
	        var mstr = m > 9 ? m : '0' + m;
	        var s = Math.floor(time % 60);
	        var sstr = s > 9 ? s : '0' + s;
	        t = hstr + ':' + mstr + ':' + sstr;
	        return t;
	    };
	    GTime.GetTimeMS = function (time) {
	        var t;
	        var m = Math.floor((time % 3600) / 60);
	        var mstr = m > 9 ? m : '0' + m;
	        var s = Math.floor(time % 60);
	        var sstr = s > 9 ? s : '0' + s;
	        t = mstr + ':' + sstr;
	        return t;
	    };
	    return GTime;
	}());
	//# sourceMappingURL=GTime.js.map

	function getTexture(uuid) {
	    return engine.Texture.from(getAssetByUUID(uuid).uuid);
	}
	function createSvga(name, anchorName) {
	    var inst = new svga.Svga();
	    inst.source = 'asset://' + engine.getAssetByName(name).uuid;
	    return inst;
	}
	function clickLog(exposure) {
	    var net = {
	        name: 'clickLog',
	        uri: '/log/click',
	        type: 'get',
	        dataType: 'jsonp',
	        param: exposure,
	        callback: null,
	        hideMsg: true
	    };
	    send(net);
	}
	function showLog(exposure) {
	    var net = {
	        name: 'showLog',
	        uri: exposure.domain + '/exposure/standard',
	        type: 'get',
	        dataType: 'jsonp',
	        param: exposure,
	        callback: null,
	        hideMsg: true
	    };
	    send(net);
	}
	function send(net) {
	    var gTime = '?_=' + GTime.getTimestamp();
	    var realUrl = net.uri;
	    if (realUrl.indexOf('?') != -1) {
	        gTime = '&_=' + GTime.getTimestamp();
	    }
	    if (net.addUrl) {
	        realUrl += net.addUrl;
	    }
	    window['$'].ajax({
	        type: net.type,
	        url: realUrl,
	        cache: false,
	        dataType: net.dataType,
	        data: net.param,
	        async: true,
	    });
	}
	//# sourceMappingURL=utils.js.map

	var Buried = (function () {
	    function Buried() {
	    }
	    Buried.init = function () {
	    };
	    Buried.createExposure = function (dpm, dcm, embedDomain) {
	        if (embedDomain === void 0) { embedDomain = '//embedlog.duiba.com.cn'; }
	        var exposure = {
	            dpm: dpm,
	            dcm: dcm,
	            appId: Buried.appId,
	            domain: embedDomain
	        };
	        return exposure;
	    };
	    Buried.connectDpm = function (pageId, area, dpm) {
	        return Buried.appId + '.' + pageId + '.' + area + '.' + dpm;
	    };
	    Buried.connectDcm = function (typeId, contentInfo, dcm) {
	        return typeId + '.' + Buried.oaId + '.' + contentInfo + '.' + dcm;
	    };
	    Buried.connectPlugDcm = function (plugId, type) {
	        return 212 + '.' + plugId + '.' + type + '.' + Buried.oaId;
	    };
	    Buried.connectActivityDcm = function (type) {
	        return 202 + '.' + Buried.oaId + '.' + type + '.' + Buried.oaId;
	    };
	    Buried.appId = '0';
	    Buried.oaId = "0";
	    return Buried;
	}());
	//# sourceMappingURL=Buried.js.map

	var getlogItem = function (i) {
	    var Dpm = Buried.connectDpm(110, i, 1);
	    var Dcm = Buried.connectDcm(202, 0, 0);
	    return Buried.createExposure(Dpm, Dcm);
	};
	//# sourceMappingURL=getlogItem.js.map

	var QAText = (function (_super) {
	    tslib.__extends(QAText, _super);
	    function QAText() {
	        var _this = _super.call(this) || this;
	        _this.bg = [];
	        _this.bgTexture = [];
	        _this.QLabel = [];
	        _this.ALabel = [];
	        _this.addEventListener(engine.Event.ADDED_TO_STAGE, _this.setup, _this);
	        _this.init();
	        return _this;
	    }
	    QAText.prototype.init = function () {
	        var that = this;
	        that.bigBgOrigin = new engine.Point();
	        that.smallBgOrigin = new engine.Point();
	        that.QText = props.QTextStrArr.split(',');
	        that.QText.unshift('你想问哪些问题？');
	        console.log(props.QTextStrArr.split(','));
	        that.AText = props.ATextStrArr.split(',');
	        console.log(props.ATextStrArr.split(','));
	        that.ActText = props.ACTTextStrArr.split(',');
	        console.log(props.ACTTextStrArr.split(','));
	    };
	    QAText.prototype.setup = function () {
	        var that = this;
	        that.removeEventListener(engine.Event.ADDED_TO_STAGE, that.setup, that);
	        that.hideText();
	        that.setGroup();
	        that.setQLabel();
	        that.setALabel();
	        that.setActLabel();
	        that.setEvent();
	    };
	    QAText.prototype.setEvent = function () {
	    };
	    QAText.prototype.setGroup = function () {
	        var that = this;
	        that.QlabelGroup = new engine.Sprite();
	        that.addChild(that.QlabelGroup);
	        that.QlabelGroup.visible = false;
	        that.AlabelGroup = new engine.Sprite();
	        that.addChild(that.AlabelGroup);
	        that.AlabelGroup.visible = false;
	        that.ActlabelGroup = new engine.Sprite();
	        that.addChild(that.ActlabelGroup);
	        that.ActlabelGroup.visible = false;
	        for (var i = 0; i < 3; i++) {
	            var bg = new engine.Image();
	            if (i < 2) {
	                bg.texture = getTexture("21d8b7ca-6ed3-44e5-ada0-f0433f471ac9");
	                if (i == 0) {
	                    that.QlabelGroup.addChild(bg);
	                }
	                else {
	                    that.AlabelGroup.addChild(bg);
	                }
	            }
	            else {
	                bg.texture = getTexture("9e4d1860-4762-4ac1-bc44-b3dd8fb307a6");
	                that.ActlabelGroup.addChild(bg);
	            }
	            that.bg.push(bg);
	        }
	        that.closeBtn = new engine.Image(getTexture("76f2c800-2174-4a90-ad6d-5853e95eb144"));
	        that.addChild(that.closeBtn);
	        that.closeBtn.mouseEnabled = true;
	        that.closeBtn.addEventListener(engine.MouseEvent.CLICK, that.hideText, that);
	    };
	    QAText.prototype.setQLabel = function () {
	        var that = this;
	        for (var i = 0; i < that.QText.length; i++) {
	            var label = new engine.Label();
	            label.text = that.QText[i];
	            label.x = 40;
	            label.width = that.bg[0].width - 50;
	            if (i <= 1) {
	                label.y = 30 + i * 60;
	            }
	            else {
	                label.y = 30 + 60 + (i - 1) * 50;
	            }
	            if (i == 0) {
	                label.size = 34;
	            }
	            else {
	                var img = new engine.Image(getTexture("8546dcf7-a6e8-4ba2-89f7-b929118e473a"));
	                img.y = label.y;
	                img.x = that.getBigBgSize().w - img.width - 36;
	                that.QlabelGroup.addChild(img);
	                img.mouseEnabled = true;
	                img.addEventListener(engine.MouseEvent.CLICK, that.showALabelGroup, that);
	                label.fillColor = "#d36800";
	                label.size = 24;
	            }
	            label.name = 'Q_' + i;
	            if (i > 0) {
	                label.mouseEnabled = true;
	                label.addEventListener(engine.MouseEvent.CLICK, that.showALabelGroup, that);
	            }
	            that.QlabelGroup.addChild(label);
	            that.QLabel.push(label);
	        }
	    };
	    QAText.prototype.setALabel = function () {
	        var that = this;
	        for (var i = 0; i < 2; i++) {
	            var label = new engine.Label();
	            label.x = 40;
	            label.y = 100 + i * 60;
	            label.size = 24;
	            label.width = that.bg[0].width - 50;
	            that.AlabelGroup.addChild(label);
	            that.ALabel.push(label);
	        }
	        that.returnBtn = new engine.Image(getTexture('2a555da9-dc05-4046-a5fb-551f0c2692fa'));
	        that.AlabelGroup.addChild(that.returnBtn);
	        that.returnBtn.x = 18;
	        that.returnBtn.y = 20;
	        that.returnBtn.mouseEnabled = true;
	        that.returnBtn.addEventListener(engine.MouseEvent.CLICK, that.showQLabelGroup, that);
	    };
	    QAText.prototype.setActLabel = function () {
	        var that = this;
	        that.ActLabel = new engine.Label();
	        that.ActlabelGroup.addChild(that.ActLabel);
	        that.ActLabel.x = 0;
	        that.ActLabel.y = that.getSmallBgSize().h * 0.5 - 24;
	        that.ActLabel.width = that.getSmallBgSize().w;
	        that.ActLabel.textAlign = engine.TEXT_ALIGN.CENTER;
	        that.ActLabel.size = 24;
	    };
	    QAText.prototype.showQLabelGroup = function (e) {
	        var that = this;
	        if (e && e.target == that.returnBtn) {
	            if (props.type == 0) {
	                clickLog(getlogItem(30));
	            }
	            else if (props.type == 1) {
	                clickLog(getlogItem(80));
	            }
	        }
	        that.x = that.bigBgOrigin.x;
	        that.y = that.bigBgOrigin.y;
	        that.closeBtn.x = that.bg[0].width - that.closeBtn.width - 20;
	        that.closeBtn.y = 20;
	        that.AlabelGroup.visible = false;
	        that.ActlabelGroup.visible = false;
	        that.QlabelGroup.visible = true;
	        that.showText();
	    };
	    QAText.prototype.showALabelGroup = function (e) {
	        console.log("展示答案" + e.target.name);
	        var that = this;
	        that.x = that.bigBgOrigin.x;
	        that.y = that.bigBgOrigin.y;
	        that.closeBtn.x = that.bg[0].width - that.closeBtn.width - 20;
	        that.closeBtn.y = 20;
	        var label = e.target;
	        var str = label.name.split('_');
	        if (str && str.length > 0)
	            var index = str[1];
	        that.ALabel[0].text = that.QText[index];
	        that.ALabel[1].text = that.AText[index - 1];
	        that.QlabelGroup.visible = false;
	        that.ActlabelGroup.visible = false;
	        that.AlabelGroup.visible = true;
	        that.showText();
	        if (props.type == 0) {
	            showLog(getlogItem(30));
	        }
	        else if (props.type == 1) {
	            showLog(getlogItem(80));
	        }
	    };
	    QAText.prototype.showActLabelGroup = function (type) {
	        var index = type;
	        var that = this;
	        that.x = that.smallBgOrigin.x;
	        that.y = that.smallBgOrigin.y;
	        that.closeBtn.x = that.bg[2].width - that.closeBtn.width - 10;
	        that.closeBtn.y = 20;
	        that.ActLabel.text = that.ActText[index];
	        that.QlabelGroup.visible = false;
	        that.AlabelGroup.visible = false;
	        that.ActlabelGroup.visible = true;
	        that.showText();
	        if (!that.actLabelTimer) {
	            that.actLabelTimer = setTimeout(function () {
	                that.ActlabelGroup.visible = false;
	                that.hideText();
	                clearTimeout(that.actLabelTimer);
	            }, 3000);
	        }
	        else {
	            clearTimeout(that.actLabelTimer);
	            that.actLabelTimer = setTimeout(function () {
	                that.hideText();
	                that.ActlabelGroup.visible = false;
	            }, 3000);
	        }
	    };
	    QAText.prototype.setBigBgPositon = function (x, y) {
	        this.bigBgOrigin.x = x;
	        this.bigBgOrigin.y = y;
	    };
	    QAText.prototype.setSmallBgPositon = function (x, y) {
	        this.smallBgOrigin.x = x;
	        this.smallBgOrigin.y = y;
	    };
	    QAText.prototype.getBigBgSize = function () {
	        return { w: this.bg[0].width, h: this.bg[0].height };
	    };
	    QAText.prototype.getSmallBgSize = function () {
	        return { w: this.bg[2].width, h: this.bg[2].height };
	    };
	    QAText.prototype.showText = function () {
	        this.visible = true;
	    };
	    QAText.prototype.hideText = function () {
	        if (this.actLabelTimer) {
	            clearTimeout(this.actLabelTimer);
	        }
	        engine.globalEvent.dispatchEvent("hideRect");
	        this.visible = false;
	    };
	    return QAText;
	}(engine.Sprite));

	var TestView = (function (_super) {
	    tslib.__extends(TestView, _super);
	    function TestView() {
	        var _this = _super.call(this) || this;
	        _this.qaisOpen = false;
	        _this.addEventListener(engine.Event.ADDED_TO_STAGE, _this.setup, _this);
	        return _this;
	    }
	    TestView.prototype.setup = function () {
	        var that = this;
	        that.removeEventListener(engine.Event.ADDED_TO_STAGE, this.setup, this);
	        that.rect = new engine.Rect();
	        that.rect.fillColor = "#000000";
	        that.rect.alpha = 0.7;
	        that.rect.width = 2000;
	        that.rect.height = 2000;
	        that.rect.visible = false;
	        that.addChild(that.rect);
	        that.breathSvga = createSvga("常规呼吸动作");
	        that.waveSvga = createSvga("招手");
	        that.waveSvga.visible = false;
	        that.breathSvga.visible = true;
	        that.breathSvga.mouseEnabled = that.waveSvga.mouseEnabled = true;
	        that.addChild(that.breathSvga);
	        that.addChild(that.waveSvga);
	        that.breathSvga.x = that.waveSvga.x = engine.gameStage.stage.width - 178 * 0.7;
	        that.breathSvga.y = that.waveSvga.y = engine.gameStage.stage.height / 3 * 2 - 60;
	        that.breathSvga.gotoAndPlay(1);
	        that.breathSvga.scaleX = that.breathSvga.scaleY = 0.7;
	        that.waveSvga.scaleX = that.waveSvga.scaleY = 0.7;
	        that.QAText = new QAText();
	        that.addChild(that.QAText);
	        that.QAText.setBigBgPositon(engine.gameStage.stage.width - that.QAText.getBigBgSize().w - 35, engine.gameStage.stage.height / 3 * 2 - 60 - that.QAText.getBigBgSize().h);
	        that.QAText.setSmallBgPositon(engine.gameStage.stage.width - that.QAText.getSmallBgSize().w - 35, engine.gameStage.stage.height / 3 * 2 - 60 - that.QAText.getSmallBgSize().h);
	        that.addEvnt();
	    };
	    TestView.prototype.addEvnt = function () {
	        var that = this;
	        that.breathSvga.addEventListener(engine.MouseEvent.CLICK, that.touchSuperManImg, that);
	        that.waveSvga.addEventListener(engine.MouseEvent.CLICK, that.touchSuperManImg, that);
	        engine.globalEvent.addEventListener("pictures-ActLabel", that.showActLabelGroup, that);
	        engine.globalEvent.addEventListener("pictures-supermanAnim", that.supermanAnim, that);
	        engine.globalEvent.addEventListener("hideRect", function () { that.rect.visible = false; }, that);
	    };
	    TestView.prototype.supermanAnim = function () {
	    };
	    TestView.prototype.touchSuperManImg = function (e) {
	        console.log("点击蛋黄超人");
	        var that = this;
	        if (that.QAText.visible)
	            return;
	        if (props.type == 0) {
	            clickLog(getlogItem(17));
	        }
	        else if (props.type == 1) {
	            clickLog(getlogItem(51));
	        }
	        that.showWaveSvga();
	        that.QAText.showQLabelGroup(null);
	        that.rect.visible = true;
	    };
	    TestView.prototype.showActLabelGroup = function (e) {
	        var that = this;
	        that.showWaveSvga();
	        that.QAText.showActLabelGroup(parseInt(e.data.type));
	    };
	    TestView.prototype.showWaveSvga = function () {
	        var that = this;
	        that.breathSvga.visible = false;
	        that.waveSvga.visible = true;
	        that.waveSvga.play(false, false);
	        that.waveSvga.once(engine.Event.END_FRAME, function () {
	            that.waveSvga.visible = false;
	            that.breathSvga.gotoAndPlay(1);
	            that.breathSvga.visible = true;
	        }, that);
	    };
	    return TestView;
	}(engine.Container));
	//# sourceMappingURL=TestView.js.map

	var GameWrapper = (function (_super) {
	    tslib.__extends(GameWrapper, _super);
	    function GameWrapper() {
	        var _this = _super.call(this) || this;
	        engine.globalEvent.addEventListener("pictures-setProjectId", _this.setProjectId, _this);
	        var testView = _this._testView = new TestView();
	        _this.addChild(testView);
	        return _this;
	    }
	    GameWrapper.prototype.setProjectId = function (event) {
	        injectProps(event.data);
	        Buried.oaId = event.data.projectId;
	        Buried.appId = event.data.appId;
	    };
	    GameWrapper.prototype.start = function (event) {
	        injectProps(event.data);
	    };
	    GameWrapper.prototype.stop = function (event) {
	    };
	    return GameWrapper;
	}(engine.Container));
	//# sourceMappingURL=GameWrapper.js.map

	function index (props) {
	    prepareProps();
	    injectProps(props);
	    var instance = new GameWrapper();
	    return instance;
	}
	//# sourceMappingURL=index.js.map

	return index;

})));

//# sourceMappingURL=main.js.map