import {getTexture} from './utils'

import { SmallPlane } from './SmallBall'
import {Bullets} from './Bullets'

export default class TestView extends engine.Container{
    startBtn:engine.Sprite
    stageBg: engine.Sprite;
    gameBg: engine.Sprite;
    planeModel:engine.Sprite;

    constructor(){
        super()
        this.once(engine.Event.ADDED_TO_STAGE, this.setup, this);
    }


    setup(){
        this.stageBg = new engine.Sprite(getTexture('308742a0-0ea2-4610-b34a-a230add82021'))
        this.addChild(this.stageBg)

        this.gameBg = new engine.Sprite(getTexture('76820072-df5a-4ab7-8cb7-10c8cd8605c8'))

        // 开始按钮
        this.startBtn = new engine.Sprite(getTexture('855e3d77-ffff-443d-b884-4f67a2ebe458'))
        this.startBtn.x = (750 - this.startBtn.width) / 2;
        this.startBtn.y = (this.stage.height - this.startBtn.height) / 2 + 300;
        this.stageBg.addChild(this.startBtn)
        this.startBtn.addEventListener(engine.MouseEvent.CLICK,this.onClick,this)
    }

    smallBall:SmallPlane

    planeArray:[
        {
            type:string,
            enemyPlane:Array<any>
        },
        {
            type:string,
            enemyPlane:Array<any>
        },
        {
            type:string,
            enemyPlane:Array<any>
        }
    ] = [
        {
            type:'smallBall',
            enemyPlane:[]
        },
        {
            type:'middleBall',
            enemyPlane:[]
        },
        {
            type:'largeBall',
            enemyPlane:[]
        }
    ]

    bulletArray:any[] = []
    score:number = 0;
    start(){
        // 炮车
        this.planeModel = new engine.Sprite(getTexture('32ec481a-3f75-4c36-95ed-ee97aa936517'))
        this.planeModel.x = (750 - this.planeModel.width) / 2;
        this.planeModel.y = (this.stage.height - this.planeModel.height)
        this.planeModel.addEventListener(engine.MouseEvent.MOUSE_DOWN,this.onDown,this)

        this.gameBg.addChild(this.planeModel)

        let boom = new engine.Sprite(getTexture('38ec6627-efa8-4f7a-9bdc-3c73cea717f1'))


        //敌机
        setInterval(()=>{
            let smallBall = new SmallPlane();
            smallBall.setPosition();

            console.log(this.planeArray);
            for(let planearray of this.planeArray){
                if(planearray.type == smallBall.name){
                    console.log(planearray.enemyPlane)
                    planearray.enemyPlane.push(smallBall)
                }
            }
            
            
            this.gameBg.addChild(smallBall)
        },500)

        // 敌机移动
        setInterval(()=>{
            for(let planearray of this.planeArray){
                if(planearray.type === 'smallBall'){
                    for(let sball of planearray.enemyPlane){
                        console.log(sball)
                        sball.y += 1;
                        if(sball.y > this.stage.height){
                            this.gameBg.removeChild(sball)
                            let index = planearray.enemyPlane.indexOf(sball)
                            planearray.enemyPlane = planearray.enemyPlane.filter((ele,i)=>i != index)
                        }
                    }
                }
            }
        },16)


        // my plane
        setInterval(()=>{
            let bullet = new Bullets();
            bullet.createBullet(this.planeModel);

            this.bulletArray.push(bullet)

            this.gameBg.addChild(bullet)

        },40)

        setInterval(()=>{
            console.log(this.score);
            for(let bullet of this.bulletArray){

                // console.log(bullet,123)

                bullet.y -= 35;
                if(bullet.y < -40){
                    this.gameBg.removeChild(bullet)
                    let index = this.bulletArray.indexOf(bullet)
                    this.bulletArray = this.bulletArray.filter((ele,i)=>i != index)
                }

                // 击中
                for(let planearray of this.planeArray){
                    if(planearray.type === 'smallBall'){
                        for(let splane of planearray.enemyPlane){
                            let y = bullet.y - splane.y;

                            let bulletRight = bullet.x + bullet.width;
                            let planeRange = splane.x + splane.width
                            if(bulletRight > splane.x && bulletRight < planeRange || bullet.x > splane.x && bullet.x < planeRange){
                                if(y <= 0){
                                    // 击中敌机
                                    splane.life -= bullet.harm;
                                    this.score += bullet.harm;
                                    
                                    // 子弹移除
                                    this.gameBg.removeChild(bullet);
                                    let index = this.bulletArray.indexOf(bullet);
                                    this.bulletArray = this.bulletArray.filter((ele,i)=>i != index)

                                    if(splane.life === 0){
                                        this.gameBg.removeChild(splane);
                                        let ind = planearray.enemyPlane.indexOf(splane);
                                        planearray.enemyPlane = planearray.enemyPlane.filter((ele,i)=>i!=ind)

                                        boom.x = splane.x;
                                        boom.y = splane.y;
                                        this.gameBg.addChild(boom);
                                        setTimeout(() => {
                                            this.gameBg.removeChild(boom);
                                        }, 1500);
                                    }

                                }
                            }
                        }
                    }
                }
            }


        },16)



    }


    onClick(){
        this.addChild(this.gameBg);
        this.gameBg.addChild(this.planeModel)
    }
    mouseX:number;
    mouseY:number;
    // 炮车宽度
    centerX:number;
    planeCenterX:number

    onDown(e:engine.MouseEvent){
        this.mouseX = e.localX
        this.mouseY = e.localY
        this.stage.addEventListener(engine.MouseEvent.MOUSE_MOVE,this.onMove,this)

        this.planeModel.x = e.stageX - this.mouseX;
        this.planeCenterX = this.planeModel.x + this.planeModel.width / 2;
    }

    onMove(e:engine.MouseEvent){
        // 炮车移动范围
        this.centerX = this.planeModel.width / 2;
        let movedCenter = this.centerX + e.stageX - this.mouseX;
        if(movedCenter < 0){
            this.planeModel.x = -this.centerX;
        } else if(movedCenter >750){
            this.planeModel.x = 750 - this.centerX;
        } else {
            this.planeModel.x = e.stageX - this.mouseX;
            this.planeCenterX = this.planeModel.x + this.planeModel.width / 2;

        }
    }

    stop(){

    }

}