/**
 * Created by rockyl on 2020-02-02.
 *
 * 掉落物品
 */
import {getTextureByName} from "./utils";
import {props} from "../props";

export class Goods extends engine.Container {
	private _body:engine.Rect
	private _toY;

	constructor() {
		super();

		let body
		body = this._body =new engine.Rect()
		
		
		let rain = new engine.Sprite(getTextureByName('雨滴'));
		rain["npcType"]="rain"
		let stone = new engine.Sprite(getTextureByName('石块'));
		stone["npcType"]="stone"
		let boom = new engine.Sprite(getTextureByName('炸弹'));
		boom["npcType"]="boom"

		rain.visible=false;
		stone.visible=false;
		boom.visible=false;
		body.addChild(rain)
		body.addChild(stone)
		body.addChild(boom)
		
		this.addChild(body);
		body.width=.0001;
		body.height=.0001;
		body.mouseEnabled=false;
	}


	getRandomNumberByRange(start, end) {
		return Math.floor(Math.random() * (end - start) + start)
	}

	reset() {
		this.visible = true;
		this.rotation = 0;
		this.anchorOffsetY = 0;
		this.y = 0;
		this.x = (750-120)*Math.random()+30;
		this.rotation = 0;
		let random=Math.random()

		if(random<props.goodsProbability[0]){
			this.showNpc("rain")
		}else if(random>=props.goodsProbability[0]&&random<=(props.goodsProbability[0]+props.goodsProbability[1])){
			this.showNpc("stone")
		}else if(random>(props.goodsProbability[0]+props.goodsProbability[1])){
			this.showNpc("boom")
		}
	}


	showNpc(type){
		for(let i=0;i<this._body.children.length;i++){
			this._body.children[i].visible=false;
			this._body.children[i].mouseEnabled=false;
		}

		for(let i=0;i<this._body.children.length;i++){
			if(this._body.children[i]["npcType"]==type){
				this["npcType"]=type
				this._body.children[i].visible=true;
				this._body.children[i].mouseEnabled=false;
			}
		}
		
	}

	set anchorOffsetY(v) {
		this._body.y = v;
	}
}
