(function (global, factory) {
	typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('tslib')) :
	typeof define === 'function' && define.amd ? define(['tslib'], factory) :
	(global = global || self, global['pick-tea'] = factory(global.tslib));
}(this, (function (tslib) { 'use strict';

	var props = {};
	function prepareProps() {
	    var metaProps = getProps();
	    engine.injectProp(props, metaProps);
	}
	function injectProps(p) {
	    engine.injectProp(props, p);
	}
	//# sourceMappingURL=props.js.map

	function getTexture(uuid) {
	    return engine.Texture.from(getAssetByUUID(uuid).uuid);
	}
	function getTextureByName(name) {
	    return getTexture(engine.getAssetByName(name).uuid);
	}
	function playSound(name) {
	    engine.playSound(engine.getAssetByName(name).uuid, { keep: true });
	}
	function createSvga(name, anchorName) {
	    var inst = new svga.Svga();
	    inst.source = 'asset://' + engine.getAssetByName(name).uuid;
	    return inst;
	}
	function showLog(abjname, obj) {
	}
	//# sourceMappingURL=utils.js.map

	var GameView = (function (_super) {
	    tslib.__extends(GameView, _super);
	    function GameView() {
	        var _this = _super.call(this) || this;
	        _this.nowPercentage = 0;
	        _this.goodsItems = [];
	        _this._touchEnabled = true;
	        _this.once(engine.Event.ADDED_TO_STAGE, _this.setup, _this);
	        return _this;
	    }
	    GameView.prototype.setup = function () {
	        if (this._hasSetup) {
	            return;
	        }
	        this._hasSetup = true;
	        this.pickTeaBg = new engine.Container();
	        this.basketLevel = null;
	        this.addChild(this.pickTeaBg);
	        this.teaHalfImg = new engine.Image();
	        this.paperBasketSvga = createSvga("采茶童-纸篮子");
	        this.clothBasketSvga = createSvga("采茶童-布篮子");
	        this.bambooBasketSvga = createSvga("采茶童-竹编篮");
	        this.woodBasketSvga = createSvga("采茶童-木篮子");
	        this.addOneSvga = createSvga("+1");
	        this.pickTeaSvga = createSvga("采茶叶");
	        this.teaSkyUpSvga = createSvga("茶叶向上飞");
	        this.handGraspSvga = createSvga("手抓去");
	        this.frontImg = new engine.Image(getTextureByName('前景'));
	        this.pickTeaBg.addChild(this.paperBasketSvga);
	        this.pickTeaBg.addChild(this.clothBasketSvga);
	        this.pickTeaBg.addChild(this.bambooBasketSvga);
	        this.pickTeaBg.addChild(this.woodBasketSvga);
	        this.pickTeaBg.addChild(this.pickTeaSvga);
	        this.pickTeaBg.addChild(this.teaSkyUpSvga);
	        this.basketSvgaGroup = [this.paperBasketSvga, this.clothBasketSvga, this.bambooBasketSvga, this.woodBasketSvga];
	        this.progressbarBgImg = new engine.Image(getTextureByName('进度条底框'));
	        this.progressbarImg = new engine.Image(getTextureByName('进度'));
	        this.teaHalfFlagImg = new engine.Image(getTextureByName('茶叶进度缺'));
	        this.teaFullFlagImg = new engine.Image(getTextureByName('茶叶进度满'));
	        this.teaStarImg = new engine.Image(getTextureByName('小茶叶'));
	        this.handGraspBgImg = new engine.Image(getTextureByName('茶叶收取底图'));
	        this.verseImg = new engine.Image(getTextureByName('气泡框'));
	        this.pickTeaBg.addChild(this.verseImg);
	        var mask = new engine.Rect();
	        mask.width = 600;
	        mask.height = 50;
	        mask.x = 10;
	        mask.y = 0;
	        mask.alpha = 1;
	        this.progressbarImg.mask = mask;
	        showLog(this.progressbarImg.mask);
	        this.addChild(this.frontImg);
	        this.progressbarBgImg.addChild(this.progressbarImg);
	        this.progressbarBgImg.addChild(mask);
	        this.progressbarBgImg.addChild(this.addOneSvga);
	        this.progressbarBgImg.addChild(this.handGraspBgImg);
	        this.handGraspBgImg.addChild(this.handGraspSvga);
	        this.progressbarBgImg.addChild(this.teaHalfFlagImg);
	        this.progressbarBgImg.addChild(this.teaFullFlagImg);
	        this.progressbarBgImg.addChild(this.teaStarImg);
	        this.pickTeaCount = new engine.Label();
	        this.progressbarBgImg.addChild(this.pickTeaCount);
	        this.addChild(this.progressbarBgImg);
	        this.initView();
	    };
	    GameView.prototype.reset = function () {
	        this.initView();
	    };
	    GameView.prototype.start = function () {
	    };
	    GameView.prototype.pause = function () {
	        this.gameIng = false;
	    };
	    GameView.prototype.revive = function () {
	        this.gameIng = true;
	    };
	    GameView.prototype.resume = function () {
	        this.reset();
	        this.start();
	    };
	    GameView.prototype.initView = function () {
	        this.pickTeaBg.mouseEnabled = false;
	        this.teaHalfImg.visible = false;
	        this.pickTeaSvga.visible = false;
	        this.teaSkyUpSvga.visible = false;
	        this.verseImg.visible = false;
	        this.frontImg.visible = props.showFrontImg == 1;
	        this.initChildrenPos();
	    };
	    GameView.prototype.initChildrenPos = function () {
	        for (var i = 0; i < this.basketSvgaGroup.length; i++) {
	            this.basketSvgaGroup[i].visible = false;
	            this.basketSvgaGroup[i].x = props.basketSvgaPos[0];
	            this.basketSvgaGroup[i].y = props.basketSvgaPos[1];
	        }
	        var pickTeaSVGA = this.basketSvgaGroup[0];
	        this.allFrames = pickTeaSVGA.children.length;
	        this.verseImg.x = props.versePos[0];
	        this.verseImg.y = props.versePos[1];
	        this.addOneSvga.x = props.addOneSvgaPos[0];
	        this.addOneSvga.y = props.addOneSvgaPos[1];
	        this.pickTeaSvga.x = props.pickTeaSvgaPos[0];
	        this.pickTeaSvga.y = props.pickTeaSvgaPos[1];
	        this.teaSkyUpSvga.x = props.teaSkyUpSvgaPos[0];
	        this.teaSkyUpSvga.y = props.teaSkyUpSvgaPos[1];
	        this.handGraspSvga.x = props.handGraspSvgaPos[0];
	        this.handGraspSvga.y = props.handGraspSvgaPos[1];
	        this.handGraspBgImg.x = props.handGraspBgImgPos[0];
	        this.handGraspBgImg.y = props.handGraspBgImgPos[1];
	        this.progressbarBgImg.x = props.progressbarBgImgPos[0];
	        this.progressbarBgImg.y = props.progressbarBgImgPos[1];
	        this.progressbarImg.x = props.progressbarImgPos[0];
	        this.progressbarImg.y = props.progressbarImgPos[1];
	        this.teaHalfFlagImg.x = props.teaHalfFlagImgPos[0];
	        this.teaHalfFlagImg.y = props.teaHalfFlagImgPos[1];
	        this.teaHalfFlagImg.anchorX = this.teaHalfFlagImg.width / 2;
	        this.teaHalfFlagImg.anchorY = this.teaHalfFlagImg.height / 2;
	        this.teaFullFlagImg.x = props.teaHalfFlagImgPos[0];
	        this.teaFullFlagImg.y = props.teaHalfFlagImgPos[1];
	        this.frontImg.x = props.FrontImgPos[0];
	        this.frontImg.y = props.FrontImgPos[1];
	        this.teaFullFlagImg.visible = false;
	        this.teaStarImg.x = props.teaStarImgPos[0];
	        this.teaStarImg.y = props.teaStarImgPos[1];
	        this.pickTeaCount.fillColor = 'white';
	        this.pickTeaCount.size = 30;
	        this.pickTeaCount.text = '';
	        this.pickTeaCount.x = props.pickTeaCountPos[0];
	        this.pickTeaCount.y = props.pickTeaCountPos[1];
	        this.pickTeaCount.height = 50;
	        this.pickTeaCount.width = 200;
	        this.verseLabel = new engine.TextField();
	        this.verseLabel.size = props.verseLabel[2];
	        this.verseLabel.text = '';
	        this.verseLabel.fillColor = props.verseColor[0];
	        this.verseLabel.height = props.verseLabel[1];
	        this.verseLabel.width = props.verseLabel[0];
	        this.verseLabel.strokeColor = props.verseColor[1];
	        this.verseLabel.stroke = 0.5;
	        this.verseLabel.y = 15;
	        this.verseLabel['textHeight'] = 14;
	        this.verseLabel.textAlign = engine.TEXT_ALIGN.CENTER;
	        this.verseImg.visible = false;
	        this.verseImg.addChild(this.verseLabel);
	    };
	    GameView.prototype.showVerse = function () {
	        var _this = this;
	        this.verseImg.visible = true;
	        var len = props.verses.length;
	        var random = Math.floor(Math.random() * len);
	        var verse = props.verses[random];
	        this.verseLabel.text = verse;
	        var y = this.verseImg.y;
	        engine.Tween.get(this.verseImg)
	            .to({ alpha: 0 }, 3000).call(function () {
	            _this.verseImg.visible = false;
	            _this.verseImg.alpha = 1;
	        });
	    };
	    GameView.prototype.setTeaNum = function (TeaNums) {
	        var _this = this;
	        if (this.schedule) {
	            clearInterval(this.schedule);
	        }
	        var totalNum = TeaNums.totalNum;
	        var nowNum = TeaNums.nowNum;
	        this.getTeaPercentage(nowNum, totalNum);
	        var surplus = nowNum - totalNum;
	        if (surplus == 0) {
	            this.gotoMaxLength();
	            return;
	        }
	        var width = this.progressbarImg.width;
	        var myDate = new Date();
	        var nowData = myDate.getTime();
	        var serverData = TeaNums.serverData;
	        var fbdvalue = Math.abs((nowData - serverData));
	        var dataDiff = 0;
	        var x = -width * (1 - (nowNum / totalNum));
	        showLog('原先的X：', this.progressbarImg.x);
	        this.progressbarImg.x = parseFloat(x.toFixed(5)) + this.teaFullFlagImg.width - Math.abs(this.teaFullFlagImg.x);
	        showLog('减去长款的x', this.progressbarImg.x);
	        showLog('this.teaFullFlagImg.width', this.teaFullFlagImg.width);
	        if (this.progressbarImg.x > (this.teaFullFlagImg.width / 2)) {
	            var minus = this.teaFullFlagImg.width - Math.abs(this.teaFullFlagImg.x) - this.progressbarImg.x;
	            this.progressbarImg.x = this.progressbarImg.x - this.teaFullFlagImg.width / 2 + Math.abs(this.teaFullFlagImg.x);
	            showLog('负段x重组', this.progressbarImg.x);
	        }
	        showLog('补宽的X', this.progressbarImg.x);
	        showLog('this.progressbarImg.x', this.progressbarImg.x);
	        var step = (this.teaFullFlagImg.width / 2 - this.progressbarImg.x) / surplus;
	        var speed = props.pickTeaSpeed;
	        if (!this.teaFullRotation) {
	            this.teaFullRotation = engine.Tween.get(this.teaHalfFlagImg, { loop: true })
	                .to({ rotation: 360 }, speed).call(function () {
	                _this.teaHalfFlagImg.rotation = 0;
	            });
	        }
	        this.teaHalfFlagImg.visible = true;
	        this.teaFullFlagImg.visible = !this.teaHalfFlagImg.visible;
	        this.addOneSvga.visible = this.teaHalfFlagImg.visible;
	        engine.Tween.resumeTweens(this.teaFullRotation);
	        this.schedule = setInterval(function () {
	            nowNum++;
	            _this.addOneSvga.play(1, true);
	            if (nowNum == totalNum) {
	                _this.gotoMaxLength();
	                _this.getTeaPercentage(nowNum, totalNum);
	                engine.Tween.pauseTweens(_this.teaFullRotation);
	                return;
	            }
	            if (_this.progressbarImg.x < _this.teaFullFlagImg.width / 2) {
	                _this.progressbarImg.x -= step;
	            }
	            _this.getTeaPercentage(nowNum, totalNum);
	            dataDiff += speed;
	            myDate = new Date();
	            nowData = myDate.getTime();
	            if (Math.abs((nowData - serverData)) - dataDiff > (fbdvalue + 3000)) {
	                showLog(_this.schedule);
	                clearInterval(_this.schedule);
	                engine.Tween.pauseTweens(_this.teaFullRotation);
	                engine.globalEvent.dispatchEvent('event-setchange-TeaNum');
	                _this.addOneSvga.visible = false;
	                _this.addOneSvga.stop();
	                return;
	            }
	        }, speed);
	    };
	    GameView.prototype.getTeaPercentage = function (nowNum, totalNum) {
	        if (nowNum > totalNum) {
	            return;
	        }
	        this.pickTeaCount.text = nowNum + '/' + totalNum;
	        var teaPercentage = 2;
	        var portion = totalNum / 3;
	        if (nowNum < portion) {
	            return;
	        }
	        if (nowNum < (portion * 2)) {
	            teaPercentage = 1;
	        }
	        if (this.nowPercentage != teaPercentage) {
	            this.nowPercentage = teaPercentage;
	            this.updateTeaPercentage(teaPercentage);
	        }
	    };
	    GameView.prototype.gotoMaxLength = function () {
	        if (this.schedule) {
	            clearInterval(this.schedule);
	        }
	        this.progressbarImg.x = this.teaFullFlagImg.width / 2;
	        this.teaHalfFlagImg.visible = false;
	        this.teaFullFlagImg.visible = !this.teaHalfFlagImg.visible;
	        this.addOneSvga.visible = this.teaHalfFlagImg.visible;
	        this.addOneSvga.stop();
	    };
	    GameView.prototype.updateTeaPercentage = function (teaPercentage) {
	        if (teaPercentage === void 0) { teaPercentage = 0; }
	        if (!this.basketLevel)
	            this.basketLevel = 0;
	        var pickTeaSVGA = this.basketSvgaGroup[this.basketLevel];
	        var templength = pickTeaSVGA.children.length;
	        if (this.allFrames < templength) {
	            pickTeaSVGA.removeChildAt(10);
	        }
	        var originframes = pickTeaSVGA.children[7];
	        if (!originframes) {
	            return;
	        }
	        var teaBucketframes = JSON.parse(JSON.stringify(originframes.frames));
	        if (teaPercentage == 1) {
	            this.teaHalfImg = new engine.Image(getTextureByName('茶叶-少'));
	        }
	        else if (teaPercentage == 2) {
	            this.teaHalfImg = new engine.Image(getTextureByName('茶叶-满'));
	        }
	        this.teaHalfImg.visible = false;
	        this.teaHalfImg['frames'] = teaBucketframes;
	        pickTeaSVGA.addChildAt(this.teaHalfImg, 10);
	    };
	    GameView.prototype.setPickTeaLevel = function (level) {
	        this.basketLevel = level;
	        var pickTeaSVGA = this.basketSvgaGroup[level];
	        pickTeaSVGA.visible = true;
	        var originframes = pickTeaSVGA.children[7];
	        this.teaHalfImg.visible = true;
	        var teaBucketframes = JSON.parse(JSON.stringify(originframes.frames));
	        if (this.teaHalfImg) {
	            this.teaHalfImg['frames'] = teaBucketframes;
	        }
	        showLog(this.teaHalfImg);
	        pickTeaSVGA.addChildAt(this.teaHalfImg, 10);
	        pickTeaSVGA.gotoAndPlay(1, true);
	    };
	    GameView.prototype.handGrasp = function () {
	        var that = this;
	        this.updateTeaPercentage(0);
	        setTimeout(function () {
	            engine.Tween.get(that.handGraspSvga)
	                .to({ x: props.handGraspMovePos[0], y: props.handGraspMovePos[1] }, 400).call(function () {
	                that.handGraspSvga.play(1, true);
	                setTimeout(function () {
	                    that.handGraspSvga.stop();
	                    that.handGraspSvga.x = props.handGraspSvgaPos[0];
	                    that.handGraspSvga.y = props.handGraspSvgaPos[1];
	                }, 600);
	                that.pickTeaSvga.visible = true;
	                playSound('采茶叶');
	                that.teaHalfImg.source = '';
	                that.pickTeaSvga.play(1, false);
	            });
	            that.pickTeaSvga.addEventListener(engine.Event.END_FRAME, function () {
	                that.teaSkyUpSvga.visible = true;
	                playSound('茶叶飞起');
	                that.teaSkyUpSvga.play(1, false);
	            });
	            that.teaSkyUpSvga.addEventListener(engine.Event.END_FRAME, function () {
	                that.teaSkyUpSvga.visible = false;
	                console.log('茶叶初始化');
	            });
	        }, 500);
	    };
	    return GameView;
	}(engine.Container));

	var GameWrapper = (function (_super) {
	    tslib.__extends(GameWrapper, _super);
	    function GameWrapper() {
	        var _this = _super.call(this) || this;
	        engine.globalEvent.addEventListener('event-pickTeaGame-init', _this.reset, _this);
	        engine.globalEvent.addEventListener('event-hand-grasp', _this.handGrasp, _this);
	        engine.globalEvent.addEventListener('event-getClick-person', _this.clickPerson, _this);
	        engine.globalEvent.addEventListener('event-getchange-TeaNum', _this.setTeaNum, _this);
	        engine.globalEvent.addEventListener('event-getBasket-Type', _this.setPickTeaLevel, _this);
	        var gameView = _this._gameView = new GameView();
	        _this.addChild(gameView);
	        return _this;
	    }
	    GameWrapper.prototype.setTeaNum = function (event) {
	        injectProps(event.data);
	        this._gameView.setTeaNum(event.data);
	    };
	    GameWrapper.prototype.setPickTeaLevel = function (event) {
	        injectProps(event.data);
	        this._gameView.setPickTeaLevel(event.data);
	    };
	    GameWrapper.prototype.handGrasp = function () {
	        this._gameView.handGrasp();
	    };
	    GameWrapper.prototype.clickPerson = function () {
	        this._gameView.showVerse();
	    };
	    GameWrapper.prototype.reset = function (event) {
	        injectProps(event.data);
	        this._gameView.visible = true;
	        this._gameView.reset();
	    };
	    GameWrapper.prototype.start = function (event) {
	        injectProps(event.data);
	        this._status = 1;
	        this._gameView.start();
	    };
	    GameWrapper.prototype.pause = function () {
	        this._gameView.pause();
	    };
	    GameWrapper.prototype.resume = function () {
	        this._gameView.resume();
	    };
	    GameWrapper.prototype.revive = function () {
	        this._gameView.revive();
	    };
	    GameWrapper.prototype.clear = function () {
	        this._gameView.visible = false;
	    };
	    GameWrapper.prototype.onTap = function (event) {
	    };
	    return GameWrapper;
	}(engine.Container));
	//# sourceMappingURL=GameWrapper.js.map

	function index (props) {
	    prepareProps();
	    injectProps(props);
	    var instance = new GameWrapper();
	    return instance;
	}
	//# sourceMappingURL=index.js.map

	return index;

})));

//# sourceMappingURL=main.js.map