/**
 * Created by renjianfeng on 2020-03-13.
 */


const customId = 'pick-tea';

(async function () {
	let customModule = await fetch(`../meta.json`);
	customModule = await customModule.json();
	console.log(customModule);

	await loadAssets(customModule.assets);
	launchWithCustomModule(customModule);
})();

function launchWithCustomModule(customModule) {
	//engine.registerCustomCodeModule(customModule);
	engine.registerCustomModule(customId, window[customId]);

	const { props: propsOption, assets } = customModule;
	let props = engine.computeProps(customModuleProps, propsOption);
	const customModuleIns = {
		id: customId,
		props,
		assets,
	};

	engine.registerCustomModules([customModuleIns]);
	engine.launchWithConfig({
		options: {
			entrySceneView: 'entry',
		},
		assets: [],
		views: [{
			name: 'entry',
			type: 'node',
			properties: {
				x: 0,
				y: 0,
			}
		}],
	}, null, function () {
		setTimeout(() => {
			engine.addCustomModule(customId, engine.gameStage.sceneContainer.getChildAt(0));
		}, 100);
		//先抛出初始化消息
		setTimeout(() => {
			engine.globalEvent.dispatchEvent('event-pickTeaGame-init');

			//获得引用端的篮子类型event-setBasket-Type event-setchange-TeaNum
			engine.globalEvent.dispatchEvent('event-setBasket-Type');
			engine.globalEvent.dispatchEvent('event-setchange-TeaNum');
		}, 500);
	});

	// +1显示
	engine.globalEvent.addEventListener('event-add-oneScore', (e) => {
		console.log(e.type, e.data);
	});
	// 收集茶叶
	engine.globalEvent.addEventListener('event-pick-tea', (e) => {
		console.log(e.type, e.data);
	});
	// 茶叶散开
	engine.globalEvent.addEventListener('event-tea-skyup', (e) => {
		console.log(e.type, e.data);
	});
	// 茶叶上升
	engine.globalEvent.addEventListener('event-hand-grasp', (e) => {
		console.log(e.type, e.data);
	});
	// 改变篮子里的茶叶
	engine.globalEvent.addEventListener('event-change-TeaNum', (e) => {
		console.log(e.type, e.data);
	});
}

function getAssetByUUID(uuid) {
	return engine.resolveCustomAsset(customId, uuid);
}

function getProps() {
	return engine.getProps(customId);
}
