import {getTexture} from './utils'
import {props} from "../props";
import {Card} from "./Card"
import {getRandomArray} from './utils'
export default class TestView extends engine.Container{
    cardArr:Card[] = [];
    cardDataArr:any[] = [];
    imgArr1:string[] = [];   //卡牌正面图片组
    imgArr2:string[] = [];
    imgArr3:string[] = [];
    imgArr:any[] = [];
    cardDataArr1:any[] = [];
    cardDataArr2:any[] = [];
    cardDataArr3:any[] = [];
    flipCardArr:Card[] = [];
    curLevel:number = 1;    //当前关卡
    canTimeCount:boolean = false;   //是否倒计时
    worldTime:number = 60;
    levelTime:number = 60 //每关时间，可设置
    timeLable:engine.Label;   //游戏倒计时文本
    maxLevel:number = 3;
    offSet:any[] = [{x:85,y:406},{x:35,y:462},{x:61,y:394}]
    rowArr:number[] = [3,4,4]
    gap:number[] = [18,14,12]
    constructor(){
        super()
        this.addEventListener(engine.Event.ADDED_TO_STAGE, this.setup, this);
    }

    setup(){
        var that = this;
        that.removeEventListener(engine.Event.ADDED_TO_STAGE,that.setup,that);
        that.imgArr1 = ["363286e4-6bf0-4061-ac84-b94818ce55de","b4bd55f4-34ba-4745-863b-e129fee5bbfa","e9f5feb6-9b99-4eb4-9c41-a57239a92b60","666aa8d3-663a-497f-aeb6-3cff1cec9dfb","d9be93c8-b6b5-4e03-ae31-a9136a0a551a","b1947d26-1187-42d5-a98f-943bb2abd657"];   //卡牌正面图片组
        that.imgArr2 = ["f5d47e6a-0f14-4184-89ed-1bd3ad716ec9","49e2d1ef-b0a3-4c71-94d2-833d406bf0ea","9e94c64b-419b-47d2-8d27-8f52427d73b5","26fe94fe-d30e-4f9c-be3e-e21a299792a4",
                            "416de8f2-d574-45a5-93dc-cbd5570e9a93","796d4c04-13c8-4264-828e-7c447c3c2a0e","e1be5e2d-dda0-418c-a87e-555d58c5634a","bbdae2da-a08b-4cca-aed4-727ae41890e7"];
        that.imgArr3 = ["cc6dd777-ca82-43dd-9a10-33412d70f226","a64273b1-ec13-4444-84b3-5f17e9f9880b","0d860f2b-06a7-41df-9345-a3b464ab5456","7a8be191-24be-4381-a029-079dcf9c8894",
        "3a5ca73c-121c-440b-849a-14aee2e59a9a","b30aeb80-8e0a-4eac-b79d-611ebb83c590","952007aa-451c-4ed5-bd39-61acbca556e0","e8638bcd-c882-4f42-9ca8-c6d516b8bb8c","cc24a1dc-a70d-48bc-b9c1-0e8214ccf62a","46ff1f64-1e0a-4518-8a79-b5109abcc74e"];
        that.imgArr = [that.imgArr1,that.imgArr2,that.imgArr3];
        that.cardDataArr1 = [0,1,2,3,4,5,0,1,2,3,4,5];
        that.cardDataArr2 = [0,1,2,3,4,5,6,7,0,1,2,3,4,5,6,7];
        that.cardDataArr3 = [0,1,2,3,4,5,6,7,0,1,2,3,4,5,6,7,9,8,9,8];
        that.cardDataArr = [that.cardDataArr1,that.cardDataArr2,that.cardDataArr3];
        that.mouseChildren = false;
        that.curLevel = 1;
        that.canTimeCount = false;
        that.levelTime = props.time;
        that.worldTime = that.levelTime;
        that.timeLable = new engine.Label();
        that.addChild(that.timeLable);
        that.timeLable.width = engine.gameStage.width;
        that.timeLable.height = 34;
        that.timeLable.textAlign = engine.TEXT_ALIGN.CENTER;
        that.timeLable.size = 34;
        that.timeLable.text = "时间："+that.worldTime+".00";
        that.timeLable.x = 28;
        that.timeLable.y = 308;
        that.timeLable.fillColor = 0xffffff;
        that.judgeFirstTimes();
        that.setMap();
        that.setTimer();
        that.addEvnt();
    }

    addEvnt(){
        engine.globalEvent.addEventListener("pictures-reset",this.resetGame,this);
        engine.globalEvent.addEventListener("pictures-start",this.startLevel,this);
    }

    /**重置游戏 */
    resetGame(){
        var that = this; 
        that.curLevel = 1;
        that.initNewLevel();
    }

    /**开始关卡 */
    startLevel(){
        var that = this;
        that.canTimeCount = true;
        that.mouseChildren = true;
    }

    /**初始化一个新关卡 */
    initNewLevel(){
        var that = this;
        that.canTimeCount = false;
        that.mouseChildren = false;
        that.worldTime = that.levelTime;
        that.timeLable.text = "时间："+that.worldTime+".00";
        that.clearCardArr();
        that.judgeFirstTimes();
        that.setMap();
    }

    /**通关 */
    clearLevel(){
        var that = this;
        that.curLevel++;
        if(that.curLevel>3){
            engine.globalEvent.dispatchEvent("pictures-gameClear");
            that.resetGame();
            // console.log("通过最大关卡")
        }
        else{
            engine.globalEvent.dispatchEvent("pictures-nextLevel",{level:that.curLevel});
            that.initNewLevel();
        }
    }

    /**判断用户是否是第一次进入各个关卡 */
    judgeFirstTimes(){
        var that = this;
        if(localStorage.getItem("level"+that.curLevel)){
            getRandomArray(that.cardDataArr[that.curLevel-1]);
            // console.log(that.cardDataArr[that.curLevel-1])
        }else{
            localStorage.setItem("level"+that.curLevel,''+that.curLevel);
            // console.log("用户第一次进入"+that.curLevel+"关卡")
        }
    }

    /**清空卡牌数组 */
    clearCardArr(){
        var that = this;
        for(var i=0;i<that.cardArr.length;i++){
            var card = that.cardArr[i];
            if(card&&card.parent&&card.parent.contains(card)){
                card.parent.removeChild(card);
                that.cardArr.splice(i,1);
                i--;
            }
        }
        that.flipCardArr.splice(0);
    }

    /**设置卡牌图排列 */
    setMap(){
        var that = this;
        var dataArr = that.cardDataArr[that.curLevel-1];
        // console.log(dataArr);
        var row = that.rowArr[that.curLevel-1];
        var offsetX = that.offSet[that.curLevel-1].x;
        var offsetY = that.offSet[that.curLevel-1].y;
        var gap = that.gap[that.curLevel-1];
        for(var i=0;i<dataArr.length;i++){
            var card = new Card(that.curLevel);
            that.addChild(card);
            var data = {
                id:dataArr[i],
                texture:that.imgArr[that.curLevel-1][dataArr[i]]
            }
            card.setCard(data);
            card.setView(that);
            card.x = offsetX+i%row*(card.cardImg.width+gap);
            card.y = offsetY+Math.floor(i/row)*(card.cardImg.height+gap);
            card.addEventListener(engine.MouseEvent.CLICK,that.flipCard,that);
            that.cardArr.push(card);
        }
    }

    /**翻牌逻辑 */
    async flipCard(e:engine.MouseEvent){
        var that = this;
        var card:Card = e.target;
        if(that.flipCardArr.indexOf(card)>=0) return;
        if(that.flipCardArr.length<1){
            that.flipCardArr.push(card);
            card.changeState();
        }else if(that.flipCardArr.length<2){
            that.flipCardArr.push(card);
            if(that.flipCardArr[0]){
                if(card.id == that.flipCardArr[0].id){
                    var card0 = that.flipCardArr[0];
                    card.mouseEnabled = false;
                    that.flipCardArr[0].mouseEnabled = false;
                    that.flipCardArr.splice(0,that.flipCardArr.length);
                    await card.changeState();
                    card.removeCard();
                    card0.removeCard();  
                }
                else{
                    card.changeState();
                }
            }
        }else{
            that.flipCardArr.push(card);
            card.changeState();
            for(var i=0;i<that.flipCardArr.length-1;i++){
                if(that.flipCardArr[i]){
                    that.flipCardArr[i].changeState();
                    that.flipCardArr.splice(i,1);
                    i--;
                }
            }
        }
        // console.log(that.flipCardArr);
    }

    /**从卡牌组中移除卡牌 */
    arrRemove(obj){
        var index = this.cardArr.indexOf(obj);
        // console.log("删除第"+index+"张卡牌")
        if(index>=0){
            this.cardArr.splice(index,1);
        }
        if(this.cardArr.length<=0){
            // console.log("通过第"+this.curLevel+"关")
            this.clearLevel();
        }
    }

    setTimer(){
        setInterval(()=>{
            var that = this;
            if(!that.canTimeCount) return;
            that.worldTime =  that.worldTime - 0.01;
            if(that.worldTime<=0){
                //时间到，挑战完成
                // console.log("游戏失败，挑战完成");
                engine.globalEvent.dispatchEvent("pictures-gameFailed");
                that.resetGame();
            }else{
                var timeS = Math.floor(that.worldTime);
                var timeSS = that.worldTime - timeS;
                var string = timeSS.toFixed(2).split('.')[1];
                that.timeLable.text = "时间："+timeS + "." +string;
            }
        },10)
    }
}